/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state;

import java.util.List;
import org.dspace.AbstractUnitTest;
import org.dspace.utils.DSpace;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.Workflow;
import org.junit.Assert;
import org.junit.Test;

public class WorkflowTest
extends AbstractUnitTest {
    private Workflow defaultWorkflow = (Workflow)new DSpace().getServiceManager().getServiceByName("defaultWorkflow", Workflow.class);
    private Workflow selectSingleReviewer = (Workflow)new DSpace().getServiceManager().getServiceByName("selectSingleReviewer", Workflow.class);
    private Workflow scoreReview = (Workflow)new DSpace().getServiceManager().getServiceByName("scoreReview", Workflow.class);

    @Test
    public void defaultWorkflow() {
        Assert.assertEquals((Object)"reviewstep", (Object)this.defaultWorkflow.getFirstStep().getId());
        List steps = this.defaultWorkflow.getSteps();
        Assert.assertEquals((long)3L, (long)steps.size());
        Assert.assertTrue((boolean)this.containsStepNamed(steps, "reviewstep"));
        Assert.assertTrue((boolean)this.containsStepNamed(steps, "editstep"));
        Assert.assertTrue((boolean)this.containsStepNamed(steps, "finaleditstep"));
    }

    @Test
    public void selectSingleReviewer() {
        Assert.assertEquals((Object)"selectReviewerStep", (Object)this.selectSingleReviewer.getFirstStep().getId());
        List steps = this.selectSingleReviewer.getSteps();
        Assert.assertEquals((long)2L, (long)steps.size());
        Assert.assertTrue((boolean)this.containsStepNamed(steps, "selectReviewerStep"));
        Assert.assertTrue((boolean)this.containsStepNamed(steps, "singleUserReviewStep"));
    }

    @Test
    public void scoreReview() {
        Assert.assertEquals((Object)"scoreReviewStep", (Object)this.scoreReview.getFirstStep().getId());
        List steps = this.scoreReview.getSteps();
        Assert.assertEquals((long)2L, (long)steps.size());
        Assert.assertTrue((boolean)this.containsStepNamed(steps, "scoreReviewStep"));
        Assert.assertTrue((boolean)this.containsStepNamed(steps, "evaluationStep"));
    }

    private boolean containsStepNamed(List<Step> steps, String stepName) {
        for (Step step : steps) {
            if (!step.getId().equalsIgnoreCase(stepName)) continue;
            return true;
        }
        return false;
    }
}

