/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.DBConnection;
import org.dspace.core.I18nUtil;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.test.util.ReflectionTestUtils;

public class ContextTest
extends AbstractUnitTest {
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    private AuthorizeService authorizeServiceSpy;

    @Override
    @Before
    public void init() {
        super.init();
        this.authorizeServiceSpy = (AuthorizeService)Mockito.spy((Object)this.authorizeService);
        ReflectionTestUtils.setField((Object)this.ePersonService, (String)"authorizeService", (Object)this.authorizeServiceSpy);
        ReflectionTestUtils.setField((Object)this.groupService, (String)"authorizeService", (Object)this.authorizeServiceSpy);
    }

    @Test
    public void testGetDBConnection() throws SQLException {
        DBConnection connection = this.context.getDBConnection();
        MatcherAssert.assertThat((String)"testGetDBConnection 0", (Object)connection, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testGetDBConnection 1", (Object)connection.isSessionAlive(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testSetCurrentUser() throws SQLException, AuthorizeException, IOException {
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(this.context)).thenReturn((Object)true);
        EPerson oldUser = this.context.getCurrentUser();
        EPerson newUser = this.ePersonService.create(this.context);
        newUser.setFirstName(this.context, "Jane");
        newUser.setLastName(this.context, "Doe");
        newUser.setEmail("jane@email.com");
        newUser.setCanLogIn(true);
        newUser.setLanguage(this.context, I18nUtil.getDefaultLocale().getLanguage());
        this.context.setCurrentUser(newUser);
        MatcherAssert.assertThat((String)"testSetCurrentUser 0", (Object)this.context.getCurrentUser(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testSetCurrentUser 1", (Object)this.context.getCurrentUser(), (Matcher)CoreMatchers.equalTo((Object)newUser));
        this.context.setCurrentUser(oldUser);
        this.ePersonService.delete(this.context, (DSpaceObject)newUser);
    }

    @Test
    public void testGetCurrentUser() {
        MatcherAssert.assertThat((String)"testGetCurrentUser 0", (Object)this.context.getCurrentUser(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testGetCurrentUser 1", (Object)this.context.getCurrentUser(), (Matcher)CoreMatchers.equalTo((Object)this.eperson));
    }

    @Test
    public void testGetCurrentLocale() {
        MatcherAssert.assertThat((String)"testGetCurrentLocale 0", (Object)this.context.getCurrentLocale(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testGetCurrentLocale 1", (Object)this.context.getCurrentLocale(), (Matcher)CoreMatchers.equalTo((Object)I18nUtil.getDefaultLocale()));
    }

    @Test
    public void testSetCurrentLocale() {
        Locale oldLocale = this.context.getCurrentLocale();
        Locale newLocale = Locale.FRENCH;
        this.context.setCurrentLocale(newLocale);
        MatcherAssert.assertThat((String)"testSetCurrentLocale 0", (Object)this.context.getCurrentLocale(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testSetCurrentLocale 1", (Object)this.context.getCurrentLocale(), (Matcher)CoreMatchers.equalTo((Object)newLocale));
        this.context.setCurrentLocale(oldLocale);
    }

    @Test
    public void testIgnoreAuthorization() {
        this.context.turnOffAuthorisationSystem();
        MatcherAssert.assertThat((String)"testIgnoreAuthorization 0", (Object)this.context.ignoreAuthorization(), (Matcher)CoreMatchers.equalTo((Object)true));
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((String)"testIgnoreAuthorization 1", (Object)this.context.ignoreAuthorization(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testSetExtraLogInfo() {
        String oldValue = this.context.getExtraLogInfo();
        String newValue = "This is some extra log info";
        this.context.setExtraLogInfo(newValue);
        MatcherAssert.assertThat((String)"testSetExtraLogInfo 0", (Object)this.context.getExtraLogInfo(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testSetExtraLogInfo 1", (Object)this.context.getExtraLogInfo(), (Matcher)CoreMatchers.equalTo((Object)newValue));
        this.context.setExtraLogInfo(oldValue);
    }

    @Test
    public void testGetExtraLogInfo() {
        String defaultValue = "";
        MatcherAssert.assertThat((String)"testGetExtraLogInfo 0", (Object)this.context.getExtraLogInfo(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testGetExtraLogInfo 1", (Object)this.context.getExtraLogInfo(), (Matcher)CoreMatchers.equalTo((Object)defaultValue));
    }

    @Test
    public void testComplete() throws SQLException {
        Context instance = new Context();
        MatcherAssert.assertThat((String)"testComplete 0", (Object)instance.getDBConnection(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testComplete 1", (Object)instance.getDBConnection().isSessionAlive(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((String)"testComplete 2", (Object)instance.isValid(), (Matcher)CoreMatchers.equalTo((Object)true));
        instance.complete();
        MatcherAssert.assertThat((String)"testComplete 3", (Object)instance.getDBConnection(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((String)"testComplete 4", (Object)instance.isValid(), (Matcher)CoreMatchers.equalTo((Object)false));
        this.cleanupContext(instance);
    }

    @Test
    public void testComplete2() throws SQLException {
        Context instance = new Context();
        instance.complete();
        instance.complete();
        this.cleanupContext(instance);
    }

    @Test
    public void testCommit() throws SQLException, AuthorizeException, IOException {
        Context instance = new Context();
        MatcherAssert.assertThat((String)"HibernateDBConnection should exist", (Object)instance.getDBConnection(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"Context should be valid", (boolean)instance.isValid());
        Assert.assertTrue((String)"Transaction should be open", (boolean)instance.isTransactionAlive());
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(instance)).thenReturn((Object)true);
        String createdEmail = "myfakeemail@example.com";
        EPerson newUser = this.ePersonService.create(instance);
        newUser.setFirstName(instance, "Tim");
        newUser.setLastName(instance, "Smith");
        newUser.setEmail(createdEmail);
        newUser.setCanLogIn(true);
        newUser.setLanguage(instance, I18nUtil.getDefaultLocale().getLanguage());
        instance.commit();
        MatcherAssert.assertThat((String)"HibernateDBConnection should still be open", (Object)instance.getDBConnection(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"Context should still be valid", (boolean)instance.isValid());
        Assert.assertFalse((String)"DB transaction should be closed", (boolean)instance.isTransactionAlive());
        newUser = (EPerson)instance.reloadEntity((ReloadableEntity)newUser);
        Assert.assertEquals((String)"New user should be created", (Object)newUser.getEmail(), (Object)createdEmail);
        String newEmail = "myrealemail@example.com";
        newUser.setEmail(newEmail);
        instance.commit();
        newUser = (EPerson)instance.reloadEntity((ReloadableEntity)newUser);
        Assert.assertEquals((String)"New email address should be saved", (Object)newUser.getEmail(), (Object)newEmail);
        this.ePersonService.delete(instance, (DSpaceObject)newUser);
        this.cleanupContext(instance);
    }

    @Test
    public void testAbort() throws SQLException, AuthorizeException {
        Context instance = new Context();
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(instance)).thenReturn((Object)true);
        String createdEmail = "susie@email.com";
        EPerson newUser = this.ePersonService.create(instance);
        newUser.setFirstName(instance, "Susan");
        newUser.setLastName(instance, "Doe");
        newUser.setEmail(createdEmail);
        newUser.setCanLogIn(true);
        newUser.setLanguage(instance, I18nUtil.getDefaultLocale().getLanguage());
        instance.abort();
        MatcherAssert.assertThat((String)"testAbort 0", (Object)instance.isValid(), (Matcher)CoreMatchers.equalTo((Object)false));
        Context newInstance = new Context();
        EPerson found = this.ePersonService.findByEmail(newInstance, createdEmail);
        MatcherAssert.assertThat((String)"testAbort 1", (Object)found, (Matcher)CoreMatchers.nullValue());
        this.cleanupContext(instance);
        this.cleanupContext(newInstance);
    }

    @Test
    public void testClose() throws SQLException, AuthorizeException {
        String createdEmail = "susie@email.com";
        try (Context instance = new Context();){
            Mockito.when((Object)this.authorizeServiceSpy.isAdmin(instance)).thenReturn((Object)true);
            EPerson newUser = this.ePersonService.create(instance);
            newUser.setFirstName(instance, "Susan");
            newUser.setLastName(instance, "Doe");
            newUser.setEmail(createdEmail);
            newUser.setCanLogIn(true);
            newUser.setLanguage(instance, I18nUtil.getDefaultLocale().getLanguage());
        }
        Context newInstance = new Context();
        EPerson found = this.ePersonService.findByEmail(newInstance, createdEmail);
        MatcherAssert.assertThat((String)"testClose 0", (Object)found, (Matcher)CoreMatchers.nullValue());
        this.cleanupContext(newInstance);
        newInstance.close();
    }

    @Test
    public void testAbort2() throws SQLException {
        Context instance = new Context();
        instance.abort();
        instance.abort();
        this.cleanupContext(instance);
    }

    @Test
    public void testIsReadOnly() throws SQLException {
        MatcherAssert.assertThat((String)"testIsReadOnly 0", (Object)this.context.isReadOnly(), (Matcher)CoreMatchers.equalTo((Object)false));
        Context instance = new Context(Context.Mode.READ_ONLY);
        MatcherAssert.assertThat((String)"testIsReadOnly 1", (Object)instance.isReadOnly(), (Matcher)CoreMatchers.equalTo((Object)true));
        instance.abort();
        this.cleanupContext(instance);
    }

    @Test
    public void testIsReadOnlyCommit() throws SQLException {
        Context instance = new Context(Context.Mode.READ_ONLY);
        MatcherAssert.assertThat((String)"testIsReadOnly 1", (Object)instance.isReadOnly(), (Matcher)CoreMatchers.equalTo((Object)true));
        try {
            instance.commit();
            Assert.fail();
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof UnsupportedOperationException));
        }
        instance.abort();
        this.cleanupContext(instance);
    }

    @Test
    public void testSetSpecialGroup() throws SQLException {
        Context instance = new Context();
        UUID groupID1 = UUID.randomUUID();
        UUID groupID2 = UUID.randomUUID();
        instance.setSpecialGroup(groupID1);
        instance.setSpecialGroup(groupID2);
        MatcherAssert.assertThat((String)"testSetSpecialGroup 0", (Object)instance.inSpecialGroup(groupID1), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((String)"testSetSpecialGroup 1", (Object)instance.inSpecialGroup(groupID2), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((String)"testSetSpecialGroup 2", (Object)instance.inSpecialGroup(UUID.randomUUID()), (Matcher)CoreMatchers.equalTo((Object)false));
        this.cleanupContext(instance);
    }

    @Test
    public void testGetSpecialGroups() throws SQLException, AuthorizeException, IOException {
        Context instance = new Context();
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(instance)).thenReturn((Object)true);
        Group group = this.groupService.create(instance);
        UUID groupID = group.getID();
        instance.setSpecialGroup(groupID);
        Group adminGroup = this.groupService.findByName(instance, "Administrator");
        UUID adminGroupID = adminGroup.getID();
        instance.setSpecialGroup(adminGroupID);
        List specialGroups = instance.getSpecialGroups();
        MatcherAssert.assertThat((String)"testGetSpecialGroup 0", (Object)specialGroups.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((String)"testGetSpecialGroup 1", (Object)((Group)specialGroups.get(0)), (Matcher)CoreMatchers.equalTo((Object)group));
        MatcherAssert.assertThat((String)"testGetSpecialGroup 1", (Object)((Group)specialGroups.get(1)), (Matcher)CoreMatchers.equalTo((Object)adminGroup));
        this.groupService.delete(instance, (DSpaceObject)group);
        this.cleanupContext(instance);
    }

    @Test
    public void testFinalize() throws Throwable {
        Context instance = new Context();
        instance.finalize();
        MatcherAssert.assertThat((String)"testSetSpecialGroup 0", (Object)instance.isValid(), (Matcher)CoreMatchers.equalTo((Object)false));
        this.cleanupContext(instance);
    }

    @Test
    public void testUpdateDatabase() throws Throwable {
        Context instance = new Context(){

            protected void init() {
                super.init();
                databaseUpdated.set(false);
            }
        };
        MatcherAssert.assertThat((String)"updateDatabase 0", (Object)Context.updateDatabase(), (Matcher)CoreMatchers.equalTo((Object)true));
        this.cleanupContext(instance);
    }
}

