/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.dspace.content.EntityType;
import org.dspace.content.RelationshipType;
import org.dspace.content.RelationshipTypeServiceImpl;
import org.dspace.content.dao.RelationshipTypeDAO;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RelationshipTypeTest {
    @InjectMocks
    private RelationshipTypeServiceImpl relationshipTypeService;
    @Mock
    private RelationshipTypeDAO relationshipTypeDAO;
    private RelationshipType firstRelationshipType;
    private RelationshipType secondRelationshipType;
    private Context context;

    @Before
    public void init() {
        this.firstRelationshipType = (RelationshipType)Mockito.mock(RelationshipType.class);
        this.firstRelationshipType.setId(Integer.valueOf(1));
        this.firstRelationshipType.setLeftType((EntityType)Mockito.mock(EntityType.class));
        this.firstRelationshipType.setRightType((EntityType)Mockito.mock(EntityType.class));
        this.firstRelationshipType.setLeftwardType("isAuthorOfPublication");
        this.firstRelationshipType.setRightwardType("isPublicationOfAuthor");
        this.firstRelationshipType.setLeftMinCardinality(Integer.valueOf(0));
        this.firstRelationshipType.setLeftMaxCardinality(null);
        this.firstRelationshipType.setRightMinCardinality(Integer.valueOf(0));
        this.firstRelationshipType.setRightMinCardinality(null);
        this.secondRelationshipType = (RelationshipType)Mockito.mock(RelationshipType.class);
        this.secondRelationshipType.setId(Integer.valueOf(new Random().nextInt()));
        this.secondRelationshipType.setLeftType((EntityType)Mockito.mock(EntityType.class));
        this.secondRelationshipType.setRightType((EntityType)Mockito.mock(EntityType.class));
        this.secondRelationshipType.setLeftwardType("isProjectOfPerson");
        this.secondRelationshipType.setRightwardType("isPersonOfProject");
        this.secondRelationshipType.setLeftMinCardinality(Integer.valueOf(0));
        this.secondRelationshipType.setLeftMaxCardinality(null);
        this.secondRelationshipType.setRightMinCardinality(Integer.valueOf(0));
        this.secondRelationshipType.setRightMinCardinality(null);
    }

    @Test
    public void testRelationshipTypeFind() throws Exception {
        Mockito.when((Object)((RelationshipType)this.relationshipTypeDAO.findByID((Context)ArgumentMatchers.any(), (Class)ArgumentMatchers.any(), ((Integer)ArgumentMatchers.any(Integer.class)).intValue()))).thenReturn((Object)this.firstRelationshipType);
        RelationshipType found = this.relationshipTypeService.find(this.context, 1);
        this.checkRelationshipTypeValues(found, this.firstRelationshipType);
    }

    @Test
    public void testRelationshipTypeFindByTypesAndLabels() throws Exception {
        Mockito.when((Object)this.relationshipTypeDAO.findbyTypesAndTypeName((Context)ArgumentMatchers.any(), (EntityType)ArgumentMatchers.any(), (EntityType)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)this.firstRelationshipType);
        RelationshipType found = this.relationshipTypeService.findbyTypesAndTypeName(this.context, (EntityType)Mockito.mock(EntityType.class), (EntityType)Mockito.mock(EntityType.class), "mock", "mock");
        this.checkRelationshipTypeValues(found, this.firstRelationshipType);
    }

    @Test
    public void testRelationshipTypeFindAll() throws Exception {
        ArrayList<RelationshipType> mockedList = new ArrayList<RelationshipType>();
        mockedList.add(this.firstRelationshipType);
        mockedList.add(this.secondRelationshipType);
        Mockito.when((Object)this.relationshipTypeDAO.findAll(this.context, RelationshipType.class, Integer.valueOf(-1), Integer.valueOf(-1))).thenReturn(mockedList);
        List foundRelationshipTypes = this.relationshipTypeService.findAll(this.context);
        MatcherAssert.assertThat((Object)foundRelationshipTypes, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)foundRelationshipTypes.size(), (Matcher)IsEqual.equalTo((Object)2));
    }

    @Test
    public void testRelationshipTypeFindByLeftOrRightwardType() throws Exception {
        ArrayList<RelationshipType> mockedList = new ArrayList<RelationshipType>();
        mockedList.add(this.firstRelationshipType);
        Mockito.when((Object)this.relationshipTypeDAO.findByLeftwardOrRightwardTypeName(this.context, "mock", Integer.valueOf(-1), Integer.valueOf(-1))).thenReturn(mockedList);
        List found = this.relationshipTypeService.findByLeftwardOrRightwardTypeName(this.context, "mock");
        MatcherAssert.assertThat((Object)found, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)found.size(), (Matcher)IsEqual.equalTo((Object)1));
        this.checkRelationshipTypeValues((RelationshipType)found.get(0), this.firstRelationshipType);
    }

    @Test
    public void testRelationshipTypefindByEntityType() throws Exception {
        ArrayList<RelationshipType> mockedList = new ArrayList<RelationshipType>();
        mockedList.add(this.firstRelationshipType);
        Mockito.when((Object)this.relationshipTypeDAO.findByEntityType((Context)ArgumentMatchers.any(), (EntityType)ArgumentMatchers.any(), (Integer)ArgumentMatchers.any(), (Integer)ArgumentMatchers.any())).thenReturn(mockedList);
        List found = this.relationshipTypeService.findByEntityType(this.context, (EntityType)Mockito.mock(EntityType.class), Integer.valueOf(-1), Integer.valueOf(-1));
        MatcherAssert.assertThat((Object)found, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)found.size(), (Matcher)IsEqual.equalTo((Object)1));
        this.checkRelationshipTypeValues((RelationshipType)found.get(0), this.firstRelationshipType);
    }

    private void checkRelationshipTypeValues(RelationshipType found, RelationshipType original) {
        MatcherAssert.assertThat((Object)found, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)found.getLeftwardType(), (Matcher)IsEqual.equalTo((Object)original.getLeftwardType()));
        MatcherAssert.assertThat((Object)found.getRightwardType(), (Matcher)IsEqual.equalTo((Object)original.getRightwardType()));
        MatcherAssert.assertThat((Object)found.getLeftType(), (Matcher)IsEqual.equalTo((Object)original.getLeftType()));
        MatcherAssert.assertThat((Object)found.getRightType(), (Matcher)IsEqual.equalTo((Object)original.getRightType()));
        MatcherAssert.assertThat((Object)found.getLeftMinCardinality(), (Matcher)IsEqual.equalTo((Object)original.getLeftMinCardinality()));
        MatcherAssert.assertThat((Object)found.getLeftMaxCardinality(), (Matcher)IsEqual.equalTo((Object)original.getLeftMaxCardinality()));
        MatcherAssert.assertThat((Object)found.getRightMinCardinality(), (Matcher)IsEqual.equalTo((Object)original.getRightMinCardinality()));
        MatcherAssert.assertThat((Object)found.getRightMaxCardinality(), (Matcher)IsEqual.equalTo((Object)original.getRightMaxCardinality()));
    }
}

