/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipMetadataService;
import org.dspace.content.RelationshipMetadataValue;
import org.dspace.content.RelationshipType;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.EntityService;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.content.service.WorkspaceItemService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RelationshipMetadataServiceIT
extends AbstractIntegrationTestWithDatabase {
    protected RelationshipMetadataService relationshipMetadataService = ContentServiceFactory.getInstance().getRelationshipMetadataService();
    protected RelationshipService relationshipService = ContentServiceFactory.getInstance().getRelationshipService();
    protected RelationshipTypeService relationshipTypeService = ContentServiceFactory.getInstance().getRelationshipTypeService();
    protected EntityService entityService = ContentServiceFactory.getInstance().getEntityService();
    protected EntityTypeService entityTypeService = ContentServiceFactory.getInstance().getEntityTypeService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    Item leftItem;
    Item rightItem;
    Collection col;
    Relationship relationship;
    RelationshipType isAuthorOfPublicationRelationshipType;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        this.col = CollectionBuilder.createCollection(this.context, community).build();
        this.leftItem = ItemBuilder.createItem(this.context, this.col).build();
        this.rightItem = ItemBuilder.createItem(this.context, this.col).build();
        this.context.restoreAuthSystemState();
    }

    protected void initPublicationAuthor() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType publicationEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Publication").build();
        EntityType authorEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Author").build();
        this.leftItem = ItemBuilder.createItem(this.context, this.col).withEntityType("Publication").build();
        this.rightItem = ItemBuilder.createItem(this.context, this.col).withEntityType("Author").withPersonIdentifierLastName("familyName").withPersonIdentifierFirstName("firstName").build();
        this.isAuthorOfPublicationRelationshipType = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, publicationEntityType, authorEntityType, "isAuthorOfPublication", "isPublicationOfAuthor", null, null, null, null).build();
        this.relationship = RelationshipBuilder.createRelationshipBuilder(this.context, this.leftItem, this.rightItem, this.isAuthorOfPublicationRelationshipType).build();
        this.context.restoreAuthSystemState();
    }

    private void initPublicationAuthorWithCopyParams(boolean copyToLeft, boolean copyToRight) throws SQLException {
        this.context.turnOffAuthorisationSystem();
        EntityType publicationEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Publication").build();
        EntityType authorEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Author").build();
        this.leftItem = ItemBuilder.createItem(this.context, this.col).withEntityType("Publication").build();
        this.rightItem = ItemBuilder.createItem(this.context, this.col).withEntityType("Author").withPersonIdentifierLastName("familyName").withPersonIdentifierFirstName("firstName").build();
        RelationshipType isAuthorOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, publicationEntityType, authorEntityType, "isAuthorOfPublication", "isPublicationOfAuthor", null, null, null, null).withCopyToLeft(copyToLeft).withCopyToRight(copyToRight).build();
        this.relationship = RelationshipBuilder.createRelationshipBuilder(this.context, this.leftItem, this.rightItem, isAuthorOfPublication).build();
        this.context.restoreAuthSystemState();
    }

    protected void initJournalVolumeIssue() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType journalIssueEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "JournalIssue").build();
        EntityType publicationVolumeEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "JournalVolume").build();
        this.leftItem = ItemBuilder.createItem(this.context, this.col).withEntityType("JournalIssue").withPublicationIssueNumber("2").build();
        this.rightItem = ItemBuilder.createItem(this.context, this.col).withEntityType("JournalVolume").withPublicationVolumeNumber("30").build();
        RelationshipType isIssueOfVolume = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, journalIssueEntityType, publicationVolumeEntityType, "isJournalVolumeOfIssue", "isIssueOfJournalVolume", null, null, null, null).build();
        this.relationship = RelationshipBuilder.createRelationshipBuilder(this.context, this.leftItem, this.rightItem, isIssueOfVolume).build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testGetAuthorRelationshipMetadata() throws Exception {
        this.initPublicationAuthor();
        List authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        MatcherAssert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((MetadataValue)authorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"familyName, firstName"));
        List leftRelationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.leftItem, MetadataSchemaEnum.RELATION.getName(), "isAuthorOfPublication", null, "*");
        MatcherAssert.assertThat((Object)leftRelationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((MetadataValue)leftRelationshipMetadataList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)String.valueOf(this.rightItem.getID())));
        List leftList = this.relationshipMetadataService.getRelationshipMetadata(this.leftItem, true);
        MatcherAssert.assertThat((Object)leftList.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"familyName, firstName"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)"dc"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"contributor"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)"author"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(0)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)("virtual::" + this.relationship.getID())));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(1)).getValue(), (Matcher)CoreMatchers.equalTo((Object)String.valueOf(this.rightItem.getID())));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(1)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)MetadataSchemaEnum.RELATION.getName()));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(1)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"isAuthorOfPublication"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)leftList.get(1)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)("virtual::" + this.relationship.getID())));
        List rightRelationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.rightItem, MetadataSchemaEnum.RELATION.getName(), "isPublicationOfAuthor", null, "*");
        MatcherAssert.assertThat((Object)rightRelationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((MetadataValue)rightRelationshipMetadataList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)String.valueOf(this.leftItem.getID())));
        List rightList = this.relationshipMetadataService.getRelationshipMetadata(this.rightItem, true);
        MatcherAssert.assertThat((Object)rightList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)rightList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)String.valueOf(this.leftItem.getID())));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)rightList.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)MetadataSchemaEnum.RELATION.getName()));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)rightList.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"isPublicationOfAuthor"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)rightList.get(0)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)("virtual::" + this.relationship.getID())));
    }

    @Test
    public void testDeleteAuthorRelationshipCopyToLeftItem() throws Exception {
        this.initPublicationAuthor();
        this.context.turnOffAuthorisationSystem();
        List authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        MatcherAssert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        List plainMetadataAuthorList = this.leftItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getQualifier() != null && metadataValue.getMetadataField().getQualifier().equals("author")).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)plainMetadataAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List plainRelationshipMetadataList = this.leftItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getElement().equals("isAuthorOfPublication")).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)plainRelationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        this.relationshipService.delete(this.context, this.relationship, true, false);
        this.context.restoreAuthSystemState();
        plainMetadataAuthorList = this.leftItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getQualifier() != null && metadataValue.getMetadataField().getQualifier().equals("author")).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)plainMetadataAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        MatcherAssert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((MetadataValue)authorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"familyName, firstName"));
        MatcherAssert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)"dc"));
        MatcherAssert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"contributor"));
        MatcherAssert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)"author"));
        Assert.assertNull((Object)((MetadataValue)authorList.get(0)).getAuthority());
        plainRelationshipMetadataList = this.leftItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getElement().equals("isAuthorOfPublication")).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)plainRelationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        List relationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.leftItem, MetadataSchemaEnum.RELATION.getName(), "isAuthorOfPublication", null, "*");
        MatcherAssert.assertThat((Object)relationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        List list = this.relationshipMetadataService.getRelationshipMetadata(this.leftItem, true);
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testAuthorDeleteRelationshipCopyToRightItem() throws Exception {
        this.initPublicationAuthor();
        this.context.turnOffAuthorisationSystem();
        this.relationshipService.delete(this.context, this.relationship, false, true);
        this.context.restoreAuthSystemState();
        List authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        MatcherAssert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List relationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.leftItem, MetadataSchemaEnum.RELATION.getName(), "isAuthorOfPublication", null, "*");
        MatcherAssert.assertThat((Object)relationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)this.rightItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getElement().equals("isPublicationOfAuthor")).collect(Collectors.toList()).size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.itemService.getMetadata((DSpaceObject)this.rightItem, MetadataSchemaEnum.RELATION.getName(), "isPublicationOfAuthor", null, "*").size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testDeleteAuthorRelationshipCopyToBothItems() throws Exception {
        this.initPublicationAuthor();
        this.context.turnOffAuthorisationSystem();
        List authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        MatcherAssert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        List plainMetadataAuthorList = this.leftItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getQualifier() != null && metadataValue.getMetadataField().getQualifier().equals("author")).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)plainMetadataAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List plainRelationshipMetadataList = this.leftItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getElement().equals("isAuthorOfPublication")).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)plainRelationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        this.relationshipService.delete(this.context, this.relationship, true, true);
        this.context.restoreAuthSystemState();
        plainMetadataAuthorList = this.leftItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getQualifier() != null && metadataValue.getMetadataField().getQualifier().equals("author")).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)plainMetadataAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        MatcherAssert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((MetadataValue)authorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"familyName, firstName"));
        MatcherAssert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)"dc"));
        MatcherAssert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"contributor"));
        MatcherAssert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)"author"));
        Assert.assertNull((Object)((MetadataValue)authorList.get(0)).getAuthority());
        Assert.assertEquals((long)1L, (long)this.rightItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getElement().equals("isPublicationOfAuthor")).collect(Collectors.toList()).size());
        Assert.assertEquals((long)1L, (long)this.itemService.getMetadata((DSpaceObject)this.rightItem, MetadataSchemaEnum.RELATION.getName(), "isPublicationOfAuthor", null, "*").size());
        Assert.assertEquals((long)1L, (long)this.leftItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getElement().equals("isAuthorOfPublication")).collect(Collectors.toList()).size());
        Assert.assertEquals((long)1L, (long)this.itemService.getMetadata((DSpaceObject)this.leftItem, MetadataSchemaEnum.RELATION.getName(), "isAuthorOfPublication", null, "*").size());
    }

    @Test
    public void testGetJournalRelationshipMetadata() throws Exception {
        this.initJournalVolumeIssue();
        List volumeList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "publicationvolume", "volumeNumber", null, "*");
        MatcherAssert.assertThat((Object)volumeList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((MetadataValue)volumeList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"30"));
        List issueList = this.itemService.getMetadata((DSpaceObject)this.rightItem, "publicationissue", "issueNumber", null, "*");
        MatcherAssert.assertThat((Object)issueList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((MetadataValue)issueList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"2"));
        List issueRelList = this.relationshipMetadataService.getRelationshipMetadata(this.leftItem, true);
        MatcherAssert.assertThat((Object)issueRelList.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)issueRelList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"30"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)issueRelList.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)"publicationvolume"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)issueRelList.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"volumeNumber"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)issueRelList.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo(null));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)issueRelList.get(0)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)("virtual::" + this.relationship.getID())));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)issueRelList.get(1)).getValue(), (Matcher)CoreMatchers.equalTo((Object)String.valueOf(this.rightItem.getID())));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)issueRelList.get(1)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)MetadataSchemaEnum.RELATION.getName()));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)issueRelList.get(1)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"isJournalVolumeOfIssue"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)issueRelList.get(1)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)("virtual::" + this.relationship.getID())));
        List volumeRelList = this.relationshipMetadataService.getRelationshipMetadata(this.rightItem, true);
        MatcherAssert.assertThat((Object)volumeRelList.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"2"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)"publicationissue"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"issueNumber"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo(null));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(0)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)("virtual::" + this.relationship.getID())));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(1)).getValue(), (Matcher)CoreMatchers.equalTo((Object)String.valueOf(this.leftItem.getID())));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(1)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)MetadataSchemaEnum.RELATION.getName()));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(1)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"isIssueOfJournalVolume"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(1)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)("virtual::" + this.relationship.getID())));
    }

    @Test
    public void testDeleteJournalRelationshipCopyToLeftItem() throws Exception {
        this.initJournalVolumeIssue();
        this.context.turnOffAuthorisationSystem();
        this.relationshipService.delete(this.context, this.relationship, true, false);
        this.context.restoreAuthSystemState();
        List volumeList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "publicationvolume", "volumeNumber", null, "*");
        MatcherAssert.assertThat((Object)volumeList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((MetadataValue)volumeList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"30"));
        List issueList = this.itemService.getMetadata((DSpaceObject)this.rightItem, "publicationissue", "issueNumber", null, "*");
        MatcherAssert.assertThat((Object)issueList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testJournalDeleteRelationshipCopyToRightItem() throws Exception {
        this.initJournalVolumeIssue();
        this.context.turnOffAuthorisationSystem();
        this.relationshipService.delete(this.context, this.relationship, false, true);
        this.context.restoreAuthSystemState();
        List volumeList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "publicationvolume", "volumeNumber", null, "*");
        MatcherAssert.assertThat((Object)volumeList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List issueList = this.itemService.getMetadata((DSpaceObject)this.rightItem, "publicationissue", "issueNumber", null, "*");
        MatcherAssert.assertThat((Object)issueList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((MetadataValue)issueList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"2"));
    }

    @Test
    public void testDeleteJournalRelationshipCopyToBothItems() throws Exception {
        this.initJournalVolumeIssue();
        this.context.turnOffAuthorisationSystem();
        this.relationshipService.delete(this.context, this.relationship, true, true);
        this.context.restoreAuthSystemState();
        List volumeList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "publicationvolume", "volumeNumber", null, "*");
        MatcherAssert.assertThat((Object)volumeList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((MetadataValue)volumeList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"30"));
        List issueList = this.itemService.getMetadata((DSpaceObject)this.rightItem, "publicationissue", "issueNumber", null, "*");
        MatcherAssert.assertThat((Object)issueList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((MetadataValue)issueList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"2"));
    }

    @Test
    public void testDeleteAuthorRelationshipCopyToLeftItemFromDefaultInDb() throws Exception {
        this.initPublicationAuthorWithCopyParams(true, false);
        this.context.turnOffAuthorisationSystem();
        List authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        MatcherAssert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        List plainMetadataAuthorList = this.leftItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getQualifier() != null && metadataValue.getMetadataField().getQualifier().equals("author")).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)plainMetadataAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List plainRelationshipMetadataList = this.leftItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getElement().equals("isAuthorOfPublication")).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)plainRelationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        this.relationshipService.delete(this.context, (Object)this.relationship);
        this.context.restoreAuthSystemState();
        plainMetadataAuthorList = this.leftItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getQualifier() != null && metadataValue.getMetadataField().getQualifier().equals("author")).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)plainMetadataAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        MatcherAssert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((MetadataValue)authorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"familyName, firstName"));
        MatcherAssert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)"dc"));
        MatcherAssert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"contributor"));
        MatcherAssert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)"author"));
        Assert.assertNull((Object)((MetadataValue)authorList.get(0)).getAuthority());
        plainRelationshipMetadataList = this.leftItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getElement().equals("isAuthorOfPublication")).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)plainRelationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        List relationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.leftItem, MetadataSchemaEnum.RELATION.getName(), "isAuthorOfPublication", null, "*");
        MatcherAssert.assertThat((Object)relationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        List list = this.relationshipMetadataService.getRelationshipMetadata(this.leftItem, true);
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testAuthorDeleteRelationshipCopyToRightItemFromDefaultInDb() throws Exception {
        this.initPublicationAuthorWithCopyParams(false, true);
        this.context.turnOffAuthorisationSystem();
        this.relationshipService.delete(this.context, (Object)this.relationship);
        this.context.restoreAuthSystemState();
        List authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        MatcherAssert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List relationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.leftItem, MetadataSchemaEnum.RELATION.getName(), "isAuthorOfPublication", null, "*");
        MatcherAssert.assertThat((Object)relationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)this.rightItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getElement().equals("isPublicationOfAuthor")).collect(Collectors.toList()).size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.itemService.getMetadata((DSpaceObject)this.rightItem, MetadataSchemaEnum.RELATION.getName(), "isPublicationOfAuthor", null, "*").size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testDeleteAuthorRelationshipCopyToBothItemsFromDefaultsInDb() throws Exception {
        this.initPublicationAuthorWithCopyParams(true, true);
        this.context.turnOffAuthorisationSystem();
        List authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        MatcherAssert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        List plainMetadataAuthorList = this.leftItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getQualifier() != null && metadataValue.getMetadataField().getQualifier().equals("author")).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)plainMetadataAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List plainRelationshipMetadataList = this.leftItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getElement().equals("isAuthorOfPublication")).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)plainRelationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        this.relationshipService.delete(this.context, (Object)this.relationship);
        this.context.restoreAuthSystemState();
        plainMetadataAuthorList = this.leftItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getQualifier() != null && metadataValue.getMetadataField().getQualifier().equals("author")).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)plainMetadataAuthorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        MatcherAssert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((MetadataValue)authorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"familyName, firstName"));
        MatcherAssert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)"dc"));
        MatcherAssert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"contributor"));
        MatcherAssert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)"author"));
        Assert.assertNull((Object)((MetadataValue)authorList.get(0)).getAuthority());
        MatcherAssert.assertThat((Object)this.leftItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getElement().equals("isAuthorOfPublication")).collect(Collectors.toList()).size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.itemService.getMetadata((DSpaceObject)this.leftItem, MetadataSchemaEnum.RELATION.getName(), "isAuthorOfPublication", null, "*").size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.rightItem.getMetadata().stream().filter(metadataValue -> metadataValue.getMetadataField().getElement().equals("isPublicationOfAuthor")).collect(Collectors.toList()).size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.itemService.getMetadata((DSpaceObject)this.rightItem, MetadataSchemaEnum.RELATION.getName(), "isPublicationOfAuthor", null, "*").size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testGetNextRightPlace() throws Exception {
        MatcherAssert.assertThat((Object)this.relationshipService.findNextRightPlaceByRightItem(this.context, this.rightItem), (Matcher)CoreMatchers.equalTo((Object)0));
        this.initPublicationAuthor();
        MatcherAssert.assertThat((Object)this.relationshipService.findNextRightPlaceByRightItem(this.context, this.rightItem), (Matcher)CoreMatchers.equalTo((Object)1));
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection col = CollectionBuilder.createCollection(this.context, community).build();
        Item secondItem = ItemBuilder.createItem(this.context, col).withEntityType("Publication").build();
        RelationshipBuilder.createRelationshipBuilder(this.context, secondItem, this.rightItem, this.isAuthorOfPublicationRelationshipType).build();
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((Object)this.relationshipService.findNextRightPlaceByRightItem(this.context, this.rightItem), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void testGetNextLeftPlace() throws Exception {
        MatcherAssert.assertThat((Object)this.relationshipService.findNextLeftPlaceByLeftItem(this.context, this.leftItem), (Matcher)CoreMatchers.equalTo((Object)0));
        this.initPublicationAuthor();
        MatcherAssert.assertThat((Object)this.relationshipService.findNextLeftPlaceByLeftItem(this.context, this.leftItem), (Matcher)CoreMatchers.equalTo((Object)1));
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection col = CollectionBuilder.createCollection(this.context, community).build();
        Item secondAuthor = ItemBuilder.createItem(this.context, col).withEntityType("Author").withPersonIdentifierFirstName("firstName").withPersonIdentifierLastName("familyName").build();
        RelationshipBuilder.createRelationshipBuilder(this.context, this.leftItem, secondAuthor, this.isAuthorOfPublicationRelationshipType).build();
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((Object)this.relationshipService.findNextLeftPlaceByLeftItem(this.context, this.leftItem), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void testGetVirtualMetadata() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        EntityType publicationEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Publication").build();
        EntityType journalIssueEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "JournalIssue").build();
        EntityType journalVolumeEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "JournalVolume").build();
        EntityType journalEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Journal").build();
        RelationshipType isJournalVolumeOfIssueRelationshipType = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, journalIssueEntityType, journalVolumeEntityType, "isIssueOfJournalVolume", "isJournalVolumeOfIssue", null, null, null, null).build();
        RelationshipType isJournalVolumeOfJournalRelationshipType = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, journalVolumeEntityType, journalEntityType, "isJournalOfVolume", "isVolumeOfJournal", null, null, null, null).build();
        RelationshipType isJournalIssueOfPublicationRelationshipType = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, publicationEntityType, journalIssueEntityType, "isJournalIssueOfPublication", "isPublicationOfJournalIssue", null, null, null, null).build();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).build();
        Item journalIssue = ItemBuilder.createItem(this.context, collection).withEntityType("JournalIssue").build();
        Item journalVolume = ItemBuilder.createItem(this.context, collection).withPublicationVolumeNumber("30").withEntityType("JournalVolume").build();
        Item journal = ItemBuilder.createItem(this.context, collection).withMetadata("creativeworkseries", "issn", null, "issn journal").withEntityType("Journal").build();
        RelationshipBuilder.createRelationshipBuilder(this.context, journalIssue, journalVolume, isJournalVolumeOfIssueRelationshipType).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, journalVolume, journal, isJournalVolumeOfJournalRelationshipType).build();
        Item publication = ItemBuilder.createItem(this.context, collection).withTitle("Pub 1").withEntityType("Publication").build();
        RelationshipBuilder.createRelationshipBuilder(this.context, publication, journalIssue, isJournalIssueOfPublicationRelationshipType).build();
        this.context.restoreAuthSystemState();
        List mdPublication = this.itemService.getMetadata(publication, "*", "*", "*", "*", true);
        boolean foundVirtualMdIsJournalOfPublicationInAllMD = false;
        for (MetadataValue metadataValue : mdPublication) {
            String schema = metadataValue.getMetadataField().getMetadataSchema().getName();
            String element = metadataValue.getMetadataField().getElement();
            String qualifier = metadataValue.getMetadataField().getQualifier();
            if (!schema.equals("relation") || !element.equals("isJournalOfPublication") || qualifier != null || !metadataValue.getValue().equals(journal.getID().toString())) continue;
            foundVirtualMdIsJournalOfPublicationInAllMD = true;
        }
        Assert.assertTrue((boolean)foundVirtualMdIsJournalOfPublicationInAllMD);
        List mdPublicationRelationIsJournalOfPublication = this.itemService.getMetadata(publication, "relation", "isJournalOfPublication", "*", "*", true);
        boolean foundVirtualMdIsJournalOfPublicationInSpecificQuery = false;
        for (Object metadataValue : mdPublicationRelationIsJournalOfPublication) {
            String schema = metadataValue.getMetadataField().getMetadataSchema().getName();
            String element = metadataValue.getMetadataField().getElement();
            String qualifier = metadataValue.getMetadataField().getQualifier();
            if (!schema.equals("relation") || !element.equals("isJournalOfPublication") || qualifier != null || !metadataValue.getValue().equals(journal.getID().toString())) continue;
            foundVirtualMdIsJournalOfPublicationInSpecificQuery = true;
        }
        Assert.assertTrue((boolean)foundVirtualMdIsJournalOfPublicationInSpecificQuery);
        boolean foundVirtualMdCreativeWorksISSNInAllMD = false;
        for (MetadataValue metadataValue : mdPublication) {
            String schema = metadataValue.getMetadataField().getMetadataSchema().getName();
            String element = metadataValue.getMetadataField().getElement();
            String qualifier = metadataValue.getMetadataField().getQualifier();
            if (!schema.equals("creativeworkseries") || !element.equals("issn") || qualifier != null || !metadataValue.getValue().equals("issn journal")) continue;
            foundVirtualMdCreativeWorksISSNInAllMD = true;
        }
        Assert.assertTrue((boolean)foundVirtualMdCreativeWorksISSNInAllMD);
        List mdPublicationVirtualMdCreativeWorksISSN = this.itemService.getMetadata(publication, "creativeworkseries", "issn", "*", "*", true);
        boolean foundCreativeWorksISSNInSpecificQuery = false;
        for (MetadataValue metadataValue : mdPublicationVirtualMdCreativeWorksISSN) {
            String schema = metadataValue.getMetadataField().getMetadataSchema().getName();
            String element = metadataValue.getMetadataField().getElement();
            String qualifier = metadataValue.getMetadataField().getQualifier();
            if (!schema.equals("creativeworkseries") || !element.equals("issn") || qualifier != null || !metadataValue.getValue().equals("issn journal")) continue;
            foundCreativeWorksISSNInSpecificQuery = true;
        }
        Assert.assertTrue((boolean)foundCreativeWorksISSNInSpecificQuery);
    }
}

