/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.MetadataSchemaService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.test.util.ReflectionTestUtils;

public class MetadataSchemaTest
extends AbstractUnitTest {
    private static final Logger log = LogManager.getLogger(MetadataSchemaTest.class);
    private MetadataSchema ms;
    protected MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
    private AuthorizeService authorizeServiceSpy;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.ms = this.metadataSchemaService.find(this.context, MetadataSchemaEnum.DC.getName());
            this.authorizeServiceSpy = (AuthorizeService)Mockito.spy((Object)this.authorizeService);
            ReflectionTestUtils.setField((Object)this.metadataSchemaService, (String)"authorizeService", (Object)this.authorizeServiceSpy);
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Test
    public void testGetNamespace() {
        MatcherAssert.assertThat((String)"testGetNamespace 0", (Object)this.ms.getNamespace(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testGetNamespace 1", (Object)this.ms.getNamespace(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
    }

    @Test
    public void testSetNamespace() {
        String oldnamespace = this.ms.getNamespace();
        String namespace = "new namespace";
        this.ms.setNamespace(namespace);
        MatcherAssert.assertThat((String)"testSetNamespace 0", (Object)this.ms.getNamespace(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testSetNamespace 1", (Object)this.ms.getNamespace(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        MatcherAssert.assertThat((String)"testSetNamespace 2", (Object)this.ms.getNamespace(), (Matcher)CoreMatchers.equalTo((Object)namespace));
        this.ms.setNamespace(oldnamespace);
    }

    @Test
    public void testGetName() {
        MatcherAssert.assertThat((String)"testGetName 0", (Object)this.ms.getName(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testGetName 1", (Object)this.ms.getName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
    }

    @Test
    public void testSetName() {
        String oldname = this.ms.getName();
        String name = "new name";
        this.ms.setName(name);
        MatcherAssert.assertThat((String)"testSetName 0", (Object)this.ms.getName(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testSetName 1", (Object)this.ms.getName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        MatcherAssert.assertThat((String)"testSetName 2", (Object)this.ms.getName(), (Matcher)CoreMatchers.equalTo((Object)name));
        this.ms.setName(oldname);
    }

    @Test
    public void testGetSchemaID() throws SQLException {
        MatcherAssert.assertThat((String)"testGetSchemaID 0", (Object)this.ms.getID(), (Matcher)CoreMatchers.equalTo((Object)this.metadataSchemaService.find(this.context, MetadataSchemaEnum.DC.getName()).getID()));
    }

    @Test
    public void testCreateAuth() throws Exception {
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(this.context)).thenReturn((Object)true);
        String namespace = "namespace";
        String name = "name";
        this.metadataSchemaService.create(this.context, name, namespace);
        MetadataSchema found = this.metadataSchemaService.findByNamespace(this.context, namespace);
        MatcherAssert.assertThat((String)"testCreateAuth 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateNoAuth() throws Exception {
        String namespace = "namespace";
        String name = "name";
        this.metadataSchemaService.create(this.context, name, namespace);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=NonUniqueMetadataException.class)
    public void testCreateRepeated() throws Exception {
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(this.context)).thenReturn((Object)true);
        String namespace = this.ms.getNamespace();
        String name = this.ms.getName();
        this.metadataSchemaService.create(this.context, name, namespace);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testFindByNamespace() throws Exception {
        log.info(">>" + this.ms.getNamespace() + " " + this.ms.getName());
        MetadataSchema found = this.metadataSchemaService.findByNamespace(this.context, this.ms.getNamespace());
        MatcherAssert.assertThat((String)"testFindByNamespace 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testFindByNamespace 1", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)this.ms.getID()));
    }

    @Test
    public void testUpdateAuth() throws Exception {
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(this.context)).thenReturn((Object)true);
        String namespace = "namespace2";
        String name = "name2";
        MetadataSchema metadataSchema = this.metadataSchemaService.create(this.context, name, namespace);
        this.metadataSchemaService.update(this.context, metadataSchema);
        MetadataSchema found = this.metadataSchemaService.findByNamespace(this.context, namespace);
        MatcherAssert.assertThat((String)"testUpdateAuth 0", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)metadataSchema.getID()));
    }

    @Test(expected=AuthorizeException.class)
    public void testUpdateNoAuth() throws Exception {
        this.metadataSchemaService.update(this.context, this.ms);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=NonUniqueMetadataException.class)
    public void testUpdateRepeated() throws Exception {
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(this.context)).thenReturn((Object)true);
        String namespace = this.ms.getNamespace();
        String name = this.ms.getName();
        MetadataSchema m = this.metadataSchemaService.create(this.context, name, namespace);
        m.setName(name);
        m.setNamespace(namespace);
        this.metadataSchemaService.update(this.context, m);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testDeleteAuth() throws Exception {
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(this.context)).thenReturn((Object)true);
        String namespace = "namespace3";
        String name = "name3";
        MetadataSchema m = this.metadataSchemaService.create(this.context, name, namespace);
        this.metadataSchemaService.delete(this.context, m);
        MetadataSchema found = this.metadataSchemaService.findByNamespace(this.context, namespace);
        MatcherAssert.assertThat((String)"testDeleteAuth 0", (Object)found, (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testDeleteNoAuth() throws Exception {
        String namespace = "namespace3";
        String name = "name3";
        MetadataSchema m = this.metadataSchemaService.create(this.context, name, namespace);
        this.metadataSchemaService.delete(this.context, m);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testFindAll() throws Exception {
        List found = this.metadataSchemaService.findAll(this.context);
        MatcherAssert.assertThat((String)"testFindAll 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAll 1", (found.size() >= 1 ? 1 : 0) != 0);
        boolean added = false;
        for (MetadataSchema msc : found) {
            if (!msc.equals((Object)this.ms)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAll 2", (boolean)added);
    }

    @Test
    public void testFind_Context_int() throws Exception {
        MetadataSchema found = this.metadataSchemaService.find(this.context, this.ms.getID().intValue());
        MatcherAssert.assertThat((String)"testFind_Context_int 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testFind_Context_int 1", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)this.ms.getID()));
        MatcherAssert.assertThat((String)"testFind_Context_int 2", (Object)found.getName(), (Matcher)CoreMatchers.equalTo((Object)this.ms.getName()));
        MatcherAssert.assertThat((String)"testFind_Context_int 3", (Object)found.getNamespace(), (Matcher)CoreMatchers.equalTo((Object)this.ms.getNamespace()));
    }

    @Test
    public void testFind_Context_String() throws Exception {
        String shortName = this.ms.getName();
        MetadataSchema found = this.metadataSchemaService.find(this.context, shortName);
        MatcherAssert.assertThat((String)"testFind_Context_String 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testFind_Context_String 1", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)this.ms.getID()));
        MatcherAssert.assertThat((String)"testFind_Context_String 2", (Object)found.getName(), (Matcher)CoreMatchers.equalTo((Object)this.ms.getName()));
        MatcherAssert.assertThat((String)"testFind_Context_String 3", (Object)found.getNamespace(), (Matcher)CoreMatchers.equalTo((Object)this.ms.getNamespace()));
        found = this.metadataSchemaService.find(this.context, null);
        MatcherAssert.assertThat((String)"testFind_Context_String 4", (Object)found, (Matcher)CoreMatchers.nullValue());
    }
}

