/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.util.ArrayList;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.EntityType;
import org.dspace.content.EntityTypeServiceImpl;
import org.dspace.content.dao.EntityTypeDAO;
import org.dspace.core.Context;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class EntityTypeServiceImplTest {
    @InjectMocks
    private EntityTypeServiceImpl entityTypeService;
    @Mock
    private EntityType entityType;
    @Mock
    private EntityTypeDAO entityTypeDAO;
    @Mock
    private Context context;
    @Mock
    private AuthorizeService authorizeService;

    @Test
    public void testFindByEntityType() throws Exception {
        Mockito.when((Object)this.entityTypeDAO.findByEntityType(this.context, "TestType")).thenReturn((Object)this.entityType);
        Assert.assertEquals((String)"TestFindByEntityType 0", (Object)this.entityType, (Object)this.entityTypeService.findByEntityType(this.context, "TestType"));
    }

    @Test
    public void testFindAll() throws Exception {
        ArrayList entityTypeList = new ArrayList();
        Assert.assertEquals((String)"TestFindAll 0", entityTypeList, (Object)this.entityTypeService.findAll(this.context));
    }

    @Test
    public void testCreate() throws Exception {
        Mockito.when((Object)this.authorizeService.isAdmin(this.context)).thenReturn((Object)true);
        EntityType entityType = new EntityType();
        entityType.setLabel("Test");
        Mockito.when((Object)((EntityType)this.entityTypeDAO.create((Context)ArgumentMatchers.any(), (Object)((EntityType)ArgumentMatchers.any())))).thenReturn((Object)entityType);
        Assert.assertEquals((String)"TestCreate 0", (Object)entityType.getLabel(), (Object)this.entityTypeService.create(this.context, "Test").getLabel());
        Assert.assertEquals((String)"TestCreate 1", (Object)entityType, (Object)this.entityTypeService.create(this.context));
    }

    @Test
    public void testFind() throws Exception {
        Mockito.when((Object)((EntityType)this.entityTypeDAO.findByID(this.context, EntityType.class, 0))).thenReturn((Object)this.entityType);
        Assert.assertEquals((String)"TestFind 0", (Object)this.entityType, (Object)this.entityTypeService.find(this.context, 0));
    }

    @Test
    public void testUpdate() throws Exception {
        ArrayList<EntityType> entityTypeList = new ArrayList<EntityType>();
        entityTypeList.add(this.entityType);
        Mockito.when((Object)this.authorizeService.isAdmin(this.context)).thenReturn((Object)true);
        this.entityTypeService.update(this.context, this.entityType);
        this.entityTypeService.update(this.context, entityTypeList);
        ((EntityTypeDAO)Mockito.verify((Object)this.entityTypeDAO, (VerificationMode)Mockito.times((int)2))).save(this.context, (Object)this.entityType);
    }

    @Test
    public void testDelete() throws Exception {
        Mockito.when((Object)this.authorizeService.isAdmin(this.context)).thenReturn((Object)true);
        this.entityTypeService.delete(this.context, this.entityType);
        ((EntityTypeDAO)Mockito.verify((Object)this.entityTypeDAO, (VerificationMode)Mockito.times((int)1))).delete(this.context, (Object)this.entityType);
    }

    public EntityType makeEntityType() {
        return new EntityType();
    }
}

