/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.util.ArrayList;
import java.util.UUID;
import org.dspace.content.Entity;
import org.dspace.content.EntityServiceImpl;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class EntityServiceImplTest {
    @InjectMocks
    private EntityServiceImpl entityService;
    @Mock
    private Context context;
    @Mock
    private ItemService itemService;
    @Mock
    private RelationshipService relationshipService;
    @Mock
    private RelationshipTypeService relationshipTypeService;
    @Mock
    private EntityTypeService entityTypeService;
    @Mock
    private EntityType leftType;
    @Mock
    private EntityType rightType;

    @Test
    public void testfindByItemId() throws Exception {
        Item item = (Item)Mockito.mock(Item.class);
        Relationship relationship = (Relationship)Mockito.mock(Relationship.class);
        relationship.setId(Integer.valueOf(9));
        Mockito.when((Object)((Item)this.itemService.find((Context)ArgumentMatchers.any(), (UUID)ArgumentMatchers.any()))).thenReturn((Object)item);
        Mockito.when((Object)item.getName()).thenReturn((Object)"ItemName");
        Assert.assertEquals((String)"TestFindByItem 0", (Object)"ItemName", (Object)this.entityService.findByItemId(this.context, item.getID()).getItem().getName());
    }

    @Test
    public void testGetType() throws Exception {
        Entity entity = (Entity)Mockito.mock(Entity.class);
        EntityTypeService entityTypeService = (EntityTypeService)Mockito.mock(EntityTypeService.class);
        EntityType entityType = entityTypeService.findByEntityType(this.context, "testType");
        Assert.assertEquals((String)"TestGetType 0", (Object)entityType, (Object)this.entityService.getType(this.context, entity));
    }

    @Test
    public void testGetLeftRelation() {
        Item item = (Item)Mockito.mock(Item.class);
        UUID uuid = UUID.randomUUID();
        Relationship relationship = (Relationship)Mockito.mock(Relationship.class);
        ArrayList<Relationship> relationshipList = new ArrayList<Relationship>();
        relationshipList.add(relationship);
        Entity entity = (Entity)Mockito.mock(Entity.class);
        Mockito.when((Object)entity.getItem()).thenReturn((Object)item);
        Mockito.when((Object)relationship.getLeftItem()).thenReturn((Object)item);
        Mockito.when((Object)item.getID()).thenReturn((Object)uuid);
        Mockito.when((Object)entity.getRelationships()).thenReturn(relationshipList);
        Assert.assertEquals((String)"TestGetLeftRelations 0", relationshipList, (Object)this.entityService.getLeftRelations(this.context, entity));
    }

    @Test
    public void testGetRightRelation() {
        Item item = (Item)Mockito.mock(Item.class);
        UUID uuid = UUID.randomUUID();
        Relationship relationship = (Relationship)Mockito.mock(Relationship.class);
        ArrayList<Relationship> relationshipList = new ArrayList<Relationship>();
        relationshipList.add(relationship);
        Entity entity = (Entity)Mockito.mock(Entity.class);
        Mockito.when((Object)entity.getItem()).thenReturn((Object)item);
        Mockito.when((Object)relationship.getRightItem()).thenReturn((Object)item);
        Mockito.when((Object)item.getID()).thenReturn((Object)uuid);
        Mockito.when((Object)entity.getRelationships()).thenReturn(relationshipList);
        Assert.assertEquals((String)"TestGetLeftRelations 0", relationshipList, (Object)this.entityService.getRightRelations(this.context, entity));
    }

    @Test
    public void testGetRelationsByTypeName() throws Exception {
        Relationship relationship = (Relationship)Mockito.mock(Relationship.class);
        RelationshipType relationshipType = (RelationshipType)Mockito.mock(RelationshipType.class);
        relationship.setRelationshipType(relationshipType);
        ArrayList<Relationship> relationshipList = new ArrayList<Relationship>();
        relationshipList.add(relationship);
        Mockito.when((Object)this.relationshipService.findByTypeName(this.context, "leftwardType", Integer.valueOf(-1), Integer.valueOf(-1))).thenReturn(relationshipList);
        Assert.assertEquals((String)"TestGetRelationsByLabel 0", relationshipList, (Object)this.entityService.getRelationsByTypeName(this.context, "leftwardType"));
    }

    @Test
    public void testGetAllRelationshipTypes() throws Exception {
        Item item = (Item)Mockito.mock(Item.class);
        Entity entity = (Entity)Mockito.mock(Entity.class);
        RelationshipType relationshipType = (RelationshipType)Mockito.mock(RelationshipType.class);
        relationshipType.setLeftType(this.leftType);
        relationshipType.setLeftType(this.rightType);
        ArrayList<RelationshipType> relationshipTypeList = new ArrayList<RelationshipType>();
        relationshipTypeList.add(relationshipType);
        Mockito.when((Object)entity.getItem()).thenReturn((Object)item);
        Mockito.when((Object)this.relationshipTypeService.findByEntityType(this.context, this.entityService.getType(this.context, entity), Integer.valueOf(-1), Integer.valueOf(-1))).thenReturn(relationshipTypeList);
        Assert.assertEquals((String)"TestGetAllRelationshipTypes 0", relationshipTypeList, (Object)this.entityService.getAllRelationshipTypes(this.context, entity));
    }

    @Test
    public void testGetLeftRelationshipTypes() throws Exception {
        Item item = (Item)Mockito.mock(Item.class);
        Entity entity = (Entity)Mockito.mock(Entity.class);
        EntityType entityType = (EntityType)Mockito.mock(EntityType.class);
        RelationshipType relationshipType = (RelationshipType)Mockito.mock(RelationshipType.class);
        ArrayList<RelationshipType> relationshipTypeList = new ArrayList<RelationshipType>();
        relationshipTypeList.add(relationshipType);
        ArrayList<MetadataValue> metsList = new ArrayList<MetadataValue>();
        MetadataValue metadataValue = (MetadataValue)Mockito.mock(MetadataValue.class);
        metsList.add(metadataValue);
        Mockito.when((Object)this.itemService.getMetadata(item, "dspace", "entity", "type", "*", false)).thenReturn(metsList);
        Mockito.when((Object)entity.getItem()).thenReturn((Object)item);
        Mockito.when((Object)this.entityService.getType(this.context, entity)).thenReturn((Object)entityType);
        Mockito.when((Object)this.relationshipTypeService.findByEntityType(this.context, this.entityService.getType(this.context, entity), true, Integer.valueOf(-1), Integer.valueOf(-1))).thenReturn(relationshipTypeList);
        Assert.assertEquals((String)"TestGetLeftRelationshipTypes 0", relationshipTypeList, (Object)this.entityService.getLeftRelationshipTypes(this.context, entity));
    }

    @Test
    public void testGetRightRelationshipTypes() throws Exception {
        Item item = (Item)Mockito.mock(Item.class);
        Entity entity = (Entity)Mockito.mock(Entity.class);
        EntityType entityType = (EntityType)Mockito.mock(EntityType.class);
        RelationshipType relationshipType = (RelationshipType)Mockito.mock(RelationshipType.class);
        ArrayList<RelationshipType> relationshipTypeList = new ArrayList<RelationshipType>();
        relationshipTypeList.add(relationshipType);
        ArrayList<MetadataValue> metsList = new ArrayList<MetadataValue>();
        MetadataValue metadataValue = (MetadataValue)Mockito.mock(MetadataValue.class);
        metsList.add(metadataValue);
        Mockito.when((Object)this.itemService.getMetadata(item, "dspace", "entity", "type", "*", false)).thenReturn(metsList);
        Mockito.when((Object)entity.getItem()).thenReturn((Object)item);
        Mockito.when((Object)this.entityService.getType(this.context, entity)).thenReturn((Object)entityType);
        Mockito.when((Object)this.relationshipTypeService.findByEntityType(this.context, this.entityService.getType(this.context, entity), false, Integer.valueOf(-1), Integer.valueOf(-1))).thenReturn(relationshipTypeList);
        Assert.assertEquals((String)"TestGetRightRelationshipTypes 0", relationshipTypeList, (Object)this.entityService.getRightRelationshipTypes(this.context, entity));
    }

    @Test
    public void testGetRelationshipTypesByTypeName() throws Exception {
        ArrayList<RelationshipType> list = new ArrayList<RelationshipType>();
        RelationshipType relationshipType = (RelationshipType)Mockito.mock(RelationshipType.class);
        list.add(relationshipType);
        Mockito.when((Object)this.relationshipTypeService.findByLeftwardOrRightwardTypeName(this.context, "leftwardType", Integer.valueOf(-1), Integer.valueOf(-1))).thenReturn(list);
        Assert.assertEquals((String)"TestGetRelationshipTypesByLabel 0", list, (Object)this.entityService.getRelationshipTypesByTypeName(this.context, "leftwardType"));
    }
}

