/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Locale;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.LicenseUtils;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.SearchServiceException;
import org.dspace.eperson.EPerson;
import org.dspace.workflow.WorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;

public class WorkflowItemBuilder
extends AbstractBuilder<XmlWorkflowItem, XmlWorkflowItemService> {
    private Item item;
    private WorkspaceItem workspaceItem;
    private XmlWorkflowItem workflowItem;

    protected WorkflowItemBuilder(Context context) {
        super(context);
    }

    public static WorkflowItemBuilder createWorkflowItem(Context context, Collection col) {
        WorkflowItemBuilder builder = new WorkflowItemBuilder(context);
        return builder.create(context, col);
    }

    private WorkflowItemBuilder create(Context context, Collection col) {
        this.context = context;
        try {
            this.workspaceItem = workspaceItemService.create(context, col, false);
            this.item = this.workspaceItem.getItem();
        }
        catch (Exception e) {
            return (WorkflowItemBuilder)this.handleException(e);
        }
        return this;
    }

    @Override
    public XmlWorkflowItem build() {
        try {
            this.workflowItem = (XmlWorkflowItem)workflowService.start(this.context, this.workspaceItem);
            this.workspaceItem = null;
            this.context.dispatchEvents();
            indexingService.commit();
            return this.workflowItem;
        }
        catch (Exception e) {
            return (XmlWorkflowItem)this.handleException(e);
        }
    }

    @Override
    public void delete(Context c, XmlWorkflowItem dso) throws Exception {
        if (dso != null) {
            this.getService().delete(c, (WorkflowItem)dso);
            this.item = null;
        }
    }

    private void deleteWsi(Context c, WorkspaceItem dso) throws Exception {
        if (dso != null) {
            workspaceItemService.deleteAll(c, dso);
            this.item = null;
        }
    }

    private void deleteItem(Context c, Item dso) throws Exception {
        if (dso != null) {
            WorkspaceItem wi = workspaceItemService.findByItem(c, this.item);
            if (wi != null) {
                workspaceItemService.deleteAll(c, wi);
            } else {
                itemService.delete(c, (DSpaceObject)dso);
            }
        }
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            this.workspaceItem = (WorkspaceItem)c.reloadEntity((ReloadableEntity)this.workspaceItem);
            this.workflowItem = (XmlWorkflowItem)c.reloadEntity((ReloadableEntity)this.workflowItem);
            this.item = (Item)c.reloadEntity((ReloadableEntity)this.item);
            if (this.workspaceItem != null) {
                this.deleteWsi(c, this.workspaceItem);
            }
            if (this.workflowItem != null) {
                this.delete(c, this.workflowItem);
            }
            if (this.item != null) {
                this.deleteItem(c, this.item);
            }
            c.complete();
            indexingService.commit();
        }
    }

    @Override
    protected XmlWorkflowItemService getService() {
        return workflowItemService;
    }

    protected WorkflowItemBuilder addMetadataValue(String schema, String element, String qualifier, String value) {
        try {
            itemService.addMetadata(this.context, (DSpaceObject)this.workspaceItem.getItem(), schema, element, qualifier, "*", value);
        }
        catch (Exception e) {
            return (WorkflowItemBuilder)this.handleException(e);
        }
        return this;
    }

    protected WorkflowItemBuilder setMetadataSingleValue(String schema, String element, String qualifier, String value) {
        try {
            itemService.setMetadataSingleValue(this.context, (DSpaceObject)this.workspaceItem.getItem(), schema, element, qualifier, "*", value);
        }
        catch (Exception e) {
            return (WorkflowItemBuilder)this.handleException(e);
        }
        return this;
    }

    public WorkflowItemBuilder withSubmitter(EPerson ePerson) {
        this.workspaceItem.getItem().setSubmitter(ePerson);
        return this;
    }

    public WorkflowItemBuilder withTitle(String title) {
        return this.setMetadataSingleValue(MetadataSchemaEnum.DC.getName(), "title", null, title);
    }

    public WorkflowItemBuilder withIssueDate(String issueDate) {
        return this.addMetadataValue(MetadataSchemaEnum.DC.getName(), "date", "issued", new DCDate(issueDate).toString());
    }

    public WorkflowItemBuilder withAuthor(String authorName) {
        return this.addMetadataValue(MetadataSchemaEnum.DC.getName(), "contributor", "author", authorName);
    }

    public WorkflowItemBuilder withSubject(String subject) {
        return this.addMetadataValue(MetadataSchemaEnum.DC.getName(), "subject", null, subject);
    }

    public WorkflowItemBuilder grantLicense() {
        Item item = this.workspaceItem.getItem();
        try {
            EPerson submitter = this.workspaceItem.getSubmitter();
            submitter = (EPerson)this.context.reloadEntity((ReloadableEntity)submitter);
            String license = LicenseUtils.getLicenseText((Locale)this.context.getCurrentLocale(), (Collection)this.workspaceItem.getCollection(), (Item)item, (EPerson)submitter);
            LicenseUtils.grantLicense((Context)this.context, (Item)item, (String)license, null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this;
    }

    public WorkflowItemBuilder withFulltext(String name, String source, InputStream is) {
        try {
            Item item = this.workspaceItem.getItem();
            Bitstream b = itemService.createSingleBitstream(this.context, is, item);
            b.setName(this.context, name);
            b.setSource(this.context, source);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this;
    }

    public static void deleteWorkflowItem(Integer id) throws SQLException, IOException, SearchServiceException {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            XmlWorkflowItem wi = (XmlWorkflowItem)workflowItemService.find(c, id.intValue());
            if (wi != null) {
                try {
                    workflowItemService.delete(c, (WorkflowItem)wi);
                }
                catch (AuthorizeException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            c.complete();
        }
        indexingService.commit();
    }
}

