/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractBuilder;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.RelationshipService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.SearchServiceException;

public class RelationshipBuilder
extends AbstractBuilder<Relationship, RelationshipService> {
    private static final Logger log = LogManager.getLogger();
    private Relationship relationship;

    protected RelationshipBuilder(Context context) {
        super(context);
    }

    @Override
    protected RelationshipService getService() {
        return relationshipService;
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            this.relationship = (Relationship)c.reloadEntity((ReloadableEntity)this.relationship);
            if (this.relationship != null) {
                this.delete(c, this.relationship);
            }
            c.complete();
            indexingService.commit();
        }
    }

    @Override
    public void delete(Context c, Relationship dso) throws Exception {
        if (dso != null) {
            this.getService().delete(c, (Object)dso);
        }
    }

    @Override
    public Relationship build() {
        try {
            relationshipService.update(this.context, (Object)this.relationship);
            this.context.dispatchEvents();
            indexingService.commit();
        }
        catch (SQLException | AuthorizeException | SearchServiceException e) {
            log.error((Object)e);
        }
        return this.relationship;
    }

    public void delete(Relationship dso) throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            Relationship attachedDso = (Relationship)c.reloadEntity((ReloadableEntity)dso);
            if (attachedDso != null) {
                this.getService().delete(c, (Object)attachedDso);
            }
            c.complete();
        }
        indexingService.commit();
    }

    public static void deleteRelationship(Integer id) throws SQLException, IOException {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            Relationship relationship = (Relationship)relationshipService.find(c, id.intValue());
            if (relationship != null) {
                try {
                    relationshipService.delete(c, (Object)relationship);
                }
                catch (AuthorizeException e) {
                    throw new RuntimeException(e);
                }
            }
            c.complete();
        }
    }

    public static RelationshipBuilder createRelationshipBuilder(Context context, Item leftItem, Item rightItem, RelationshipType relationshipType) {
        RelationshipBuilder relationshipBuilder = new RelationshipBuilder(context);
        return relationshipBuilder.create(context, leftItem, rightItem, relationshipType);
    }

    private RelationshipBuilder create(Context context, Item leftItem, Item rightItem, RelationshipType relationshipType) {
        this.context = context;
        try {
            this.relationship = relationshipService.create(context, leftItem, rightItem, relationshipType, 0, 0);
        }
        catch (SQLException | AuthorizeException e) {
            log.warn("Failed to create relationship", e);
        }
        return this;
    }

    public RelationshipBuilder withLeftwardValue(String leftwardValue) throws SQLException {
        this.relationship.setLeftwardValue(leftwardValue);
        return this;
    }

    public RelationshipBuilder withRightwardValue(String rightwardValue) throws SQLException {
        this.relationship.setRightwardValue(rightwardValue);
        return this;
    }

    public RelationshipBuilder withLeftPlace(int leftPlace) {
        this.relationship.setLeftPlace(leftPlace);
        return this;
    }
}

