/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import org.dspace.builder.AbstractBuilder;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.service.DSpaceCRUDService;

public abstract class AbstractCRUDBuilder<T extends ReloadableEntity>
extends AbstractBuilder<T, DSpaceCRUDService> {
    protected AbstractCRUDBuilder(Context context) {
        super(context);
    }

    @Override
    protected abstract DSpaceCRUDService getService();

    @Override
    public abstract T build();

    public void delete(T dso) throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            ReloadableEntity attachedDso = c.reloadEntity(dso);
            if (attachedDso != null) {
                this.getService().delete(c, (Object)attachedDso);
            }
            c.complete();
        }
        indexingService.commit();
    }
}

