/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.util.List;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.launcher.ScriptLauncher;
import org.dspace.app.scripts.handler.impl.TestDSpaceRunnableHandler;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.MetadataField;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jdom.Document;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetadataDeletionIT
extends AbstractIntegrationTestWithDatabase {
    private MetadataValueService metadataValueService = ContentServiceFactory.getInstance().getMetadataValueService();
    private MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    @Before
    public void setup() {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).build();
        this.createItem(collection, "My First publication", "Mario Rossi");
        this.createItem(collection, "Another publication", "John Smith");
        this.context.restoreAuthSystemState();
    }

    @Test
    public void metadataDeletionListTest() throws Exception {
        this.configurationService.setProperty("bulkedit.allow-bulk-deletion", (Object)new String[]{"dc.title", "dc.type"});
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"metadata-deletion", "-l"};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        List<String> infoMessages = testDSpaceRunnableHandler.getInfoMessages();
        MatcherAssert.assertThat(infoMessages, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(infoMessages, (Matcher)Matchers.hasItem((Matcher)Matchers.equalTo((Object)"The fields that can be bulk deleted are: dc.title, dc.type")));
    }

    @Test
    public void metadataDeletionListWithoutErasableMetadataTest() throws Exception {
        this.configurationService.setProperty("bulkedit.allow-bulk-deletion", null);
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"metadata-deletion", "-l"};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        List<String> infoMessages = testDSpaceRunnableHandler.getInfoMessages();
        MatcherAssert.assertThat(infoMessages, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(infoMessages, (Matcher)Matchers.hasItem((Matcher)Matchers.equalTo((Object)"No fields has been configured to be cleared via bulk deletion")));
    }

    @Test
    public void metadataDeletionTest() throws Exception {
        MetadataField titleField = this.metadataFieldService.findByElement(this.context, "dc", "title", null);
        MetadataField authorField = this.metadataFieldService.findByElement(this.context, "dc", "contributor", "author");
        MatcherAssert.assertThat((Object)this.metadataValueService.findByField(this.context, titleField), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)this.metadataValueService.findByField(this.context, authorField), (Matcher)Matchers.hasSize((int)2));
        this.configurationService.setProperty("bulkedit.allow-bulk-deletion", (Object)"dc.title");
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"metadata-deletion", "-m", "dc.title"};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        MatcherAssert.assertThat((Object)this.metadataValueService.findByField(this.context, titleField), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)this.metadataValueService.findByField(this.context, authorField), (Matcher)Matchers.hasSize((int)2));
        List<String> infoMessages = testDSpaceRunnableHandler.getInfoMessages();
        MatcherAssert.assertThat(infoMessages, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(infoMessages, (Matcher)Matchers.hasItem((Matcher)Matchers.equalTo((Object)"Deleting the field 'dc.title' from all objects")));
    }

    @Test
    public void metadataDeletionNotAllowedTest() throws Exception {
        MetadataField titleField = this.metadataFieldService.findByElement(this.context, "dc", "title", null);
        MetadataField authorField = this.metadataFieldService.findByElement(this.context, "dc", "contributor", "author");
        Assert.assertEquals((long)2L, (long)this.metadataValueService.findByField(this.context, titleField).size());
        Assert.assertEquals((long)2L, (long)this.metadataValueService.findByField(this.context, authorField).size());
        this.configurationService.setProperty("bulkedit.allow-bulk-deletion", (Object)"dc.type");
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"metadata-deletion", "-m", "dc.title"};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        Exception exception = testDSpaceRunnableHandler.getException();
        MatcherAssert.assertThat((Object)exception, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)exception, (Matcher)Matchers.instanceOf(IllegalArgumentException.class));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"The given metadata field cannot be bulk deleted"));
        Assert.assertEquals((long)2L, (long)this.metadataValueService.findByField(this.context, titleField).size());
        Assert.assertEquals((long)2L, (long)this.metadataValueService.findByField(this.context, authorField).size());
    }

    @Test
    public void metadataDeletionWithUnknownMetadataTest() throws Exception {
        MetadataField titleField = this.metadataFieldService.findByElement(this.context, "dc", "title", null);
        MetadataField authorField = this.metadataFieldService.findByElement(this.context, "dc", "contributor", "author");
        Assert.assertEquals((long)2L, (long)this.metadataValueService.findByField(this.context, titleField).size());
        Assert.assertEquals((long)2L, (long)this.metadataValueService.findByField(this.context, authorField).size());
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"metadata-deletion", "-m", "dc.unknown"};
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        Exception exception = testDSpaceRunnableHandler.getException();
        MatcherAssert.assertThat((Object)exception, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)exception, (Matcher)Matchers.instanceOf(IllegalArgumentException.class));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"No metadata field found with name dc.unknown"));
        Assert.assertEquals((long)2L, (long)this.metadataValueService.findByField(this.context, titleField).size());
        Assert.assertEquals((long)2L, (long)this.metadataValueService.findByField(this.context, authorField).size());
    }

    private void createItem(Collection collection, String title, String author) {
        ItemBuilder.createItem(this.context, collection).withTitle(title).withAuthor(author).build();
    }
}

