/*
 * Decompiled with CFR 0.152.
 */
package org.dspace;

import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.NoExitSecurityManager;
import org.dspace.builder.AbstractBuilder;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.servicemanager.DSpaceKernelInit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class AbstractDSpaceIntegrationTest {
    private static final Logger log = LogManager.getLogger(AbstractDSpaceIntegrationTest.class);
    protected static Properties testProps;
    protected static DSpaceKernelImpl kernelImpl;

    protected AbstractDSpaceIntegrationTest() {
    }

    @BeforeClass
    public static void initTestEnvironment() {
        try {
            System.setSecurityManager(new NoExitSecurityManager());
            TimeZone.setDefault(TimeZone.getTimeZone("Europe/Dublin"));
            testProps = new Properties();
            URL properties = AbstractDSpaceIntegrationTest.class.getClassLoader().getResource("test-config.properties");
            testProps.load(properties.openStream());
            kernelImpl = DSpaceKernelInit.getKernel(null);
            if (!kernelImpl.isRunning()) {
                kernelImpl.start(AbstractDSpaceIntegrationTest.getDspaceDir());
            }
            AbstractBuilder.init();
        }
        catch (IOException ex) {
            log.error("Error initializing tests", (Throwable)ex);
            Assert.fail((String)("Error initializing tests: " + ex.getMessage()));
        }
    }

    @AfterClass
    public static void destroyTestEnvironment() throws SQLException {
        System.setSecurityManager(null);
        testProps.clear();
        testProps = null;
        AbstractBuilder.destroy();
    }

    public static String getDspaceDir() {
        return System.getProperty("dspace.dir");
    }
}

