/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.kogito.client.popup;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.HTMLLabelElement;
import elemental2.dom.Node;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.client.popup.AbstractScenarioPopupView;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.kogito.client.dropdown.ScenarioSimulationKogitoCreationAssetsDropdown;
import org.drools.workbench.screens.scenariosimulation.kogito.client.popup.ScenarioSimulationKogitoCreationPopup;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class ScenarioSimulationKogitoCreationPopupView
extends AbstractScenarioPopupView
implements ScenarioSimulationKogitoCreationPopup {
    @Inject
    @DataField(value="rule-button")
    protected HTMLInputElement ruleButton;
    @Inject
    @DataField(value="dmn-button")
    protected HTMLInputElement dmnButton;
    @Inject
    @DataField(value="dmn-assets")
    protected HTMLDivElement dmnAssetsDivElement;
    @Inject
    protected HTMLLabelElement dmnAssetsLabelElement;
    @Inject
    @DataField(value="source-type-label")
    protected HTMLLabelElement sourceTypeLabelElement;
    @Inject
    @DataField(value="info-rule-icon")
    protected HTMLDivElement infoRuleIconDivElement;
    protected ScenarioSimulationModel.Type selectedType = null;
    protected String selectedPath = null;
    @Inject
    protected ScenarioSimulationKogitoCreationAssetsDropdown scenarioSimulationKogitoCreationAssetsDropdown;

    @Override
    public void show(String mainTitleText, Command okCommand) {
        this.initialize();
        super.show(mainTitleText, ScenarioSimulationEditorConstants.INSTANCE.createButton(), okCommand);
    }

    protected void initialize() {
        this.okButton.setEnabled(false);
        this.cancelButton.setText(ScenarioSimulationEditorConstants.INSTANCE.cancelButton());
        this.dmnAssetsDivElement.setAttribute("hidden", "");
        this.sourceTypeLabelElement.textContent = ScenarioSimulationEditorConstants.INSTANCE.sourceType();
        this.ruleButton.checked = false;
        this.dmnButton.checked = false;
        this.dmnAssetsLabelElement.textContent = ScenarioSimulationEditorConstants.INSTANCE.chooseValidDMNAsset();
        this.dmnAssetsDivElement.appendChild((Node)this.dmnAssetsLabelElement);
        this.infoRuleIconDivElement.setAttribute("title", ScenarioSimulationEditorConstants.INSTANCE.currentlyNotAvailable());
        this.initializeDropdown();
    }

    @Override
    public ScenarioSimulationModel.Type getSelectedType() {
        return this.selectedType;
    }

    @Override
    public String getSelectedPath() {
        return this.selectedPath;
    }

    @EventHandler(value={"dmn-button"})
    public void onDmnClick(ClickEvent event) {
        if (this.dmnButton.checked) {
            this.selectedType = ScenarioSimulationModel.Type.DMN;
            this.dmnAssetsDivElement.removeAttribute("hidden");
            this.enableCreateButtonForDMNScenario();
        }
    }

    @EventHandler(value={"rule-button"})
    public void onRuleClick(ClickEvent event) {
        if (this.ruleButton.checked) {
            this.selectedType = ScenarioSimulationModel.Type.RULE;
            this.dmnAssetsDivElement.setAttribute("hidden", "");
            this.okButton.setEnabled(true);
        }
    }

    protected void initializeDropdown() {
        this.dmnAssetsDivElement.appendChild((Node)this.scenarioSimulationKogitoCreationAssetsDropdown.getElement());
        this.scenarioSimulationKogitoCreationAssetsDropdown.clear();
        this.scenarioSimulationKogitoCreationAssetsDropdown.init();
        this.scenarioSimulationKogitoCreationAssetsDropdown.initializeDropdown();
        this.scenarioSimulationKogitoCreationAssetsDropdown.registerOnChangeHandler(() -> {
            Optional value = this.scenarioSimulationKogitoCreationAssetsDropdown.getValue();
            this.selectedPath = value.map(KieAssetsDropdownItem::getValue).orElse(null);
            this.enableCreateButtonForDMNScenario();
        });
    }

    protected void enableCreateButtonForDMNScenario() {
        if (this.selectedPath != null && !this.selectedPath.isEmpty()) {
            this.okButton.setEnabled(true);
        }
    }
}

