/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.kogito.client.editor.strategies;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import jsinterop.base.Js;
import org.drools.workbench.scenariosimulation.kogito.marshaller.mapper.JsUtils;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDMNDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.events.ScenarioNotificationEvent;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.kogito.client.dmn.KogitoDMNService;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.MainJs;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.callbacks.DMN12UnmarshallCallback;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.workbench.events.NotificationEvent;

public class KogitoDMNDataManagementStrategy
extends AbstractDMNDataManagementStrategy {
    private KogitoDMNService dmnTypeService;

    public KogitoDMNDataManagementStrategy(EventBus eventBus, KogitoDMNService dmnTypeService) {
        super(eventBus);
        this.dmnTypeService = dmnTypeService;
    }

    protected void retrieveFactModelTuple(TestToolsView.Presenter testToolsPresenter, ScenarioSimulationContext context, GridWidget gridWidget, String dmnFilePath) {
        RemoteCallback callback = this.getSuccessCallback(testToolsPresenter, context, gridWidget);
        String fileName = dmnFilePath.substring(dmnFilePath.lastIndexOf(47) + 1);
        Path dmnPath = PathFactory.newPath((String)fileName, (String)dmnFilePath);
        this.dmnTypeService.getDMNContent(dmnPath, this.getDMNContentRemoteCallback((RemoteCallback<FactModelTuple>)callback), this.getDMNContentErrorCallback(dmnFilePath));
    }

    protected RemoteCallback<String> getDMNContentRemoteCallback(RemoteCallback<FactModelTuple> callback) {
        return dmnContent -> {
            DMN12UnmarshallCallback dmn12UnmarshallCallback = this.getDMN12UnmarshallCallback(callback);
            MainJs.unmarshall((String)dmnContent, (String)"", (DMN12UnmarshallCallback)dmn12UnmarshallCallback);
        };
    }

    protected ErrorCallback<Object> getDMNContentErrorCallback(String dmnFilePath) {
        return (message, throwable) -> {
            this.eventBus.fireEvent((GwtEvent)new ScenarioNotificationEvent(ScenarioSimulationEditorConstants.INSTANCE.dmnPathErrorDetailedLabel(dmnFilePath), NotificationEvent.NotificationType.ERROR));
            return false;
        };
    }

    protected DMN12UnmarshallCallback getDMN12UnmarshallCallback(RemoteCallback<FactModelTuple> callback) {
        return dmn12 -> {
            JSITDefinitions jsitDefinitions = (JSITDefinitions)Js.uncheckedCast((Object)JsUtils.getUnwrappedElement((Object)dmn12));
            FactModelTuple factModelTuple = this.dmnTypeService.getFactModelTuple(jsitDefinitions);
            callback.callback((Object)factModelTuple);
        };
    }
}

