/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.kogito.client.docks;

import com.google.gwt.core.client.GWT;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.widgets.client.docks.AuthoringEditorDock;
import org.kie.workbench.common.widgets.client.docks.WorkbenchDocksHandler;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;

@ApplicationScoped
public class KogitoEditorDock
implements AuthoringEditorDock {
    protected UberfireDocks uberfireDocks;
    protected ManagedInstance<WorkbenchDocksHandler> installedHandlers;
    protected String authoringPerspectiveIdentifier = null;
    protected WorkbenchDocksHandler activeHandler = null;
    protected UberfireDock[] activeDocks;

    @Inject
    public KogitoEditorDock(UberfireDocks uberfireDocks, ManagedInstance<WorkbenchDocksHandler> installedHandlers) {
        this.uberfireDocks = uberfireDocks;
        this.installedHandlers = installedHandlers;
    }

    @PostConstruct
    public void initialize() {
        this.installedHandlers.iterator().forEachRemaining(handler -> {
            Command initCommand = () -> this.setActiveHandler((WorkbenchDocksHandler)handler);
            handler.init(initCommand);
        });
    }

    public boolean isSetup() {
        return this.authoringPerspectiveIdentifier != null;
    }

    public void setup(String authoringPerspectiveIdentifier, PlaceRequest defaultPlaceRequest) {
        this.authoringPerspectiveIdentifier = authoringPerspectiveIdentifier;
    }

    public void show() {
        GWT.log((String)(this + " show"));
    }

    public void hide() {
        GWT.log((String)(this + " hide"));
    }

    public void expandAuthoringDock(UberfireDock dockToOpen) {
        this.uberfireDocks.show(UberfireDockPosition.EAST, this.authoringPerspectiveIdentifier);
        if (dockToOpen != null) {
            this.uberfireDocks.open(dockToOpen);
        }
    }

    protected void setActiveHandler(WorkbenchDocksHandler handler) {
        if (Objects.equals(this.activeHandler, handler) && !this.activeHandler.shouldRefreshDocks()) {
            return;
        }
        this.activeHandler = handler;
        if (this.activeHandler.shouldDisableDocks()) {
            this.uberfireDocks.hide(UberfireDockPosition.EAST, this.authoringPerspectiveIdentifier);
        } else {
            if (this.activeDocks != null) {
                this.uberfireDocks.remove(this.activeDocks);
            }
            Collection docks = this.activeHandler.provideDocks(this.authoringPerspectiveIdentifier);
            this.activeDocks = docks.toArray(new UberfireDock[docks.size()]);
            this.uberfireDocks.add(this.activeDocks);
            this.uberfireDocks.show(UberfireDockPosition.EAST, this.authoringPerspectiveIdentifier);
        }
    }
}

