/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.kogito.client.dmn;

import com.google.gwt.core.client.GWT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import javax.inject.Inject;
import jsinterop.base.Js;
import org.drools.scenariosimulation.api.model.AbstractScesimData;
import org.drools.scenariosimulation.api.model.AbstractScesimModel;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.BackgroundData;
import org.drools.scenariosimulation.api.model.BackgroundDataWithIndex;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.ScesimDataWithIndex;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.api.utils.ScenarioSimulationSharedUtils;
import org.drools.workbench.scenariosimulation.kogito.marshaller.js.SCESIMMainJs;
import org.drools.workbench.scenariosimulation.kogito.marshaller.js.callbacks.SCESIMMarshallCallback;
import org.drools.workbench.scenariosimulation.kogito.marshaller.js.model.JSIScenarioSimulationModelType;
import org.drools.workbench.scenariosimulation.kogito.marshaller.js.model.SCESIM;
import org.drools.workbench.scenariosimulation.kogito.marshaller.mapper.JSIName;
import org.drools.workbench.scenariosimulation.kogito.marshaller.mapper.JsUtils;
import org.drools.workbench.screens.scenariosimulation.kogito.client.converters.ApiJSInteropConverter;
import org.drools.workbench.screens.scenariosimulation.kogito.client.dmn.KogitoDMNService;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.MainJs;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.callbacks.DMN12UnmarshallCallback;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;

public class KogitoScenarioSimulationBuilder {
    @Inject
    private KogitoDMNService dmnTypeService;

    private static FactMappingType convert(FactModelTree.Type modelTreeType) {
        switch (modelTreeType) {
            case INPUT: {
                return FactMappingType.GIVEN;
            }
            case DECISION: {
                return FactMappingType.EXPECT;
            }
        }
        throw new IllegalArgumentException("Impossible to map");
    }

    public void populateScenarioSimulationModel(ScenarioSimulationModel content, ScenarioSimulationModel.Type type, String value, RemoteCallback<String> callback) {
        switch (type) {
            case RULE: {
                this.populateRULE(content, value, callback);
                break;
            }
            case DMN: {
                this.populateDMN(content, value, callback);
                break;
            }
            default: {
                throw new IllegalArgumentException("Impossible to map");
            }
        }
    }

    private void populateRULE(ScenarioSimulationModel toPopulate, String dmoSession, RemoteCallback<String> callback) {
        toPopulate.setSimulation(this.createRULESimulation());
        toPopulate.setBackground(this.createBackground());
        toPopulate.setSettings(this.createRULESettings(dmoSession));
        this.convertScenarioSimulationModel(toPopulate, callback);
    }

    private void populateDMN(ScenarioSimulationModel toPopulate, String dmnFilePath, RemoteCallback<String> callback) {
        toPopulate.setBackground(this.createBackground());
        this.populateDMNSimulationAndSettings(toPopulate, dmnFilePath, callback);
    }

    private void convertScenarioSimulationModel(ScenarioSimulationModel toConvert, RemoteCallback<String> callback) {
        JSIScenarioSimulationModelType jsiScenarioSimulationModelType = ApiJSInteropConverter.getJSIScenarioSimulationModelType(toConvert);
        SCESIM scesim = (SCESIM)Js.uncheckedCast((Object)JsUtils.newWrappedInstance());
        JsUtils.setNameOnWrapped((Object)scesim, (JSIName)this.makeJSINameForSCESIM());
        JsUtils.setValueOnWrapped((Object)scesim, (Object)jsiScenarioSimulationModelType);
        SCESIMMarshallCallback scesimMarshallCallback = this.getSCESIMMarshallCallback(callback);
        SCESIMMainJs.marshall((SCESIM)scesim, null, (SCESIMMarshallCallback)scesimMarshallCallback);
    }

    private JSIName makeJSINameForSCESIM() {
        JSIName jsiName = JSIScenarioSimulationModelType.getJSIName();
        jsiName.setPrefix("");
        jsiName.setLocalPart("ScenarioSimulationModel");
        String key = "{" + jsiName.getNamespaceURI() + "}" + jsiName.getLocalPart();
        String keyString = "{" + jsiName.getNamespaceURI() + "}" + jsiName.getPrefix() + ":" + jsiName.getLocalPart();
        jsiName.setKey(key);
        jsiName.setString(keyString);
        return jsiName;
    }

    protected Simulation createRULESimulation() {
        Simulation toReturn = new Simulation();
        ScesimModelDescriptor simulationDescriptor = toReturn.getScesimModelDescriptor();
        FactMapping indexFactMapping = simulationDescriptor.addFactMapping(FactIdentifier.INDEX.getName(), FactIdentifier.INDEX, ExpressionIdentifier.INDEX);
        indexFactMapping.setColumnWidth(Double.valueOf(KogitoScenarioSimulationBuilder.getColumnWidth(ExpressionIdentifier.INDEX.getName())));
        FactMapping descriptionFactMapping = simulationDescriptor.addFactMapping(FactIdentifier.DESCRIPTION.getName(), FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION);
        descriptionFactMapping.setColumnWidth(Double.valueOf(KogitoScenarioSimulationBuilder.getColumnWidth(ExpressionIdentifier.DESCRIPTION.getName())));
        ScenarioWithIndex scenarioWithIndex = this.createScesimDataWithIndex((AbstractScesimModel)toReturn, (BiFunction)ScenarioWithIndex::new);
        this.createEmptyColumn(simulationDescriptor, (ScesimDataWithIndex)scenarioWithIndex, 1, FactMappingType.GIVEN, simulationDescriptor.getFactMappings().size());
        this.createEmptyColumn(simulationDescriptor, (ScesimDataWithIndex)scenarioWithIndex, 2, FactMappingType.EXPECT, simulationDescriptor.getFactMappings().size());
        return toReturn;
    }

    private void populateDMNSimulationAndSettings(ScenarioSimulationModel toPopulate, String dmnFilePath, RemoteCallback<String> callback) {
        String dmnFileName = dmnFilePath.substring(dmnFilePath.lastIndexOf(47) + 1);
        Path dmnPath = PathFactory.newPath((String)dmnFileName, (String)dmnFilePath);
        this.dmnTypeService.getDMNContent(dmnPath, (RemoteCallback<String>)((RemoteCallback)dmnContent -> {
            DMN12UnmarshallCallback dmn12UnmarshallCallback = this.getDMN12UnmarshallCallback(toPopulate, dmnFilePath, callback);
            MainJs.unmarshall((String)dmnContent, (String)"", (DMN12UnmarshallCallback)dmn12UnmarshallCallback);
        }), (ErrorCallback<Object>)((ErrorCallback)(message, throwable) -> {
            GWT.log((String)("Error " + message.toString()), (Throwable)throwable);
            return false;
        }));
    }

    private Background createBackground() {
        Background toReturn = new Background();
        ScesimModelDescriptor simulationDescriptor = toReturn.getScesimModelDescriptor();
        int index = toReturn.getUnmodifiableData().size() + 1;
        BackgroundData backgroundData = (BackgroundData)toReturn.addData();
        BackgroundDataWithIndex backgroundDataWithIndex = new BackgroundDataWithIndex(index, backgroundData);
        this.createEmptyColumn(simulationDescriptor, (ScesimDataWithIndex)backgroundDataWithIndex, 1, FactMappingType.GIVEN, simulationDescriptor.getFactMappings().size());
        return toReturn;
    }

    private Settings createRULESettings(String dmoSession) {
        Settings toReturn = new Settings();
        toReturn.setType(ScenarioSimulationModel.Type.RULE);
        toReturn.setDmoSession(dmoSession);
        return toReturn;
    }

    private Settings createDMNSettings(String name, String nameSpace, String dmnFilePath) {
        Settings toReturn = new Settings();
        toReturn.setType(ScenarioSimulationModel.Type.DMN);
        toReturn.setDmnFilePath(dmnFilePath);
        toReturn.setDmnName(name);
        toReturn.setDmnNamespace(nameSpace);
        return toReturn;
    }

    private <T extends AbstractScesimData, E extends ScesimDataWithIndex<T>> E createScesimDataWithIndex(AbstractScesimModel<T> abstractScesimModel, BiFunction<Integer, T, E> producer) {
        AbstractScesimData scenario = abstractScesimModel.addData();
        scenario.setDescription(null);
        int index = abstractScesimModel.getUnmodifiableData().indexOf(scenario) + 1;
        return (E)((ScesimDataWithIndex)producer.apply(index, (Integer)scenario));
    }

    private void createEmptyColumn(ScesimModelDescriptor simulationDescriptor, ScesimDataWithIndex scesimDataWithIndex, int placeholderId, FactMappingType factMappingType, int columnIndex) {
        int row = scesimDataWithIndex.getIndex();
        ExpressionIdentifier expressionIdentifier = ExpressionIdentifier.create((String)(row + "|" + placeholderId), (FactMappingType)factMappingType);
        FactMapping factMapping = simulationDescriptor.addFactMapping(columnIndex, FactMapping.getInstancePlaceHolder((int)placeholderId), FactIdentifier.EMPTY, expressionIdentifier);
        factMapping.setColumnWidth(Double.valueOf(KogitoScenarioSimulationBuilder.getColumnWidth(expressionIdentifier.getName())));
        factMapping.setExpressionAlias(FactMapping.getPropertyPlaceHolder((int)placeholderId));
        scesimDataWithIndex.getScesimData().addMappingValue(FactIdentifier.EMPTY, expressionIdentifier, null);
    }

    private void addEmptyColumnsIfNeeded(Simulation simulation, ScenarioWithIndex scenarioWithIndex) {
        boolean hasGiven = false;
        boolean hasExpect = false;
        ScesimModelDescriptor simulationDescriptor = simulation.getScesimModelDescriptor();
        for (FactMapping factMapping : simulationDescriptor.getFactMappings()) {
            FactMappingType factMappingType = factMapping.getExpressionIdentifier().getType();
            if (!hasGiven && FactMappingType.GIVEN.equals((Object)factMappingType)) {
                hasGiven = true;
                continue;
            }
            if (hasExpect || !FactMappingType.EXPECT.equals((Object)factMappingType)) continue;
            hasExpect = true;
        }
        if (!hasGiven) {
            this.createEmptyColumn(simulationDescriptor, (ScesimDataWithIndex)scenarioWithIndex, 1, FactMappingType.GIVEN, this.findNewIndexOfGroup(simulationDescriptor, FactMappingType.GIVEN));
        }
        if (!hasExpect) {
            this.createEmptyColumn(simulationDescriptor, (ScesimDataWithIndex)scenarioWithIndex, 2, FactMappingType.EXPECT, this.findNewIndexOfGroup(simulationDescriptor, FactMappingType.EXPECT));
        }
    }

    private int findNewIndexOfGroup(ScesimModelDescriptor simulationDescriptor, FactMappingType factMappingType) {
        List factMappings = simulationDescriptor.getFactMappings();
        if (FactMappingType.GIVEN.equals((Object)factMappingType)) {
            for (int i = 0; i < factMappings.size(); ++i) {
                if (!FactMappingType.EXPECT.equals((Object)((FactMapping)factMappings.get(i)).getExpressionIdentifier().getType())) continue;
                return i;
            }
            return factMappings.size();
        }
        if (FactMappingType.EXPECT.equals((Object)factMappingType)) {
            return factMappings.size();
        }
        throw new IllegalArgumentException("This method can be invoked only with GIVEN or EXPECT as FactMappingType");
    }

    private SCESIMMarshallCallback getSCESIMMarshallCallback(RemoteCallback<String> remoteCallback) {
        return arg_0 -> remoteCallback.callback(arg_0);
    }

    private DMN12UnmarshallCallback getDMN12UnmarshallCallback(ScenarioSimulationModel toPopulate, String dmnFilePath, RemoteCallback<String> callback) {
        return dmn12 -> {
            JSITDefinitions jsitDefinitions = (JSITDefinitions)Js.uncheckedCast((Object)JsUtils.getUnwrappedElement((Object)dmn12));
            FactModelTuple factModelTuple = this.dmnTypeService.getFactModelTuple(jsitDefinitions);
            toPopulate.setSimulation(this.createDMNSimulation(factModelTuple));
            toPopulate.setSettings(this.createDMNSettings(jsitDefinitions.getName(), jsitDefinitions.getNamespace(), dmnFilePath));
            this.convertScenarioSimulationModel(toPopulate, callback);
        };
    }

    protected Simulation createDMNSimulation(FactModelTuple factModelTuple) {
        Simulation toReturn = new Simulation();
        ScesimModelDescriptor simulationDescriptor = toReturn.getScesimModelDescriptor();
        FactMapping indexFactMapping = simulationDescriptor.addFactMapping(FactIdentifier.INDEX.getName(), FactIdentifier.INDEX, ExpressionIdentifier.INDEX);
        indexFactMapping.setColumnWidth(Double.valueOf(KogitoScenarioSimulationBuilder.getColumnWidth(ExpressionIdentifier.INDEX.getName())));
        FactMapping descriptionFactMapping = simulationDescriptor.addFactMapping(FactIdentifier.DESCRIPTION.getName(), FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION);
        descriptionFactMapping.setColumnWidth(Double.valueOf(KogitoScenarioSimulationBuilder.getColumnWidth(ExpressionIdentifier.DESCRIPTION.getName())));
        ScenarioWithIndex scenarioWithIndex = this.createScesimDataWithIndex((AbstractScesimModel)toReturn, (BiFunction)ScenarioWithIndex::new);
        AtomicInteger id = new AtomicInteger(1);
        Collection visibleFactTrees = factModelTuple.getVisibleFacts().values();
        SortedMap hiddenValues = factModelTuple.getHiddenFacts();
        visibleFactTrees.stream().sorted((a, b) -> {
            FactModelTree.Type aType = a.getType();
            FactModelTree.Type bType = b.getType();
            int inputFirstOrder = FactModelTree.Type.INPUT.equals((Object)aType) ? -1 : 1;
            return aType.equals((Object)bType) ? 0 : inputFirstOrder;
        }).forEach(factModelTree -> {
            FactIdentifier factIdentifier = new FactIdentifier(factModelTree.getFactName(), factModelTree.getFactName());
            FactMappingExtractor factMappingExtractor = new FactMappingExtractor(factIdentifier, scenarioWithIndex.getIndex(), id, KogitoScenarioSimulationBuilder.convert(factModelTree.getType()), simulationDescriptor, scenarioWithIndex.getScesimData());
            this.addFactMapping(factMappingExtractor, (FactModelTree)factModelTree, (List<String>)new ArrayList<String>(), hiddenValues);
        });
        this.addEmptyColumnsIfNeeded(toReturn, scenarioWithIndex);
        return toReturn;
    }

    protected static double getColumnWidth(String expressionIdentifierName) {
        ExpressionIdentifier.NAME expressionName;
        try {
            expressionName = ExpressionIdentifier.NAME.valueOf((String)expressionIdentifierName);
        }
        catch (IllegalArgumentException e) {
            expressionName = ExpressionIdentifier.NAME.Other;
        }
        switch (expressionName) {
            case Index: {
                return 70.0;
            }
            case Description: {
                return 300.0;
            }
        }
        return 114.0;
    }

    protected void addFactMapping(FactMappingExtractor factMappingExtractor, FactModelTree factModelTree, List<String> previousSteps, Map<String, FactModelTree> hiddenValues) {
        this.internalAddToScenario(factMappingExtractor, factModelTree, previousSteps, hiddenValues, new HashSet<String>());
    }

    private void internalAddToScenario(FactMappingExtractor factMappingExtractor, FactModelTree factModelTree, List<String> readOnlyPreviousSteps, Map<String, FactModelTree> hiddenValues, Set<String> alreadyVisited) {
        ArrayList<String> previousSteps = new ArrayList<String>(readOnlyPreviousSteps);
        if (factModelTree.isSimple()) {
            String factType = (String)factModelTree.getSimpleProperties().get("value");
            factMappingExtractor.getFactMapping(factModelTree, "value", previousSteps, factType);
        } else {
            for (Map.Entry entry : factModelTree.getSimpleProperties().entrySet()) {
                String factName = (String)entry.getKey();
                String factType = (String)entry.getValue();
                FactMapping factMapping = factMappingExtractor.getFactMapping(factModelTree, factName, previousSteps, factType);
                if (ScenarioSimulationSharedUtils.isList((String)factType)) {
                    factMapping.setGenericTypes(factModelTree.getGenericTypeInfo(factName));
                }
                factMapping.addExpressionElement(factName, factType);
            }
            for (Map.Entry entry : factModelTree.getExpandableProperties().entrySet()) {
                String factType = (String)entry.getValue();
                FactModelTree nestedModelTree = hiddenValues.get(factType);
                if (previousSteps.isEmpty()) {
                    previousSteps.add(factModelTree.getFactName());
                }
                ArrayList<String> currentSteps = new ArrayList<String>(previousSteps);
                currentSteps.add((String)entry.getKey());
                if (alreadyVisited.contains(nestedModelTree.getFactName())) continue;
                alreadyVisited.add(factModelTree.getFactName());
                this.internalAddToScenario(factMappingExtractor, nestedModelTree, currentSteps, hiddenValues, alreadyVisited);
            }
        }
    }

    protected static class FactMappingExtractor {
        private final FactIdentifier factIdentifier;
        private final int row;
        private final AtomicInteger id;
        private final FactMappingType type;
        private final ScesimModelDescriptor simulationDescriptor;
        private final AbstractScesimData abstractScesimData;

        public FactMappingExtractor(FactIdentifier factIdentifier, int row, AtomicInteger id, FactMappingType type, ScesimModelDescriptor simulationDescriptor, AbstractScesimData abstractScesimData) {
            this.factIdentifier = factIdentifier;
            this.row = row;
            this.id = id;
            this.type = type;
            this.simulationDescriptor = simulationDescriptor;
            this.abstractScesimData = abstractScesimData;
        }

        public FactMapping getFactMapping(FactModelTree factModelTree, String propertyName, List<String> previousSteps, String factType) {
            String factAlias = !previousSteps.isEmpty() ? previousSteps.get(0) : factModelTree.getFactName();
            ExpressionIdentifier expressionIdentifier = ExpressionIdentifier.create((String)(this.row + "|" + this.id.getAndIncrement()), (FactMappingType)this.type);
            FactMapping factMapping = this.simulationDescriptor.addFactMapping(factAlias, this.factIdentifier, expressionIdentifier);
            ArrayList<String> localPreviousStep = new ArrayList<String>(previousSteps);
            localPreviousStep.add(propertyName);
            String expressionAlias = String.join((CharSequence)".", localPreviousStep.size() > 1 ? localPreviousStep.subList(1, localPreviousStep.size()) : localPreviousStep);
            factMapping.setExpressionAlias(expressionAlias);
            factMapping.setGenericTypes(factModelTree.getGenericTypeInfo("value"));
            factMapping.setColumnWidth(Double.valueOf(KogitoScenarioSimulationBuilder.getColumnWidth(this.factIdentifier.getName())));
            previousSteps.forEach(step -> factMapping.addExpressionElement(step, factType));
            if (previousSteps.isEmpty()) {
                factMapping.addExpressionElement(factModelTree.getFactName(), factType);
            }
            this.abstractScesimData.addMappingValue(this.factIdentifier, expressionIdentifier, null);
            return factMapping;
        }
    }
}

