/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.kogito.client.dmn;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import jsinterop.base.Js;
import org.drools.workbench.screens.scenariosimulation.kogito.client.dmn.ClientDMNType;
import org.drools.workbench.screens.scenariosimulation.kogito.client.dmn.KogitoDMNService;
import org.drools.workbench.screens.scenariosimulation.kogito.client.dmn.feel.BuiltInType;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecision;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInformationItem;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInputData;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITItemDefinition;

public abstract class AbstractKogitoDMNService
implements KogitoDMNService {
    public static final String URI_FEEL = "http://www.omg.org/spec/DMN/20180521/FEEL/";
    public static final String WRONG_DMN_MESSAGE = "Wrong DMN Type";
    protected static final QName TYPEREF_QNAME = new QName("", "typeRef", "");

    @Override
    public FactModelTuple getFactModelTuple(JSITDefinitions jsitDefinitions) {
        TreeMap<String, FactModelTree> visibleFacts = new TreeMap<String, FactModelTree>();
        TreeMap<String, FactModelTree> hiddenFacts = new TreeMap<String, FactModelTree>();
        ErrorHolder errorHolder = new ErrorHolder();
        Map<String, ClientDMNType> dmnTypesMap = this.getDMNDataTypesMap(jsitDefinitions.getItemDefinition(), jsitDefinitions.getNamespace());
        List jsitdrgElements = jsitDefinitions.getDrgElement();
        for (int i = 0; i < jsitdrgElements.size(); ++i) {
            ClientDMNType type;
            JSITDRGElement jsitdrgElement = (JSITDRGElement)Js.uncheckedCast(jsitdrgElements.get(i));
            if (this.isJSITInputData(jsitdrgElement)) {
                JSITInputData jsitInputData = (JSITInputData)Js.uncheckedCast((Object)jsitdrgElement);
                JSITInformationItem jsitInputDataVariable = jsitInputData.getVariable();
                type = this.getDMNTypeFromMaps(dmnTypesMap, this.getOtherAttributesMap((JSITDMNElement)jsitInputDataVariable));
                this.checkTypeSupport(type, errorHolder, jsitInputData.getName());
                visibleFacts.put(jsitInputData.getName(), this.createTopLevelFactModelTree(jsitInputData.getName(), type, hiddenFacts, FactModelTree.Type.INPUT));
                continue;
            }
            if (!this.isJSITDecision(jsitdrgElement)) continue;
            JSITDecision jsitDecision = (JSITDecision)Js.uncheckedCast((Object)jsitdrgElement);
            JSITInformationItem jsitDecisionVariable = jsitDecision.getVariable();
            type = this.getDMNTypeFromMaps(dmnTypesMap, this.getOtherAttributesMap((JSITDMNElement)jsitDecisionVariable));
            this.checkTypeSupport(type, errorHolder, jsitdrgElement.getName());
            visibleFacts.put(jsitDecisionVariable.getName(), this.createTopLevelFactModelTree(jsitDecisionVariable.getName(), type, hiddenFacts, FactModelTree.Type.DECISION));
        }
        FactModelTuple toReturn = new FactModelTuple(visibleFacts, hiddenFacts);
        errorHolder.getMultipleNestedCollection().forEach(arg_0 -> ((FactModelTuple)toReturn).addMultipleNestedCollectionError(arg_0));
        errorHolder.getMultipleNestedObject().forEach(arg_0 -> ((FactModelTuple)toReturn).addMultipleNestedObjectError(arg_0));
        return toReturn;
    }

    protected ClientDMNType getDMNTypeFromMaps(Map<String, ClientDMNType> dmnTypesMap, Map<QName, String> source) {
        String typeRef = source.get(TYPEREF_QNAME);
        if (typeRef == null) {
            typeRef = BuiltInType.ANY.getName();
        }
        return dmnTypesMap.get(typeRef);
    }

    protected Map<String, ClientDMNType> getDMNDataTypesMap(List<JSITItemDefinition> jsitItemDefinitions, String nameSpace) {
        HashMap<String, ClientDMNType> dmnDataTypesMap = new HashMap<String, ClientDMNType>();
        for (BuiltInType type : BuiltInType.values()) {
            for (String name : type.getNames()) {
                ClientDMNType feelPrimitiveType = type == BuiltInType.CONTEXT ? new ClientDMNType(URI_FEEL, name, null, false, true, Collections.emptyMap(), type) : new ClientDMNType(URI_FEEL, name, null, false, type);
                dmnDataTypesMap.put(name, feelPrimitiveType);
            }
        }
        Map<String, JSITItemDefinition> itemDefinitionMap = this.indexDefinitionsByName(jsitItemDefinitions);
        for (int i = 0; i < jsitItemDefinitions.size(); ++i) {
            JSITItemDefinition jsitItemDefinition = (JSITItemDefinition)Js.uncheckedCast((Object)jsitItemDefinitions.get(i));
            this.getOrCreateDMNType(itemDefinitionMap, jsitItemDefinition.getName(), nameSpace, dmnDataTypesMap);
        }
        return Collections.unmodifiableMap(dmnDataTypesMap);
    }

    ClientDMNType getOrCreateDMNType(Map<String, JSITItemDefinition> allDefinitions, String requiredType, String namespace, Map<String, ClientDMNType> createdTypes) {
        if (createdTypes.containsKey(requiredType)) {
            return createdTypes.get(requiredType);
        }
        if (!allDefinitions.containsKey(requiredType)) {
            throw new IllegalStateException("Type '" + requiredType + "' not found.");
        }
        JSITItemDefinition value = (JSITItemDefinition)Js.uncheckedCast((Object)allDefinitions.get(requiredType));
        return this.createDMNType(allDefinitions, value, namespace, createdTypes);
    }

    Map<String, JSITItemDefinition> indexDefinitionsByName(List<JSITItemDefinition> allDefinitions) {
        HashMap<String, JSITItemDefinition> index = new HashMap<String, JSITItemDefinition>();
        for (int i = 0; i < allDefinitions.size(); ++i) {
            JSITItemDefinition value = (JSITItemDefinition)Js.uncheckedCast((Object)allDefinitions.get(i));
            index.put(value.getName(), value);
        }
        return Collections.unmodifiableMap(index);
    }

    protected ClientDMNType createDMNType(Map<String, JSITItemDefinition> allDefinitions, JSITItemDefinition itemDefinition, String namespace, Map<String, ClientDMNType> dmnTypesDataMap) {
        String typeRef;
        ClientDMNType itemDefinitionDMNType = new ClientDMNType(namespace, itemDefinition.getName(), itemDefinition.getId(), itemDefinition.getIsCollection(), itemDefinition.getItemComponent() != null && !itemDefinition.getItemComponent().isEmpty());
        if (allDefinitions.containsKey(itemDefinition.getName())) {
            dmnTypesDataMap.put(itemDefinition.getName(), itemDefinitionDMNType);
        }
        if ((typeRef = itemDefinition.getTypeRef()) != null) {
            ClientDMNType superDmnType = this.getOrCreateDMNType(allDefinitions, typeRef, namespace, dmnTypesDataMap);
            if (superDmnType != null) {
                itemDefinitionDMNType.addFields(superDmnType.getFields());
                itemDefinitionDMNType.setCollection(superDmnType.isCollection() || itemDefinitionDMNType.isCollection());
                itemDefinitionDMNType.setIsComposite(superDmnType.isComposite() || itemDefinitionDMNType.isComposite());
                itemDefinitionDMNType.setFeelType(superDmnType.getFeelType() != null ? superDmnType.getFeelType() : null);
            } else {
                throw new IllegalStateException("Item: " + itemDefinition.getName() + " refers to typeRef: " + itemDefinition.getTypeRef() + " which can't be found.");
            }
        }
        this.populateItemDefinitionFields(allDefinitions, itemDefinition, namespace, dmnTypesDataMap, itemDefinitionDMNType);
        return itemDefinitionDMNType;
    }

    protected void populateItemDefinitionFields(Map<String, JSITItemDefinition> allItemDefinitions, JSITItemDefinition itemDefinition, String namespace, Map<String, ClientDMNType> dmnTypesMap, ClientDMNType clientDMNType) {
        List jsitItemDefinitionFields = itemDefinition.getItemComponent();
        if (jsitItemDefinitionFields != null && !jsitItemDefinitionFields.isEmpty()) {
            for (int i = 0; i < jsitItemDefinitionFields.size(); ++i) {
                ClientDMNType fieldDMNType;
                boolean hasSubFields;
                JSITItemDefinition jsitItemDefinitionField = (JSITItemDefinition)Js.uncheckedCast(jsitItemDefinitionFields.get(i));
                String typeRef = jsitItemDefinitionField.getTypeRef();
                List subfields = jsitItemDefinitionField.getItemComponent();
                boolean bl = hasSubFields = subfields != null && !subfields.isEmpty();
                if (typeRef != null && !hasSubFields) {
                    fieldDMNType = this.getOrCreateDMNType(allItemDefinitions, typeRef, namespace, dmnTypesMap);
                } else {
                    if (typeRef != null || !hasSubFields) continue;
                    fieldDMNType = this.createDMNType(allItemDefinitions, jsitItemDefinitionField, namespace, dmnTypesMap);
                }
                if (jsitItemDefinitionField.getIsCollection() && !fieldDMNType.isCollection()) {
                    fieldDMNType = fieldDMNType.copyAsCollection();
                }
                clientDMNType.addField(jsitItemDefinitionField.getName(), fieldDMNType);
            }
        }
    }

    protected void checkTypeSupport(ClientDMNType type, ErrorHolder errorHolder, String fullPropertyPath) {
        this.internalCheckTypeSupport(type, false, errorHolder, fullPropertyPath, new HashSet<String>());
    }

    protected void internalCheckTypeSupport(ClientDMNType type, boolean alreadyInCollection, ErrorHolder errorHolder, String fullPropertyPath, Set<String> alreadyVisited) {
        alreadyVisited.add(type.getName());
        if (type.isComposite()) {
            for (Map.Entry<String, ClientDMNType> entry : type.getFields().entrySet()) {
                String name = entry.getKey();
                ClientDMNType nestedType = entry.getValue();
                String nestedPath = fullPropertyPath + "." + name;
                if (alreadyInCollection && nestedType.isCollection()) {
                    errorHolder.getMultipleNestedCollection().add(nestedPath);
                }
                if (alreadyInCollection && nestedType.isComposite()) {
                    errorHolder.getMultipleNestedObject().add(nestedPath);
                }
                if (alreadyVisited.contains(nestedType.getName())) continue;
                this.internalCheckTypeSupport(nestedType, alreadyInCollection || nestedType.isCollection(), errorHolder, nestedPath, alreadyVisited);
            }
        }
    }

    protected FactModelTree createTopLevelFactModelTree(String factName, ClientDMNType type, SortedMap<String, FactModelTree> hiddenFacts, FactModelTree.Type fmType) {
        return this.isToBeManagedAsCollection(type) ? this.createFactModelTreeForCollection(new HashMap<String, List<String>>(), factName, type, hiddenFacts, fmType, new ArrayList<String>()) : this.createFactModelTreeForNoCollection(new HashMap<String, List<String>>(), factName, factName, type.getName(), type, hiddenFacts, fmType, new ArrayList<String>());
    }

    protected boolean isToBeManagedAsCollection(ClientDMNType type) {
        BuiltInType feelType;
        boolean toReturn = type.isCollection();
        if (toReturn && Objects.equals((Object)BuiltInType.CONTEXT, (Object)(feelType = type.getFeelType()))) {
            toReturn = false;
        }
        return toReturn;
    }

    protected boolean isToBeManagedAsComposite(ClientDMNType type) {
        BuiltInType feelType;
        boolean toReturn = type.isComposite();
        if (toReturn && Objects.equals((Object)BuiltInType.CONTEXT, (Object)(feelType = type.getFeelType()))) {
            toReturn = false;
        }
        return toReturn;
    }

    protected FactModelTree createFactModelTreeForCollection(Map<String, List<String>> genericTypeInfoMap, String factName, ClientDMNType type, SortedMap<String, FactModelTree> hiddenFacts, FactModelTree.Type fmType, List<String> alreadyVisited) {
        if (!type.isCollection() && !this.isToBeManagedAsCollection(type)) {
            throw new IllegalStateException(WRONG_DMN_MESSAGE);
        }
        String typeName = type.getName();
        this.populateGeneric(genericTypeInfoMap, "value", typeName);
        FactModelTree toReturn = this.createFactModelTreeForSimple(genericTypeInfoMap, factName, List.class.getCanonicalName(), fmType);
        if (!hiddenFacts.containsKey(typeName) && !alreadyVisited.contains(typeName)) {
            alreadyVisited.add(typeName);
            FactModelTree genericFactModelTree = this.createFactModelTreeForGenericType(new HashMap<String, List<String>>(), typeName, typeName, typeName, type, hiddenFacts, fmType, alreadyVisited);
            hiddenFacts.put(typeName, genericFactModelTree);
        }
        return toReturn;
    }

    protected String populateGeneric(Map<String, List<String>> genericTypeInfoMap, String fullPropertyPath, String type) {
        String toReturn = fullPropertyPath;
        genericTypeInfoMap.put(fullPropertyPath, Collections.singletonList(type));
        return toReturn;
    }

    protected FactModelTree createFactModelTreeForNoCollection(Map<String, List<String>> genericTypeInfoMap, String factName, String propertyName, String fullPropertyPath, ClientDMNType type, SortedMap<String, FactModelTree> hiddenFacts, FactModelTree.Type fmType, List<String> alreadyVisited) {
        if (type.isCollection() && this.isToBeManagedAsCollection(type)) {
            throw new IllegalStateException(WRONG_DMN_MESSAGE);
        }
        return this.isToBeManagedAsComposite(type) ? this.createFactModelTreeForComposite(genericTypeInfoMap, propertyName, fullPropertyPath, type, hiddenFacts, fmType, alreadyVisited) : this.createFactModelTreeForSimple(genericTypeInfoMap, factName, type.getName(), fmType);
    }

    protected FactModelTree createFactModelTreeForGenericType(Map<String, List<String>> genericTypeInfoMap, String factName, String propertyName, String fullPropertyPath, ClientDMNType type, SortedMap<String, FactModelTree> hiddenFacts, FactModelTree.Type fmType, List<String> alreadyVisited) {
        return type.isComposite() ? this.createFactModelTreeForComposite(genericTypeInfoMap, propertyName, fullPropertyPath, type, hiddenFacts, fmType, alreadyVisited) : this.createFactModelTreeForSimple(genericTypeInfoMap, factName, type.getName(), fmType);
    }

    protected FactModelTree createFactModelTreeForSimple(Map<String, List<String>> genericTypeInfoMap, String factName, String propertyClass, FactModelTree.Type fmType) {
        HashMap simpleProperties = new HashMap();
        FactModelTree simpleFactModelTree = new FactModelTree(factName, "", simpleProperties, genericTypeInfoMap, fmType);
        simpleFactModelTree.addSimpleProperty("value", propertyClass);
        simpleFactModelTree.setSimple(true);
        return simpleFactModelTree;
    }

    protected FactModelTree createFactModelTreeForComposite(Map<String, List<String>> genericTypeInfoMap, String name, String fullPropertyPath, ClientDMNType type, SortedMap<String, FactModelTree> hiddenFacts, FactModelTree.Type fmType, List<String> alreadyVisited) {
        if (!type.isComposite() && !this.isToBeManagedAsComposite(type)) {
            throw new IllegalStateException(WRONG_DMN_MESSAGE);
        }
        HashMap<String, String> simpleFields = new HashMap<String, String>();
        FactModelTree toReturn = new FactModelTree(name, "", simpleFields, genericTypeInfoMap, fmType);
        for (Map.Entry<String, ClientDMNType> entry : type.getFields().entrySet()) {
            String expandablePropertyName = fullPropertyPath + "." + entry.getKey();
            if (this.isToBeManagedAsCollection(entry.getValue())) {
                FactModelTree fact = this.createFactModelTreeForCollection(new HashMap<String, List<String>>(), entry.getKey(), entry.getValue(), hiddenFacts, FactModelTree.Type.UNDEFINED, alreadyVisited);
                simpleFields.put(entry.getKey(), List.class.getCanonicalName());
                genericTypeInfoMap.put(entry.getKey(), fact.getGenericTypeInfo("value"));
                continue;
            }
            String typeName = entry.getValue().getName();
            if (entry.getValue().isComposite()) {
                if (!hiddenFacts.containsKey(typeName) && !alreadyVisited.contains(typeName)) {
                    alreadyVisited.add(typeName);
                    FactModelTree fact = this.createFactModelTreeForNoCollection(genericTypeInfoMap, entry.getKey(), "value", expandablePropertyName, entry.getValue(), hiddenFacts, FactModelTree.Type.UNDEFINED, alreadyVisited);
                    hiddenFacts.put(typeName, fact);
                }
                toReturn.addExpandableProperty(entry.getKey(), typeName);
                continue;
            }
            simpleFields.put(entry.getKey(), typeName);
        }
        return toReturn;
    }

    public boolean isJSITInputData(JSITDRGElement jsitdrgElement) {
        return JSITInputData.instanceOf((Object)jsitdrgElement);
    }

    public boolean isJSITDecision(JSITDRGElement jsitdrgElement) {
        return JSITDecision.instanceOf((Object)jsitdrgElement);
    }

    public Map<QName, String> getOtherAttributesMap(JSITDMNElement jsitInputDataVariable) {
        return JSITDMNElement.getOtherAttributesMap((JSITDMNElement)jsitInputDataVariable);
    }

    private static class ErrorHolder {
        Set<String> multipleNestedObject = new TreeSet<String>();
        Set<String> multipleNestedCollection = new TreeSet<String>();

        private ErrorHolder() {
        }

        public Set<String> getMultipleNestedObject() {
            return this.multipleNestedObject;
        }

        public Set<String> getMultipleNestedCollection() {
            return this.multipleNestedCollection;
        }
    }
}

