/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.kogito.client.editor.strategies;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.kogito.client.dmo.KogitoAsyncPackageDataModelOracle;
import org.drools.workbench.screens.scenariosimulation.kogito.client.editor.strategies.KogitoDMODataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;

@RunWith(value=GwtMockitoTestRunner.class)
public class KogitoDMODataManagementStrategyTest {
    private static final String FACT_NAME = "factName";
    @Mock
    private KogitoAsyncPackageDataModelOracle oracleMock;
    @Mock
    private ObservablePath observablePathMock;
    @Mock
    private ScenarioSimulationModelContent scenarioSimulationModelContentMock;
    @Mock
    private ScenarioSimulationContext scenarioSimulationContextMock;
    @Mock
    private TestToolsPresenter testToolsPresenterMock;
    @Mock
    private FactModelTree factModelTreeMock;
    @Mock
    private GridWidget gridWidgetMock;
    private KogitoDMODataManagementStrategy kogitoDMODataManagementStrategySpy;

    @Before
    public void setup() {
        this.kogitoDMODataManagementStrategySpy = (KogitoDMODataManagementStrategy)Mockito.spy((Object)new KogitoDMODataManagementStrategy(this.oracleMock){

            public FactModelTree getFactModelTree(String factName, Map<String, String> superTypeMap, ModelField[] modelFields) {
                return KogitoDMODataManagementStrategyTest.this.factModelTreeMock;
            }

            public void aggregatorCallbackMethod(TestToolsView.Presenter testToolsPresenter, int expectedElements, SortedMap<String, FactModelTree> factTypeFieldsMap, ScenarioSimulationContext context, FactModelTree result, List<String> simpleJavaTypes, GridWidget gridWidget) {
            }
        });
    }

    @Test
    public void manageScenarioSimulationModelContent() {
        this.kogitoDMODataManagementStrategySpy.manageScenarioSimulationModelContent(this.observablePathMock, this.scenarioSimulationModelContentMock);
        ((ScenarioSimulationModelContent)Mockito.verify((Object)this.scenarioSimulationModelContentMock, (VerificationMode)Mockito.times((int)1))).getModel();
        ((KogitoAsyncPackageDataModelOracle)Mockito.verify((Object)this.oracleMock, (VerificationMode)Mockito.times((int)1))).init((Path)Matchers.eq((Object)this.observablePathMock));
    }

    @Test
    public void isADataTypeEmpty() {
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)new String[0]);
        Assert.assertFalse((boolean)this.kogitoDMODataManagementStrategySpy.isADataType("Test"));
    }

    @Test
    public void isADataTypeTrue() {
        String[] array = new String[]{"Test"};
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)array);
        Assert.assertTrue((boolean)this.kogitoDMODataManagementStrategySpy.isADataType("Test"));
    }

    @Test
    public void isADataTypeFalse() {
        String[] array = new String[]{"Est"};
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)array);
        Assert.assertFalse((boolean)this.kogitoDMODataManagementStrategySpy.isADataType("Test"));
    }

    @Test
    public void retrieveFactModelTuple() {
        String factType = "factType";
        ModelField[] modelFields = new ModelField[1];
        Mockito.when((Object)this.oracleMock.getFieldCompletions((String)Matchers.eq((Object)factType))).thenReturn((Object)modelFields);
        List<String> dataObjectsType = Arrays.asList(factType);
        TreeMap dataObjectsFieldMap = new TreeMap();
        Map superTypesMap = Collections.emptyMap();
        ArrayList javaSimpleType = new ArrayList();
        this.kogitoDMODataManagementStrategySpy.manageDataObjects(dataObjectsType, superTypesMap, (TestToolsView.Presenter)this.testToolsPresenterMock, 1, dataObjectsFieldMap, this.scenarioSimulationContextMock, javaSimpleType, this.gridWidgetMock);
        ((KogitoAsyncPackageDataModelOracle)Mockito.verify((Object)this.oracleMock, (VerificationMode)Mockito.times((int)1))).getFieldCompletions((String)Matchers.eq((Object)factType));
        ((KogitoDMODataManagementStrategy)Mockito.verify((Object)this.kogitoDMODataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).getFactModelTree((String)Matchers.eq((Object)factType), (Map)Matchers.eq(superTypesMap), (ModelField[])Matchers.eq((Object)modelFields));
        ((KogitoDMODataManagementStrategy)Mockito.verify((Object)this.kogitoDMODataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).aggregatorCallbackMethod((TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), Matchers.eq((int)1), (SortedMap)Matchers.eq(dataObjectsFieldMap), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextMock), (FactModelTree)Matchers.eq((Object)this.factModelTreeMock), (List)Matchers.eq(javaSimpleType), (GridWidget)Matchers.eq((Object)this.gridWidgetMock));
    }

    @Test
    public void getFactTypesEmpty() {
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)new String[0]);
        List facts = this.kogitoDMODataManagementStrategySpy.getFactTypes();
        Assert.assertTrue((boolean)facts.isEmpty());
    }

    @Test
    public void getFactTypes() {
        String[] array = new String[]{"Test"};
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)array);
        List facts = this.kogitoDMODataManagementStrategySpy.getFactTypes();
        Assert.assertTrue((facts.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Test", facts.get(0));
    }

    @Test
    public void skipPopulateTestToolsEmptyArray() {
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)new String[0]);
        Assert.assertTrue((boolean)this.kogitoDMODataManagementStrategySpy.skipPopulateTestTools());
    }

    @Test
    public void skipPopulateTestToolsArrayPopulated() {
        String[] array = new String[]{"Test"};
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)array);
        Assert.assertFalse((boolean)this.kogitoDMODataManagementStrategySpy.skipPopulateTestTools());
    }

    @Test
    public void getFQCNByFactName() {
        this.kogitoDMODataManagementStrategySpy.getFQCNByFactName(FACT_NAME);
        ((KogitoAsyncPackageDataModelOracle)Mockito.verify((Object)this.oracleMock, (VerificationMode)Mockito.times((int)1))).getFQCNByFactName((String)Matchers.eq((Object)FACT_NAME));
    }

    @Test
    public void getParametricFieldType() {
        this.kogitoDMODataManagementStrategySpy.getParametricFieldType(FACT_NAME, "propertyName");
        ((KogitoAsyncPackageDataModelOracle)Mockito.verify((Object)this.oracleMock, (VerificationMode)Mockito.times((int)1))).getParametricFieldType((String)Matchers.eq((Object)FACT_NAME), (String)Matchers.eq((Object)"propertyName"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getSuperType() {
        this.kogitoDMODataManagementStrategySpy.getSuperType("", null);
    }
}

