/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.kogito.client.editor.strategies;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.events.ScenarioNotificationEvent;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.kogito.client.dmn.KogitoDMNService;
import org.drools.workbench.screens.scenariosimulation.kogito.client.editor.strategies.KogitoDMNDataManagementStrategy;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;

@RunWith(value=GwtMockitoTestRunner.class)
public class KogitoDMNDataManagementStrategyTest {
    @Mock
    private EventBus eventBusMock;
    @Mock
    private KogitoDMNService kogitoDMNServiceMock;
    @Mock
    private ScenarioSimulationContext scenarioSimulationContextMock;
    @Mock
    private TestToolsPresenter testToolsPresenterMock;
    @Mock
    private GridWidget gridWidgetMock;
    @Mock
    private RemoteCallback remoteCallbackMock;
    private KogitoDMNDataManagementStrategy kogitoDMNDataManagementStrategySpy;

    @Before
    public void setup() {
        this.kogitoDMNDataManagementStrategySpy = (KogitoDMNDataManagementStrategy)Mockito.spy((Object)new KogitoDMNDataManagementStrategy(this.eventBusMock, this.kogitoDMNServiceMock));
    }

    @Test
    public void retrieveFactModelTuple() {
        this.kogitoDMNDataManagementStrategySpy.retrieveFactModelTuple((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioSimulationContextMock, this.gridWidgetMock, "path/dmnFile.dmn");
        PathFactory.PathImpl expectedPath = new PathFactory.PathImpl("dmnFile.dmn", "path/dmnFile.dmn");
        ((KogitoDMNDataManagementStrategy)Mockito.verify((Object)this.kogitoDMNDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).getSuccessCallback((TestToolsView.Presenter)Matchers.eq((Object)this.testToolsPresenterMock), (ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextMock), (GridWidget)Matchers.eq((Object)this.gridWidgetMock));
        ((KogitoDMNService)Mockito.verify((Object)this.kogitoDMNServiceMock, (VerificationMode)Mockito.times((int)1))).getDMNContent((Path)Matchers.eq((Object)expectedPath), (RemoteCallback)Matchers.isA(RemoteCallback.class), (ErrorCallback)Matchers.isA(ErrorCallback.class));
    }

    @Test
    public void getDMNContentRemoteCallback() {
        RemoteCallback remoteCallback = this.kogitoDMNDataManagementStrategySpy.getDMNContentRemoteCallback(this.remoteCallbackMock);
        Assert.assertNotNull((Object)remoteCallback);
        remoteCallback.callback((Object)"");
        ((KogitoDMNDataManagementStrategy)Mockito.verify((Object)this.kogitoDMNDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).getDMN12UnmarshallCallback((RemoteCallback)Matchers.eq((Object)this.remoteCallbackMock));
    }

    @Test
    public void getDMNContentErrorCallback() {
        ErrorCallback remoteCallback = this.kogitoDMNDataManagementStrategySpy.getDMNContentErrorCallback("dmnpath/");
        Assert.assertNotNull((Object)remoteCallback);
        remoteCallback.error((Object)"message", (Throwable)new Exception());
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(ScenarioNotificationEvent.class));
    }
}

