/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.kogito.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.promise.Promise;
import java.util.Arrays;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.workbench.scenariosimulation.kogito.marshaller.js.callbacks.SCESIMMarshallCallback;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorWrapper;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridWidget;
import org.drools.workbench.screens.scenariosimulation.kogito.client.dmn.KogitoScenarioSimulationBuilder;
import org.drools.workbench.screens.scenariosimulation.kogito.client.dmo.KogitoAsyncPackageDataModelOracle;
import org.drools.workbench.screens.scenariosimulation.kogito.client.editor.ScenarioSimulationEditorKogitoWrapper;
import org.drools.workbench.screens.scenariosimulation.kogito.client.editor.strategies.KogitoDMNDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.kogito.client.editor.strategies.KogitoDMODataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.kogito.client.handlers.ScenarioSimulationKogitoDocksHandler;
import org.drools.workbench.screens.scenariosimulation.kogito.client.popup.ScenarioSimulationKogitoCreationPopupPresenter;
import org.gwtbootstrap3.client.ui.NavTabs;
import org.gwtbootstrap3.client.ui.TabListItem;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.kogito.client.editor.BaseKogitoEditor;
import org.kie.workbench.common.kogito.client.editor.MultiPageEditorContainerView;
import org.kie.workbench.common.widgets.client.docks.AuthoringEditorDock;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.mockito.ArgumentCaptor;
import org.mockito.BDDMockito;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.promise.Promises;
import org.uberfire.client.views.pfly.multipage.MultiPageEditorViewImpl;
import org.uberfire.client.workbench.widgets.multipage.MultiPageEditor;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioSimulationEditorKogitoWrapperTest {
    private static final String JSON_MODEL = "jsonModel";
    @Mock
    private FileMenuBuilder fileMenuBuilderMock;
    @Mock
    private Menus menusMock;
    @Mock
    private Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<String> resolveCallBackMock;
    @Mock
    private Promises promisesMock;
    @Mock
    private ScenarioSimulationEditorPresenter scenarioSimulationEditorPresenterMock;
    @Mock
    private MenuItem menuItemMock;
    @Mock
    private ScenarioSimulationModel scenarioSimulationModelMock;
    @Mock
    private ScenarioSimulationContext scenarioSimulationContextMock;
    @Mock
    private Settings settingsMock;
    @Mock
    private ScenarioGridPanel simulationGridPanelMock;
    @Mock
    private ScenarioGridPanel backgroundGridPanelMock;
    @Mock
    private ScenarioGridWidget scenarioGridWidgetMock;
    @Mock
    private MultiPageEditorContainerView multiPageEditorContainerViewMock;
    @Mock
    private MultiPageEditor multiPageEditorMock;
    @Mock
    private MultiPageEditorViewImpl multiPageEditorViewMock;
    @Mock
    private TranslationService translationServiceMock;
    @Mock
    private NavTabs navBarsMock;
    @Mock
    private TabListItem editorItemMock;
    @Mock
    private TabListItem backgroundItemMock;
    @Mock
    private ScenarioSimulationKogitoCreationPopupPresenter scenarioSimulationKogitoCreationPopupPresenterMock;
    @Mock
    private KogitoScenarioSimulationBuilder kogitoScenarioSimulationBuilderMock;
    @Mock
    private KogitoAsyncPackageDataModelOracle kogitoAsyncPackageDataModelOracleMock;
    @Mock
    private Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<Object> resolveCallbackFnMock;
    @Mock
    private Promise.PromiseExecutorCallbackFn.RejectCallbackFn rejectCallbackFnMock;
    @Mock
    private PlaceRequest placeRequestMock;
    @Mock
    private ScenarioSimulationKogitoDocksHandler scenarioSimulationKogitoDocksHandlerMock;
    @Mock
    private AuthoringEditorDock authoringEditorDockMock;
    @Captor
    private ArgumentCaptor<DataManagementStrategy> dataManagementStrategyCaptor;
    @Captor
    private ArgumentCaptor<Page> pageCaptor;
    @Captor
    private ArgumentCaptor<RemoteCallback> remoteCallbackArgumentCaptor;
    @Captor
    private ArgumentCaptor<Path> pathArgumentCaptor;
    @Captor
    private ArgumentCaptor<Promise.PromiseExecutorCallbackFn> promiseExecutorCallbackFnArgumentCaptor;
    private ScenarioSimulationEditorKogitoWrapper scenarioSimulationEditorKogitoWrapperSpy;
    private Path path = PathFactory.newPath((String)"file.scesim", (String)"path/");

    @Before
    public void setup() {
        Mockito.when((Object)this.fileMenuBuilderMock.build()).thenReturn((Object)this.menusMock);
        Mockito.when((Object)this.menusMock.getItems()).thenReturn(Arrays.asList(this.menuItemMock));
        Mockito.when((Object)this.scenarioSimulationEditorPresenterMock.getModel()).thenReturn((Object)this.scenarioSimulationModelMock);
        Mockito.when((Object)this.scenarioSimulationModelMock.getSettings()).thenReturn((Object)this.settingsMock);
        Mockito.when((Object)this.scenarioSimulationEditorPresenterMock.getContext()).thenReturn((Object)this.scenarioSimulationContextMock);
        Mockito.when((Object)this.scenarioSimulationContextMock.getScenarioGridPanelByGridWidget(GridWidget.SIMULATION)).thenReturn((Object)this.simulationGridPanelMock);
        Mockito.when((Object)this.scenarioSimulationContextMock.getScenarioGridPanelByGridWidget(GridWidget.BACKGROUND)).thenReturn((Object)this.backgroundGridPanelMock);
        Mockito.when((Object)this.multiPageEditorContainerViewMock.getMultiPage()).thenReturn((Object)this.multiPageEditorMock);
        Mockito.when((Object)this.multiPageEditorMock.getView()).thenReturn((Object)this.multiPageEditorViewMock);
        Mockito.when((Object)this.multiPageEditorViewMock.getPageIndex("KieEditorWrapperView.EditTabTitle")).thenReturn((Object)1);
        Mockito.when((Object)this.multiPageEditorViewMock.getPageIndex(ScenarioSimulationEditorConstants.INSTANCE.backgroundTabTitle())).thenReturn((Object)2);
        Mockito.when((Object)this.multiPageEditorViewMock.getTabBar()).thenReturn((Object)this.navBarsMock);
        Mockito.when((Object)this.navBarsMock.getWidget(1)).thenReturn((Object)this.editorItemMock);
        Mockito.when((Object)this.navBarsMock.getWidget(2)).thenReturn((Object)this.backgroundItemMock);
        Mockito.when((Object)this.scenarioSimulationKogitoCreationPopupPresenterMock.getSelectedPath()).thenReturn((Object)"selected");
        Mockito.when((Object)this.translationServiceMock.getTranslation("KieEditorWrapperView.EditTabTitle")).thenReturn((Object)"KieEditorWrapperView.EditTabTitle");
        this.scenarioSimulationEditorKogitoWrapperSpy = (ScenarioSimulationEditorKogitoWrapper)Mockito.spy((Object)new ScenarioSimulationEditorKogitoWrapper(){
            {
                this.fileMenuBuilder = ScenarioSimulationEditorKogitoWrapperTest.this.fileMenuBuilderMock;
                this.scenarioSimulationEditorPresenter = ScenarioSimulationEditorKogitoWrapperTest.this.scenarioSimulationEditorPresenterMock;
                this.promises = ScenarioSimulationEditorKogitoWrapperTest.this.promisesMock;
                this.kogitoOracle = ScenarioSimulationEditorKogitoWrapperTest.this.kogitoAsyncPackageDataModelOracleMock;
                this.translationService = ScenarioSimulationEditorKogitoWrapperTest.this.translationServiceMock;
                this.scenarioSimulationKogitoCreationPopupPresenter = ScenarioSimulationEditorKogitoWrapperTest.this.scenarioSimulationKogitoCreationPopupPresenterMock;
                this.scenarioSimulationBuilder = ScenarioSimulationEditorKogitoWrapperTest.this.kogitoScenarioSimulationBuilderMock;
                this.authoringWorkbenchDocks = ScenarioSimulationEditorKogitoWrapperTest.this.authoringEditorDockMock;
                this.scenarioSimulationKogitoDocksHandler = ScenarioSimulationEditorKogitoWrapperTest.this.scenarioSimulationKogitoDocksHandlerMock;
            }

            public MultiPageEditorContainerView getWidget() {
                return ScenarioSimulationEditorKogitoWrapperTest.this.multiPageEditorContainerViewMock;
            }

            protected void marshallContent(ScenarioSimulationModel scenarioSimulationModel, Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<String> resolveCallbackFn) {
            }

            protected void resetEditorPages() {
            }
        });
    }

    @Test
    public void buildMenuBar() {
        this.scenarioSimulationEditorKogitoWrapperSpy.buildMenuBar();
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock, (VerificationMode)Mockito.times((int)1))).build();
        ((MenuItem)Mockito.verify((Object)this.menuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)true));
    }

    @Test
    public void getContent() {
        this.scenarioSimulationEditorKogitoWrapperSpy.getContent();
        ((Promises)Mockito.verify((Object)this.promisesMock, (VerificationMode)Mockito.times((int)1))).create((Promise.PromiseExecutorCallbackFn)this.promiseExecutorCallbackFnArgumentCaptor.capture());
        ((Promise.PromiseExecutorCallbackFn)this.promiseExecutorCallbackFnArgumentCaptor.getValue()).onInvoke(this.resolveCallBackMock, this.rejectCallbackFnMock);
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).prepareContent((Promise.PromiseExecutorCallbackFn.ResolveCallbackFn)Matchers.eq(this.resolveCallBackMock), (Promise.PromiseExecutorCallbackFn.RejectCallbackFn)Matchers.eq((Object)this.rejectCallbackFnMock));
    }

    @Test
    public void manageContent() {
        this.scenarioSimulationEditorKogitoWrapperSpy.manageContent("path/file.scesim", "value", this.resolveCallbackFnMock, this.rejectCallbackFnMock);
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.never())).showScenarioSimulationCreationPopup((Path)Matchers.any());
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).gotoPath((Path)this.pathArgumentCaptor.capture());
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).unmarshallContent((String)Matchers.eq((Object)"value"));
        Assert.assertEquals((Object)"file.scesim", (Object)((Path)this.pathArgumentCaptor.getValue()).getFileName());
        Assert.assertEquals((Object)"path/", (Object)((Path)this.pathArgumentCaptor.getValue()).toURI());
    }

    @Test
    public void prepareContent() {
        this.scenarioSimulationEditorKogitoWrapperSpy.prepareContent(this.resolveCallBackMock, this.rejectCallbackFnMock);
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).synchronizeColumnsDimension((ScenarioGridPanel)Matchers.eq((Object)this.simulationGridPanelMock), (ScenarioGridPanel)Matchers.eq((Object)this.backgroundGridPanelMock));
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).marshallContent((ScenarioSimulationModel)Matchers.eq((Object)this.scenarioSimulationModelMock), (Promise.PromiseExecutorCallbackFn.ResolveCallbackFn)Matchers.eq(this.resolveCallBackMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.never())).sendNotification((String)Matchers.any(), (NotificationEvent.NotificationType)Matchers.any());
    }

    @Test
    public void prepareContent_Exception() {
        ((ScenarioSimulationEditorKogitoWrapper)BDDMockito.willThrow(Exception.class).given((Object)this.scenarioSimulationEditorKogitoWrapperSpy)).marshallContent((ScenarioSimulationModel)Matchers.any(), (Promise.PromiseExecutorCallbackFn.ResolveCallbackFn)Matchers.any());
        this.scenarioSimulationEditorKogitoWrapperSpy.prepareContent(this.resolveCallBackMock, this.rejectCallbackFnMock);
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).synchronizeColumnsDimension((ScenarioGridPanel)Matchers.eq((Object)this.simulationGridPanelMock), (ScenarioGridPanel)Matchers.eq((Object)this.backgroundGridPanelMock));
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).marshallContent((ScenarioSimulationModel)Matchers.eq((Object)this.scenarioSimulationModelMock), (Promise.PromiseExecutorCallbackFn.ResolveCallbackFn)Matchers.eq(this.resolveCallBackMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).sendNotification(Matchers.anyString(), (NotificationEvent.NotificationType)Matchers.eq((Object)NotificationEvent.NotificationType.ERROR));
    }

    @Test
    public void manageContentFileWithoutPath() {
        this.scenarioSimulationEditorKogitoWrapperSpy.manageContent("file.scesim", "value", this.resolveCallbackFnMock, this.rejectCallbackFnMock);
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.never())).showScenarioSimulationCreationPopup((Path)Matchers.any());
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).gotoPath((Path)this.pathArgumentCaptor.capture());
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).unmarshallContent((String)Matchers.eq((Object)"value"));
        Assert.assertEquals((Object)"file.scesim", (Object)((Path)this.pathArgumentCaptor.getValue()).getFileName());
        Assert.assertEquals((Object)"/", (Object)((Path)this.pathArgumentCaptor.getValue()).toURI());
    }

    @Test
    public void manageContentNullPath() {
        this.scenarioSimulationEditorKogitoWrapperSpy.manageContent("", "value", this.resolveCallbackFnMock, this.rejectCallbackFnMock);
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.never())).showScenarioSimulationCreationPopup((Path)Matchers.any());
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).gotoPath((Path)this.pathArgumentCaptor.capture());
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).unmarshallContent((String)Matchers.eq((Object)"value"));
        Assert.assertEquals((Object)"new-file.scesim", (Object)((Path)this.pathArgumentCaptor.getValue()).getFileName());
        Assert.assertEquals((Object)"/", (Object)((Path)this.pathArgumentCaptor.getValue()).toURI());
    }

    @Test
    public void manageContentNullContentAndPath() {
        this.scenarioSimulationEditorKogitoWrapperSpy.manageContent(null, null, this.resolveCallbackFnMock, this.rejectCallbackFnMock);
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).showScenarioSimulationCreationPopup((Path)this.pathArgumentCaptor.capture());
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.never())).gotoPath((Path)Matchers.any());
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.never())).unmarshallContent((String)Matchers.any());
        Assert.assertEquals((Object)"new-file.scesim", (Object)((Path)this.pathArgumentCaptor.getValue()).getFileName());
        Assert.assertEquals((Object)"/", (Object)((Path)this.pathArgumentCaptor.getValue()).toURI());
    }

    @Test
    public void manageContentNullContent() {
        this.scenarioSimulationEditorKogitoWrapperSpy.manageContent("path/file.scesim", null, this.resolveCallbackFnMock, this.rejectCallbackFnMock);
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).showScenarioSimulationCreationPopup((Path)this.pathArgumentCaptor.capture());
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.never())).gotoPath((Path)Matchers.any());
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.never())).unmarshallContent((String)Matchers.any());
        Assert.assertEquals((Object)"file.scesim", (Object)((Path)this.pathArgumentCaptor.getValue()).getFileName());
        Assert.assertEquals((Object)"path/", (Object)((Path)this.pathArgumentCaptor.getValue()).toURI());
    }

    @Test
    public void manageContentWithPathAndNullContent() {
        this.scenarioSimulationEditorKogitoWrapperSpy.manageContent("path/file.scesim", null, this.resolveCallbackFnMock, this.rejectCallbackFnMock);
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).showScenarioSimulationCreationPopup((Path)this.pathArgumentCaptor.capture());
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.never())).gotoPath((Path)Matchers.any());
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.never())).unmarshallContent((String)Matchers.any());
        Assert.assertEquals((Object)"file.scesim", (Object)((Path)this.pathArgumentCaptor.getValue()).getFileName());
        Assert.assertEquals((Object)"path/", (Object)((Path)this.pathArgumentCaptor.getValue()).toURI());
    }

    @Test
    public void manageContentWithException() {
        ((ScenarioSimulationEditorKogitoWrapper)BDDMockito.willThrow((Throwable)new IllegalStateException("Error message")).given((Object)this.scenarioSimulationEditorKogitoWrapperSpy)).unmarshallContent((String)Matchers.any());
        this.scenarioSimulationEditorKogitoWrapperSpy.manageContent("path/file.scesim", "value", this.resolveCallbackFnMock, this.rejectCallbackFnMock);
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.never())).showScenarioSimulationCreationPopup((Path)Matchers.any());
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).gotoPath((Path)this.pathArgumentCaptor.capture());
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).unmarshallContent((String)Matchers.eq((Object)"value"));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).sendNotification((String)Matchers.eq((Object)"Error message"), (NotificationEvent.NotificationType)Matchers.eq((Object)NotificationEvent.NotificationType.ERROR));
        ((Promise.PromiseExecutorCallbackFn.RejectCallbackFn)Mockito.verify((Object)this.rejectCallbackFnMock, (VerificationMode)Mockito.times((int)1))).onInvoke((Object)"Error message");
    }

    @Test
    public void onEditTabSelected() {
        this.scenarioSimulationEditorKogitoWrapperSpy.onEditTabSelected();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).onEditTabSelected();
    }

    @Test
    public void makeMenuBar() {
        this.scenarioSimulationEditorPresenterMock.makeMenuBar(this.fileMenuBuilderMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).makeMenuBar((FileMenuBuilder)Matchers.eq((Object)this.fileMenuBuilderMock));
    }

    @Test
    public void onStartup() {
        Whitebox.setInternalState((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (String)"multiPageEditorContainerView", (Object)this.multiPageEditorContainerViewMock);
        this.scenarioSimulationEditorKogitoWrapperSpy.onStartup(this.placeRequestMock);
        ((AuthoringEditorDock)Mockito.verify((Object)this.authoringEditorDockMock, (VerificationMode)Mockito.times((int)1))).setup((String)Matchers.eq((Object)"AuthoringPerspective"), (PlaceRequest)Matchers.eq((Object)this.placeRequestMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setWrapper((ScenarioSimulationEditorWrapper)Matchers.eq((Object)this.scenarioSimulationEditorKogitoWrapperSpy));
    }

    @Test
    public void gotoPath() {
        this.scenarioSimulationEditorKogitoWrapperSpy.gotoPath(this.path);
        ((KogitoAsyncPackageDataModelOracle)Mockito.verify((Object)this.kogitoAsyncPackageDataModelOracleMock, (VerificationMode)Mockito.times((int)1))).init((Path)Matchers.eq((Object)this.path));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setPath((ObservablePath)Matchers.isA(ObservablePath.class));
        Assert.assertEquals((Object)this.path, (Object)this.scenarioSimulationEditorKogitoWrapperSpy.getCurrentPath());
    }

    @Test
    public void getJSInteropMarshallCallback() {
        SCESIMMarshallCallback callback = this.scenarioSimulationEditorKogitoWrapperSpy.getJSInteropMarshallCallback(this.resolveCallBackMock);
        callback.callEvent("xmlString");
        ((Promise.PromiseExecutorCallbackFn.ResolveCallbackFn)Mockito.verify(this.resolveCallBackMock, (VerificationMode)Mockito.times((int)1))).onInvoke(Matchers.eq((Object)"xmlString"));
    }

    @Test
    public void getModelSuccessCallbackMethodRule() {
        Mockito.when((Object)this.settingsMock.getType()).thenReturn((Object)ScenarioSimulationModel.Type.RULE);
        Mockito.when((Object)this.scenarioSimulationEditorPresenterMock.getJsonModel((ScenarioSimulationModel)Matchers.eq((Object)this.scenarioSimulationModelMock))).thenReturn((Object)JSON_MODEL);
        this.scenarioSimulationEditorKogitoWrapperSpy.onModelSuccessCallbackMethod(this.scenarioSimulationModelMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setPackageName((String)Matchers.eq((Object)"com"));
        ((BaseKogitoEditor)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).setOriginalContentHash(Integer.valueOf(Matchers.eq((int)JSON_MODEL.hashCode())));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).getModelSuccessCallbackMethod((DataManagementStrategy)this.dataManagementStrategyCaptor.capture(), (ScenarioSimulationModel)Matchers.eq((Object)this.scenarioSimulationModelMock));
        Assert.assertTrue((boolean)(this.dataManagementStrategyCaptor.getValue() instanceof KogitoDMODataManagementStrategy));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).showDocks((PlaceStatus)Matchers.eq((Object)PlaceStatus.CLOSE));
    }

    @Test
    public void getModelSuccessCallbackMethodDMN() {
        Mockito.when((Object)this.settingsMock.getType()).thenReturn((Object)ScenarioSimulationModel.Type.DMN);
        Mockito.when((Object)this.scenarioSimulationEditorPresenterMock.getJsonModel((ScenarioSimulationModel)Matchers.eq((Object)this.scenarioSimulationModelMock))).thenReturn((Object)JSON_MODEL);
        this.scenarioSimulationEditorKogitoWrapperSpy.onModelSuccessCallbackMethod(this.scenarioSimulationModelMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).setPackageName((String)Matchers.eq((Object)"com"));
        ((BaseKogitoEditor)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).setOriginalContentHash(Integer.valueOf(Matchers.eq((int)JSON_MODEL.hashCode())));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).getModelSuccessCallbackMethod((DataManagementStrategy)this.dataManagementStrategyCaptor.capture(), (ScenarioSimulationModel)Matchers.eq((Object)this.scenarioSimulationModelMock));
        Assert.assertTrue((boolean)(this.dataManagementStrategyCaptor.getValue() instanceof KogitoDMNDataManagementStrategy));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).showDocks((PlaceStatus)Matchers.eq((Object)PlaceStatus.CLOSE));
    }

    @Test
    public void addBackgroundPage() {
        this.scenarioSimulationEditorKogitoWrapperSpy.addBackgroundPage(this.scenarioGridWidgetMock);
        ((MultiPageEditorViewImpl)Mockito.verify((Object)this.multiPageEditorViewMock, (VerificationMode)Mockito.times((int)1))).addPage(Matchers.eq((int)2), (Page)this.pageCaptor.capture());
        ((Page)this.pageCaptor.getValue()).onFocus();
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).onBackgroundTabSelected();
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.backgroundTabTitle(), (Object)((Page)this.pageCaptor.getValue()).getLabel());
    }

    @Test
    public void selectSimulationTab() {
        this.scenarioSimulationEditorKogitoWrapperSpy.selectSimulationTab();
        ((TabListItem)Mockito.verify((Object)this.editorItemMock, (VerificationMode)Mockito.times((int)1))).showTab(Matchers.eq((boolean)false));
        ((TabListItem)Mockito.verify((Object)this.backgroundItemMock, (VerificationMode)Mockito.never())).showTab(Matchers.anyBoolean());
    }

    @Test
    public void selectBackGroundTab() {
        this.scenarioSimulationEditorKogitoWrapperSpy.selectBackgroundTab();
        ((TabListItem)Mockito.verify((Object)this.backgroundItemMock, (VerificationMode)Mockito.times((int)1))).showTab(Matchers.eq((boolean)false));
        ((TabListItem)Mockito.verify((Object)this.editorItemMock, (VerificationMode)Mockito.never())).showTab(Matchers.anyBoolean());
    }

    @Test
    public void onBackgroundTabSelected() {
        this.scenarioSimulationEditorKogitoWrapperSpy.onBackgroundTabSelected();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).onBackgroundTabSelected();
    }

    @Test
    public void showScenarioSimulationCreationPopup() {
        this.scenarioSimulationEditorKogitoWrapperSpy.showScenarioSimulationCreationPopup(this.path);
        ((ScenarioSimulationKogitoCreationPopupPresenter)Mockito.verify((Object)this.scenarioSimulationKogitoCreationPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.addScenarioSimulation()), (Command)Matchers.isA(Command.class));
    }

    @Test
    public void newFileEmptySelectedType() {
        Command command = this.scenarioSimulationEditorKogitoWrapperSpy.createNewFileCommand(this.path);
        command.execute();
        ((ScenarioSimulationKogitoCreationPopupPresenter)Mockito.verify((Object)this.scenarioSimulationKogitoCreationPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).getSelectedType();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).sendNotification((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.missingSelectedType()), (NotificationEvent.NotificationType)Matchers.eq((Object)NotificationEvent.NotificationType.ERROR));
        ((KogitoScenarioSimulationBuilder)Mockito.verify((Object)this.kogitoScenarioSimulationBuilderMock, (VerificationMode)Mockito.never())).populateScenarioSimulationModel((ScenarioSimulationModel)Matchers.any(), (ScenarioSimulationModel.Type)Matchers.any(), (String)Matchers.any(), (RemoteCallback)Matchers.any());
    }

    @Test
    public void newFileEmptySelectedDMNPath() {
        Mockito.when((Object)this.scenarioSimulationKogitoCreationPopupPresenterMock.getSelectedPath()).thenReturn(null);
        Mockito.when((Object)this.scenarioSimulationKogitoCreationPopupPresenterMock.getSelectedType()).thenReturn((Object)ScenarioSimulationModel.Type.DMN);
        Command command = this.scenarioSimulationEditorKogitoWrapperSpy.createNewFileCommand(this.path);
        command.execute();
        ((ScenarioSimulationKogitoCreationPopupPresenter)Mockito.verify((Object)this.scenarioSimulationKogitoCreationPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).getSelectedType();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).sendNotification((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.missingDmnPath()), (NotificationEvent.NotificationType)Matchers.eq((Object)NotificationEvent.NotificationType.ERROR));
        ((KogitoScenarioSimulationBuilder)Mockito.verify((Object)this.kogitoScenarioSimulationBuilderMock, (VerificationMode)Mockito.never())).populateScenarioSimulationModel((ScenarioSimulationModel)Matchers.any(), (ScenarioSimulationModel.Type)Matchers.any(), (String)Matchers.any(), (RemoteCallback)Matchers.any());
    }

    @Test
    public void newFileRule() {
        Mockito.when((Object)this.scenarioSimulationKogitoCreationPopupPresenterMock.getSelectedType()).thenReturn((Object)ScenarioSimulationModel.Type.RULE);
        Command command = this.scenarioSimulationEditorKogitoWrapperSpy.createNewFileCommand(this.path);
        command.execute();
        ((ScenarioSimulationKogitoCreationPopupPresenter)Mockito.verify((Object)this.scenarioSimulationKogitoCreationPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).getSelectedType();
        ((KogitoScenarioSimulationBuilder)Mockito.verify((Object)this.kogitoScenarioSimulationBuilderMock, (VerificationMode)Mockito.times((int)1))).populateScenarioSimulationModel((ScenarioSimulationModel)Matchers.isA(ScenarioSimulationModel.class), (ScenarioSimulationModel.Type)Matchers.eq((Object)ScenarioSimulationModel.Type.RULE), (String)Matchers.eq((Object)""), (RemoteCallback)this.remoteCallbackArgumentCaptor.capture());
        ((RemoteCallback)this.remoteCallbackArgumentCaptor.getValue()).callback((Object)"");
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).gotoPath((Path)Matchers.eq((Object)this.path));
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).unmarshallContent((String)Matchers.isA(String.class));
    }

    @Test
    public void newFileDMN() {
        Mockito.when((Object)this.scenarioSimulationKogitoCreationPopupPresenterMock.getSelectedType()).thenReturn((Object)ScenarioSimulationModel.Type.DMN);
        Command command = this.scenarioSimulationEditorKogitoWrapperSpy.createNewFileCommand(this.path);
        command.execute();
        ((ScenarioSimulationKogitoCreationPopupPresenter)Mockito.verify((Object)this.scenarioSimulationKogitoCreationPopupPresenterMock, (VerificationMode)Mockito.times((int)1))).getSelectedType();
        ((KogitoScenarioSimulationBuilder)Mockito.verify((Object)this.kogitoScenarioSimulationBuilderMock, (VerificationMode)Mockito.times((int)1))).populateScenarioSimulationModel((ScenarioSimulationModel)Matchers.isA(ScenarioSimulationModel.class), (ScenarioSimulationModel.Type)Matchers.eq((Object)ScenarioSimulationModel.Type.DMN), (String)Matchers.eq((Object)"selected"), (RemoteCallback)this.remoteCallbackArgumentCaptor.capture());
        ((RemoteCallback)this.remoteCallbackArgumentCaptor.getValue()).callback((Object)"");
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).gotoPath((Path)Matchers.eq((Object)this.path));
        ((ScenarioSimulationEditorKogitoWrapper)Mockito.verify((Object)this.scenarioSimulationEditorKogitoWrapperSpy, (VerificationMode)Mockito.times((int)1))).unmarshallContent((String)Matchers.isA(String.class));
    }

    @Test
    public void getScenarioSimulationDocksHandler() {
        Assert.assertEquals((Object)this.scenarioSimulationKogitoDocksHandlerMock, (Object)this.scenarioSimulationEditorKogitoWrapperSpy.getScenarioSimulationDocksHandler());
    }

    @Test
    public void getScenarioSimulationEditorPresenter() {
        Assert.assertEquals((Object)this.scenarioSimulationEditorPresenterMock, (Object)this.scenarioSimulationEditorKogitoWrapperSpy.getScenarioSimulationEditorPresenter());
    }
}

