/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.kogito.client.docks;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.workbench.screens.scenariosimulation.kogito.client.docks.KogitoEditorDock;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.docks.AbstractWorkbenchDocksHandler;
import org.kie.workbench.common.widgets.client.docks.WorkbenchDocksHandler;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class KogitoEditorDockTest {
    public static final String AUTHORING_PERSPECTIVE = "authoring";
    @Mock
    private UberfireDocks uberfireDocks;
    @Mock
    private PlaceRequest placeRequest;
    @Mock
    private ManagedInstance<WorkbenchDocksHandler> handlers;
    private KogitoEditorDock kogitoEditorDockSpy;
    private TestWorkbenchDocksHandler handler;

    @Before
    public void setup() {
        this.handler = (TestWorkbenchDocksHandler)((Object)Mockito.spy((Object)((Object)this.createNewWorkbenchDocksHandler())));
        ArrayList<TestWorkbenchDocksHandler> list = new ArrayList<TestWorkbenchDocksHandler>();
        list.add(this.handler);
        Mockito.when((Object)this.handlers.iterator()).thenReturn(list.iterator());
        this.kogitoEditorDockSpy = (KogitoEditorDock)Mockito.spy((Object)new KogitoEditorDock(this.uberfireDocks, this.handlers));
        this.kogitoEditorDockSpy.initialize();
        ((ManagedInstance)Mockito.verify(this.handlers)).iterator();
        ((TestWorkbenchDocksHandler)((Object)Mockito.verify((Object)((Object)this.handler), (VerificationMode)Mockito.times((int)1)))).init((Command)Matchers.isA(Command.class));
        Assert.assertFalse((boolean)this.kogitoEditorDockSpy.isSetup());
        this.kogitoEditorDockSpy.setup(AUTHORING_PERSPECTIVE, this.placeRequest);
        Assert.assertTrue((boolean)this.kogitoEditorDockSpy.isSetup());
    }

    @Test
    public void expandAuthoringDockEmpty() {
        this.kogitoEditorDockSpy.expandAuthoringDock(null);
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.times((int)1))).show((UberfireDockPosition)Matchers.eq((Object)UberfireDockPosition.EAST), (String)Matchers.eq((Object)AUTHORING_PERSPECTIVE));
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.never())).open((UberfireDock)Matchers.any());
    }

    @Test
    public void expandAuthoringDock() {
        UberfireDock dockToOpen = (UberfireDock)Mockito.mock(UberfireDock.class);
        this.kogitoEditorDockSpy.expandAuthoringDock(dockToOpen);
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.times((int)1))).show((UberfireDockPosition)Matchers.eq((Object)UberfireDockPosition.EAST), (String)Matchers.eq((Object)AUTHORING_PERSPECTIVE));
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.times((int)1))).open((UberfireDock)Matchers.eq((Object)dockToOpen));
    }

    @Test
    public void setActiveHandler() {
        this.kogitoEditorDockSpy.setActiveHandler((WorkbenchDocksHandler)this.handler);
        Assert.assertSame((Object)this.kogitoEditorDockSpy.activeHandler, (Object)((Object)this.handler));
        ((TestWorkbenchDocksHandler)((Object)Mockito.verify((Object)((Object)this.handler), (VerificationMode)Mockito.times((int)1)))).provideDocks((String)Matchers.eq((Object)AUTHORING_PERSPECTIVE));
        Assert.assertTrue((this.kogitoEditorDockSpy.activeDocks.length == 2 ? 1 : 0) != 0);
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.never())).remove((UberfireDock[])Matchers.any());
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.times((int)1))).add(new UberfireDock[]{(UberfireDock)Matchers.isA(UberfireDock.class), (UberfireDock)Matchers.isA(UberfireDock.class)});
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.times((int)1))).show((UberfireDockPosition)Matchers.eq((Object)UberfireDockPosition.EAST), (String)Matchers.eq((Object)AUTHORING_PERSPECTIVE));
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.never())).hide((UberfireDockPosition)Matchers.any(), (String)Matchers.any());
    }

    @Test
    public void setActiveHandlerWithSameActiveHandlerToRefresh() {
        this.kogitoEditorDockSpy.activeHandler = this.handler;
        this.handler.refresh(true, false);
        this.kogitoEditorDockSpy.setActiveHandler((WorkbenchDocksHandler)this.handler);
        Assert.assertSame((Object)this.kogitoEditorDockSpy.activeHandler, (Object)((Object)this.handler));
        ((TestWorkbenchDocksHandler)((Object)Mockito.verify((Object)((Object)this.handler), (VerificationMode)Mockito.atLeastOnce()))).provideDocks((String)Matchers.eq((Object)AUTHORING_PERSPECTIVE));
        Assert.assertTrue((this.kogitoEditorDockSpy.activeDocks.length == 2 ? 1 : 0) != 0);
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.never())).remove((UberfireDock[])Matchers.any());
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.atLeastOnce())).add(new UberfireDock[]{(UberfireDock)Matchers.isA(UberfireDock.class), (UberfireDock)Matchers.isA(UberfireDock.class)});
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.atLeastOnce())).show((UberfireDockPosition)Matchers.eq((Object)UberfireDockPosition.EAST), (String)Matchers.eq((Object)AUTHORING_PERSPECTIVE));
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.never())).hide((UberfireDockPosition)Matchers.any(), (String)Matchers.any());
    }

    @Test
    public void setActiveHandlerWithSameActiveHandlerToNotRefresh() {
        this.kogitoEditorDockSpy.activeHandler = this.handler;
        this.handler.refresh(false, false);
        this.kogitoEditorDockSpy.setActiveHandler((WorkbenchDocksHandler)this.handler);
        ((TestWorkbenchDocksHandler)((Object)Mockito.verify((Object)((Object)this.handler), (VerificationMode)Mockito.never()))).provideDocks((String)Matchers.any());
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.never())).remove((UberfireDock[])Matchers.any());
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.never())).add((UberfireDock[])Matchers.any());
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.never())).show((UberfireDockPosition)Matchers.any(), (String)Matchers.any());
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.never())).hide((UberfireDockPosition)Matchers.any(), (String)Matchers.any());
    }

    @Test
    public void setActiveHandlerWithActiveDock() {
        UberfireDock activeDock = (UberfireDock)Mockito.mock(UberfireDock.class);
        UberfireDock[] activeDocks = new UberfireDock[]{activeDock};
        this.kogitoEditorDockSpy.activeDocks = activeDocks;
        this.kogitoEditorDockSpy.setActiveHandler((WorkbenchDocksHandler)this.handler);
        Assert.assertSame((Object)this.kogitoEditorDockSpy.activeHandler, (Object)((Object)this.handler));
        ((TestWorkbenchDocksHandler)((Object)Mockito.verify((Object)((Object)this.handler), (VerificationMode)Mockito.atLeastOnce()))).provideDocks((String)Matchers.eq((Object)AUTHORING_PERSPECTIVE));
        Assert.assertTrue((this.kogitoEditorDockSpy.activeDocks.length == 2 ? 1 : 0) != 0);
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.times((int)1))).remove(new UberfireDock[]{(UberfireDock)Matchers.eq((Object)activeDock)});
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.times((int)1))).add(new UberfireDock[]{(UberfireDock)Matchers.isA(UberfireDock.class), (UberfireDock)Matchers.isA(UberfireDock.class)});
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.times((int)1))).show((UberfireDockPosition)Matchers.eq((Object)UberfireDockPosition.EAST), (String)Matchers.eq((Object)AUTHORING_PERSPECTIVE));
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.never())).hide((UberfireDockPosition)Matchers.any(), (String)Matchers.any());
    }

    @Test
    public void setActiveHandlerShouldDisableDock() {
        this.handler.refresh(false, true);
        this.kogitoEditorDockSpy.setActiveHandler((WorkbenchDocksHandler)this.handler);
        Assert.assertSame((Object)this.kogitoEditorDockSpy.activeHandler, (Object)((Object)this.handler));
        ((TestWorkbenchDocksHandler)((Object)Mockito.verify((Object)((Object)this.handler), (VerificationMode)Mockito.never()))).provideDocks((String)Matchers.any());
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.never())).add(new UberfireDock[]{(UberfireDock)Matchers.any(), (UberfireDock)Matchers.any()});
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.never())).show((UberfireDockPosition)Matchers.any(), (String)Matchers.any());
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.times((int)1))).hide((UberfireDockPosition)Matchers.eq((Object)UberfireDockPosition.EAST), (String)Matchers.eq((Object)AUTHORING_PERSPECTIVE));
    }

    private TestWorkbenchDocksHandler createNewWorkbenchDocksHandler() {
        ArrayList<UberfireDock> docks = new ArrayList<UberfireDock>();
        docks.add(new UberfireDock(UberfireDockPosition.EAST, "RANDOM", this.placeRequest, AUTHORING_PERSPECTIVE));
        docks.add(new UberfireDock(UberfireDockPosition.EAST, "RANDOM", this.placeRequest, AUTHORING_PERSPECTIVE));
        return new TestWorkbenchDocksHandler(docks);
    }

    public class TestWorkbenchDocksHandler
    extends AbstractWorkbenchDocksHandler {
        private List<UberfireDock> docks;

        public TestWorkbenchDocksHandler(List<UberfireDock> docks) {
            this.docks = docks;
        }

        public Collection<UberfireDock> provideDocks(String perspectiveIdentifier) {
            return this.docks;
        }

        public void refresh(boolean shouldRefresh, boolean shouldDisable) {
            this.refreshDocks(shouldRefresh, shouldDisable);
        }
    }
}

