/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.kogito.client.dmn;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValueType;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.kogito.client.dmn.KogitoScenarioSimulationBuilder;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class KogitoScenarioSimulationBuilderTest {
    public KogitoScenarioSimulationBuilder kogitoScenarioSimulationBuilderSpy;

    @Before
    public void setup() {
        this.kogitoScenarioSimulationBuilderSpy = (KogitoScenarioSimulationBuilder)Mockito.spy((Object)new KogitoScenarioSimulationBuilder());
    }

    @Test
    public void createRULESimulation() {
        Simulation simulation = this.kogitoScenarioSimulationBuilderSpy.createRULESimulation();
        Assert.assertNotNull((Object)simulation);
        Assert.assertEquals((long)1L, (long)simulation.getScenarioWithIndex().size());
        ScesimModelDescriptor modelDescriptor = simulation.getScesimModelDescriptor();
        Assert.assertNotNull((Object)modelDescriptor);
        Assert.assertEquals((long)4L, (long)modelDescriptor.getFactMappings().size());
        Assert.assertEquals((double)70.0, (double)modelDescriptor.getFactMappingByIndex(0).getColumnWidth(), (double)0.0);
        Assert.assertEquals((Object)FactIdentifier.INDEX.getName(), (Object)modelDescriptor.getFactMappingByIndex(0).getFactAlias());
        Assert.assertEquals((Object)FactIdentifier.INDEX, (Object)modelDescriptor.getFactMappingByIndex(0).getFactIdentifier());
        Assert.assertEquals((Object)ExpressionIdentifier.INDEX, (Object)modelDescriptor.getFactMappingByIndex(0).getExpressionIdentifier());
        Assert.assertEquals((double)300.0, (double)modelDescriptor.getFactMappingByIndex(1).getColumnWidth(), (double)0.0);
        Assert.assertEquals((Object)FactIdentifier.DESCRIPTION.getName(), (Object)modelDescriptor.getFactMappingByIndex(1).getFactAlias());
        Assert.assertEquals((Object)FactIdentifier.DESCRIPTION, (Object)modelDescriptor.getFactMappingByIndex(1).getFactIdentifier());
        Assert.assertEquals((Object)ExpressionIdentifier.DESCRIPTION, (Object)modelDescriptor.getFactMappingByIndex(1).getExpressionIdentifier());
        Assert.assertEquals((Object)FactMappingValueType.NOT_EXPRESSION, (Object)modelDescriptor.getFactMappingByIndex(1).getFactMappingValueType());
        Assert.assertEquals((double)114.0, (double)modelDescriptor.getFactMappingByIndex(2).getColumnWidth(), (double)0.0);
        Assert.assertEquals((Object)"INSTANCE 1", (Object)modelDescriptor.getFactMappingByIndex(2).getFactAlias());
        Assert.assertEquals((Object)FactIdentifier.EMPTY, (Object)modelDescriptor.getFactMappingByIndex(2).getFactIdentifier());
        Assert.assertEquals((Object)ExpressionIdentifier.create((String)"1|1", (FactMappingType)FactMappingType.GIVEN), (Object)modelDescriptor.getFactMappingByIndex(2).getExpressionIdentifier());
        Assert.assertEquals((Object)FactMappingValueType.NOT_EXPRESSION, (Object)modelDescriptor.getFactMappingByIndex(2).getFactMappingValueType());
        Assert.assertEquals((double)114.0, (double)modelDescriptor.getFactMappingByIndex(3).getColumnWidth(), (double)0.0);
        Assert.assertEquals((Object)"INSTANCE 2", (Object)modelDescriptor.getFactMappingByIndex(3).getFactAlias());
        Assert.assertEquals((Object)FactIdentifier.EMPTY, (Object)modelDescriptor.getFactMappingByIndex(3).getFactIdentifier());
        Assert.assertEquals((Object)ExpressionIdentifier.create((String)"1|2", (FactMappingType)FactMappingType.EXPECT), (Object)modelDescriptor.getFactMappingByIndex(3).getExpressionIdentifier());
        Assert.assertEquals((Object)FactMappingValueType.NOT_EXPRESSION, (Object)modelDescriptor.getFactMappingByIndex(3).getFactMappingValueType());
    }

    @Test
    public void createDMNSimulationEmptyFactModuleTuple() {
        FactModelTuple factMappingTuple = new FactModelTuple(Collections.emptySortedMap(), Collections.emptySortedMap());
        Simulation simulation = this.kogitoScenarioSimulationBuilderSpy.createDMNSimulation(factMappingTuple);
        Assert.assertNotNull((Object)simulation);
        Assert.assertEquals((long)1L, (long)simulation.getScenarioWithIndex().size());
        ScesimModelDescriptor modelDescriptor = simulation.getScesimModelDescriptor();
        Assert.assertNotNull((Object)modelDescriptor);
        Assert.assertEquals((long)4L, (long)modelDescriptor.getFactMappings().size());
        Assert.assertEquals((double)70.0, (double)modelDescriptor.getFactMappingByIndex(0).getColumnWidth(), (double)0.0);
        Assert.assertEquals((Object)FactIdentifier.INDEX.getName(), (Object)modelDescriptor.getFactMappingByIndex(0).getFactAlias());
        Assert.assertEquals((Object)FactIdentifier.INDEX, (Object)modelDescriptor.getFactMappingByIndex(0).getFactIdentifier());
        Assert.assertEquals((Object)ExpressionIdentifier.INDEX, (Object)modelDescriptor.getFactMappingByIndex(0).getExpressionIdentifier());
        Assert.assertEquals((Object)FactMappingValueType.NOT_EXPRESSION, (Object)modelDescriptor.getFactMappingByIndex(0).getFactMappingValueType());
        Assert.assertEquals((double)300.0, (double)modelDescriptor.getFactMappingByIndex(1).getColumnWidth(), (double)0.0);
        Assert.assertEquals((Object)FactIdentifier.DESCRIPTION.getName(), (Object)modelDescriptor.getFactMappingByIndex(1).getFactAlias());
        Assert.assertEquals((Object)FactIdentifier.DESCRIPTION, (Object)modelDescriptor.getFactMappingByIndex(1).getFactIdentifier());
        Assert.assertEquals((Object)ExpressionIdentifier.DESCRIPTION, (Object)modelDescriptor.getFactMappingByIndex(1).getExpressionIdentifier());
        Assert.assertEquals((Object)FactMappingValueType.NOT_EXPRESSION, (Object)modelDescriptor.getFactMappingByIndex(1).getFactMappingValueType());
        Assert.assertEquals((double)114.0, (double)modelDescriptor.getFactMappingByIndex(2).getColumnWidth(), (double)0.0);
        Assert.assertEquals((Object)"INSTANCE 1", (Object)modelDescriptor.getFactMappingByIndex(2).getFactAlias());
        Assert.assertEquals((Object)FactIdentifier.EMPTY, (Object)modelDescriptor.getFactMappingByIndex(2).getFactIdentifier());
        Assert.assertEquals((Object)ExpressionIdentifier.create((String)"1|1", (FactMappingType)FactMappingType.GIVEN), (Object)modelDescriptor.getFactMappingByIndex(2).getExpressionIdentifier());
        Assert.assertEquals((Object)FactMappingValueType.NOT_EXPRESSION, (Object)modelDescriptor.getFactMappingByIndex(2).getFactMappingValueType());
        Assert.assertEquals((double)114.0, (double)modelDescriptor.getFactMappingByIndex(3).getColumnWidth(), (double)0.0);
        Assert.assertEquals((Object)"INSTANCE 2", (Object)modelDescriptor.getFactMappingByIndex(3).getFactAlias());
        Assert.assertEquals((Object)FactIdentifier.EMPTY, (Object)modelDescriptor.getFactMappingByIndex(3).getFactIdentifier());
        Assert.assertEquals((Object)ExpressionIdentifier.create((String)"1|2", (FactMappingType)FactMappingType.EXPECT), (Object)modelDescriptor.getFactMappingByIndex(3).getExpressionIdentifier());
        Assert.assertEquals((Object)FactMappingValueType.NOT_EXPRESSION, (Object)modelDescriptor.getFactMappingByIndex(3).getFactMappingValueType());
    }

    @Test
    public void getColumn() {
        Assert.assertEquals((double)70.0, (double)KogitoScenarioSimulationBuilder.getColumnWidth((String)ExpressionIdentifier.NAME.Index.toString()), (double)0.0);
        Assert.assertEquals((double)300.0, (double)KogitoScenarioSimulationBuilder.getColumnWidth((String)ExpressionIdentifier.NAME.Description.toString()), (double)0.0);
        Assert.assertEquals((double)114.0, (double)KogitoScenarioSimulationBuilder.getColumnWidth((String)ExpressionIdentifier.NAME.Other.toString()), (double)0.0);
        Assert.assertEquals((double)114.0, (double)KogitoScenarioSimulationBuilder.getColumnWidth((String)ExpressionIdentifier.NAME.Expected.toString()), (double)0.0);
        Assert.assertEquals((double)114.0, (double)KogitoScenarioSimulationBuilder.getColumnWidth((String)ExpressionIdentifier.NAME.Given.toString()), (double)0.0);
        Assert.assertEquals((double)114.0, (double)KogitoScenarioSimulationBuilder.getColumnWidth((String)"test"), (double)0.0);
    }

    @Test
    public void addToScenarioRecursive() {
        FactMapping factMappingMock = (FactMapping)Mockito.mock(FactMapping.class);
        KogitoScenarioSimulationBuilder.FactMappingExtractor factMappingExtractorMock = (KogitoScenarioSimulationBuilder.FactMappingExtractor)Mockito.mock(KogitoScenarioSimulationBuilder.FactMappingExtractor.class);
        Mockito.when((Object)factMappingExtractorMock.getFactMapping((FactModelTree)Matchers.any(), Matchers.anyString(), (List)Matchers.any(), Matchers.anyString())).thenReturn((Object)factMappingMock);
        HashMap<String, FactModelTree> hiddenFacts = new HashMap<String, FactModelTree>();
        FactModelTree factModelTree = new FactModelTree("myFact", "", new HashMap(), Collections.emptyMap());
        factModelTree.addExpandableProperty("recursiveProperty", "recursive");
        String propertyType = String.class.getCanonicalName();
        String propertyName = "simpleProperty";
        factModelTree.addSimpleProperty(propertyName, propertyType);
        hiddenFacts.put("recursive", factModelTree);
        this.kogitoScenarioSimulationBuilderSpy.addFactMapping(factMappingExtractorMock, factModelTree, new ArrayList(), hiddenFacts);
        ((KogitoScenarioSimulationBuilder.FactMappingExtractor)Mockito.verify((Object)factMappingExtractorMock, (VerificationMode)Mockito.times((int)1))).getFactMapping((FactModelTree)Matchers.eq((Object)factModelTree), (String)Matchers.eq((Object)propertyName), (List)Matchers.eq(Arrays.asList("myFact", "recursiveProperty")), (String)Matchers.eq((Object)propertyType));
        ((KogitoScenarioSimulationBuilder.FactMappingExtractor)Mockito.verify((Object)factMappingExtractorMock, (VerificationMode)Mockito.times((int)2))).getFactMapping((FactModelTree)Matchers.any(), (String)Matchers.any(), (List)Matchers.any(), (String)Matchers.any());
    }

    @Test
    public void addToScenarioMultipleNested() {
        FactMapping factMappingMock = (FactMapping)Mockito.mock(FactMapping.class);
        KogitoScenarioSimulationBuilder.FactMappingExtractor factMappingExtractorMock = (KogitoScenarioSimulationBuilder.FactMappingExtractor)Mockito.mock(KogitoScenarioSimulationBuilder.FactMappingExtractor.class);
        Mockito.when((Object)factMappingExtractorMock.getFactMapping((FactModelTree)Matchers.any(), Matchers.anyString(), (List)Matchers.any(), Matchers.anyString())).thenReturn((Object)factMappingMock);
        HashMap<String, FactModelTree> hiddenFacts = new HashMap<String, FactModelTree>();
        FactModelTree factModelTree = new FactModelTree("myFact", "", new HashMap(), Collections.emptyMap());
        factModelTree.addExpandableProperty("nestedProperty", "tNested");
        factModelTree.addExpandableProperty("nestedProperty2", "tNested2");
        FactModelTree nested1 = new FactModelTree("tNested1", "", new HashMap(), Collections.emptyMap());
        FactModelTree nested2 = new FactModelTree("tNested2", "", new HashMap(), Collections.emptyMap());
        String propertyType = String.class.getCanonicalName();
        String propertyName = "stingProperty";
        nested1.addSimpleProperty(propertyName, propertyType);
        String propertyType2 = Boolean.class.getCanonicalName();
        String propertyName2 = "booleanProperty";
        nested2.addSimpleProperty(propertyName2, propertyType2);
        hiddenFacts.put("tNested", nested1);
        hiddenFacts.put("tNested2", nested2);
        this.kogitoScenarioSimulationBuilderSpy.addFactMapping(factMappingExtractorMock, factModelTree, new ArrayList(), hiddenFacts);
        ((KogitoScenarioSimulationBuilder.FactMappingExtractor)Mockito.verify((Object)factMappingExtractorMock, (VerificationMode)Mockito.times((int)1))).getFactMapping((FactModelTree)Matchers.eq((Object)nested1), (String)Matchers.eq((Object)propertyName), (List)Matchers.eq(Arrays.asList("myFact", "nestedProperty")), (String)Matchers.eq((Object)propertyType));
        ((KogitoScenarioSimulationBuilder.FactMappingExtractor)Mockito.verify((Object)factMappingExtractorMock, (VerificationMode)Mockito.times((int)1))).getFactMapping((FactModelTree)Matchers.eq((Object)nested2), (String)Matchers.eq((Object)propertyName2), (List)Matchers.eq(Arrays.asList("myFact", "nestedProperty2")), (String)Matchers.eq((Object)propertyType2));
        ((KogitoScenarioSimulationBuilder.FactMappingExtractor)Mockito.verify((Object)factMappingExtractorMock, (VerificationMode)Mockito.times((int)2))).getFactMapping((FactModelTree)Matchers.any(), (String)Matchers.any(), (List)Matchers.any(), (String)Matchers.any());
    }
}

