/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.kogito.client.dmn;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.drools.workbench.screens.scenariosimulation.kogito.client.dmn.AbstractKogitoDMNService;
import org.drools.workbench.screens.scenariosimulation.kogito.client.dmn.ClientDMNType;
import org.drools.workbench.screens.scenariosimulation.kogito.client.dmn.feel.BuiltInType;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecision;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInformationItem;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInputData;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITItemDefinition;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;

@RunWith(value=GwtMockitoTestRunner.class)
public class AbstractKogitoDMNServiceTest {
    public static final String NAMESPACE = "namespace";
    public static final String TYPE_NAME = "name";
    public static final String ID = "id";
    @Mock
    private JSITItemDefinition jsitItemDefinitionMock;
    @Mock
    private JSITItemDefinition jsitItemDefinitionNestedMock;
    @Mock
    private JSITDefinitions jsiITDefinitionsMock;
    @Mock
    private JSITDecision jsiITDecisionMock;
    @Mock
    private JSITInputData jsiITInputDataMock;
    @Mock
    private JSITInformationItem jsiITInformationItemInputMock;
    @Mock
    private JSITInformationItem jsiITInformationItemDecisionMock;
    private AbstractKogitoDMNService abstractKogitoDMNServiceSpy;
    private List<JSITItemDefinition> jstiItemDefinitions;
    private List<JSITDRGElement> jsitdrgElements;
    private List<JSITDRGElement> drgElements;
    private Map<QName, String> attributesMapInput;
    private Map<QName, String> attributesMapDecision;
    private Map<String, JSITItemDefinition> allDefinitions;

    @Before
    public void setup() {
        this.jstiItemDefinitions = new ArrayList<JSITItemDefinition>();
        this.jsitdrgElements = new ArrayList<JSITDRGElement>();
        this.drgElements = new ArrayList<JSITDRGElement>();
        this.attributesMapInput = new HashMap<QName, String>();
        this.attributesMapDecision = new HashMap<QName, String>();
        this.allDefinitions = new HashMap<String, JSITItemDefinition>();
        this.abstractKogitoDMNServiceSpy = (AbstractKogitoDMNService)Mockito.spy((Object)new AbstractKogitoDMNService(){

            public void getDMNContent(Path path, RemoteCallback<String> remoteCallback, ErrorCallback<Object> errorCallback) {
            }
        });
        ((AbstractKogitoDMNService)Mockito.doReturn((Object)true).when((Object)this.abstractKogitoDMNServiceSpy)).isJSITInputData((JSITDRGElement)Matchers.eq((Object)this.jsiITInputDataMock));
        ((AbstractKogitoDMNService)Mockito.doReturn((Object)true).when((Object)this.abstractKogitoDMNServiceSpy)).isJSITDecision((JSITDRGElement)Matchers.eq((Object)this.jsiITDecisionMock));
        ((AbstractKogitoDMNService)Mockito.doReturn(this.attributesMapInput).when((Object)this.abstractKogitoDMNServiceSpy)).getOtherAttributesMap((JSITDMNElement)Matchers.eq((Object)this.jsiITInformationItemInputMock));
        ((AbstractKogitoDMNService)Mockito.doReturn(this.attributesMapDecision).when((Object)this.abstractKogitoDMNServiceSpy)).getOtherAttributesMap((JSITDMNElement)Matchers.eq((Object)this.jsiITInformationItemDecisionMock));
        Mockito.when((Object)this.jsiITDefinitionsMock.getNamespace()).thenReturn((Object)NAMESPACE);
        Mockito.when((Object)this.jsiITDefinitionsMock.getItemDefinition()).thenReturn(this.jstiItemDefinitions);
        Mockito.when((Object)this.jsiITDefinitionsMock.getDrgElement()).thenReturn(this.jsitdrgElements);
        Mockito.when((Object)this.jsiITInputDataMock.getVariable()).thenReturn((Object)this.jsiITInformationItemInputMock);
        Mockito.when((Object)this.jsiITDecisionMock.getVariable()).thenReturn((Object)this.jsiITInformationItemDecisionMock);
        Mockito.when((Object)this.jsitItemDefinitionMock.getName()).thenReturn((Object)TYPE_NAME);
        Mockito.when((Object)this.jsitItemDefinitionMock.getId()).thenReturn((Object)ID);
        Mockito.when((Object)this.jsitItemDefinitionMock.getIsCollection()).thenReturn((Object)false);
    }

    @Test
    public void getDMNTypeFromMaps() {
        Map dmnTypesMap = this.abstractKogitoDMNServiceSpy.getDMNDataTypesMap(this.jstiItemDefinitions, NAMESPACE);
        this.attributesMapInput.put(AbstractKogitoDMNService.TYPEREF_QNAME, "number");
        ClientDMNType clientDMNType = this.abstractKogitoDMNServiceSpy.getDMNTypeFromMaps(dmnTypesMap, this.attributesMapInput);
        TestCase.assertNotNull((Object)clientDMNType);
        Assert.assertTrue((boolean)BuiltInType.NUMBER.equals((Object)clientDMNType.getFeelType()));
    }

    @Test
    public void getDMNTypeFromMaps_NullTypeRef() {
        Map dmnTypesMap = this.abstractKogitoDMNServiceSpy.getDMNDataTypesMap(this.jstiItemDefinitions, NAMESPACE);
        this.attributesMapInput.put(AbstractKogitoDMNService.TYPEREF_QNAME, null);
        ClientDMNType clientDMNType = this.abstractKogitoDMNServiceSpy.getDMNTypeFromMaps(dmnTypesMap, this.attributesMapInput);
        TestCase.assertNotNull((Object)clientDMNType);
        Assert.assertTrue((boolean)BuiltInType.ANY.equals((Object)clientDMNType.getFeelType()));
    }

    @Test
    public void testIndexDefinitionsByName() {
        JSITItemDefinition definition1 = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        JSITItemDefinition definition2 = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        JSITItemDefinition definition3 = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        String name1 = "name1";
        String name2 = "name2";
        String name3 = "name3";
        List<JSITItemDefinition> list = Arrays.asList(definition1, definition2, definition3);
        Mockito.when((Object)definition1.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)definition2.getName()).thenReturn((Object)"name2");
        Mockito.when((Object)definition3.getName()).thenReturn((Object)"name3");
        Map index = this.abstractKogitoDMNServiceSpy.indexDefinitionsByName(list);
        Assert.assertEquals((long)3L, (long)index.size());
        Assert.assertTrue((boolean)index.containsKey("name1"));
        Assert.assertTrue((boolean)index.containsKey("name2"));
        Assert.assertTrue((boolean)index.containsKey("name3"));
        Assert.assertEquals((Object)definition1, index.get("name1"));
        Assert.assertEquals((Object)definition2, index.get("name2"));
        Assert.assertEquals((Object)definition3, index.get("name3"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testIndexDefinitionsUnmodifiable() {
        JSITItemDefinition definition1 = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        String name1 = "name1";
        List<JSITItemDefinition> list = Arrays.asList(definition1);
        Mockito.when((Object)definition1.getName()).thenReturn((Object)"name1");
        Map index = this.abstractKogitoDMNServiceSpy.indexDefinitionsByName(list);
        index.put("name2", Mockito.mock(JSITItemDefinition.class));
    }

    @Test
    public void testGetOrCreateDMNType() {
        String namespace = NAMESPACE;
        String typeOneName = "tTypeOne";
        String typeTwoName = "tTypeTwo";
        String typeThreeName = "tTypeThree";
        JSITItemDefinition definition1 = this.createJSITItemDefinitionMock("tTypeOne");
        JSITItemDefinition definition2 = this.createJSITItemDefinitionMock("tTypeTwo");
        JSITItemDefinition definition3 = this.createJSITItemDefinitionMock("tTypeThree");
        Map indexed = this.abstractKogitoDMNServiceSpy.indexDefinitionsByName(Arrays.asList(definition1, definition2, definition3));
        HashMap createdTypes = new HashMap();
        ClientDMNType dmnTypeOne = (ClientDMNType)Mockito.mock(ClientDMNType.class);
        ClientDMNType dmnTypeTwo = (ClientDMNType)Mockito.mock(ClientDMNType.class);
        ClientDMNType dmnTypeThree = (ClientDMNType)Mockito.mock(ClientDMNType.class);
        ((AbstractKogitoDMNService)Mockito.doReturn((Object)dmnTypeOne).when((Object)this.abstractKogitoDMNServiceSpy)).createDMNType(indexed, definition1, NAMESPACE, createdTypes);
        ((AbstractKogitoDMNService)Mockito.doReturn((Object)dmnTypeTwo).when((Object)this.abstractKogitoDMNServiceSpy)).createDMNType(indexed, definition2, NAMESPACE, createdTypes);
        ((AbstractKogitoDMNService)Mockito.doReturn((Object)dmnTypeThree).when((Object)this.abstractKogitoDMNServiceSpy)).createDMNType(indexed, definition3, NAMESPACE, createdTypes);
        ClientDMNType actualDmnTypeOne = this.abstractKogitoDMNServiceSpy.getOrCreateDMNType(indexed, "tTypeOne", NAMESPACE, createdTypes);
        ClientDMNType actualDmnTypeTwo = this.abstractKogitoDMNServiceSpy.getOrCreateDMNType(indexed, "tTypeTwo", NAMESPACE, createdTypes);
        ClientDMNType actualDmnTypeThree = this.abstractKogitoDMNServiceSpy.getOrCreateDMNType(indexed, "tTypeThree", NAMESPACE, createdTypes);
        Assert.assertEquals((Object)dmnTypeOne, (Object)actualDmnTypeOne);
        Assert.assertEquals((Object)dmnTypeTwo, (Object)actualDmnTypeTwo);
        Assert.assertEquals((Object)dmnTypeThree, (Object)actualDmnTypeThree);
    }

    @Test
    public void testGetOrCreateDMNTypeWhenTypeIsAlreadyCreated() {
        String namespace = NAMESPACE;
        String typeOneName = "tTypeOne";
        JSITItemDefinition definition1 = this.createJSITItemDefinitionMock("tTypeOne");
        Map indexed = this.abstractKogitoDMNServiceSpy.indexDefinitionsByName(Arrays.asList(definition1));
        ClientDMNType dmnTypeOne = (ClientDMNType)Mockito.mock(ClientDMNType.class);
        HashMap<String, ClientDMNType> createdTypes = new HashMap<String, ClientDMNType>();
        createdTypes.put("tTypeOne", dmnTypeOne);
        ClientDMNType actualDmnTypeOne = this.abstractKogitoDMNServiceSpy.getOrCreateDMNType(indexed, "tTypeOne", NAMESPACE, createdTypes);
        ((AbstractKogitoDMNService)Mockito.verify((Object)this.abstractKogitoDMNServiceSpy, (VerificationMode)Mockito.never())).createDMNType(indexed, definition1, NAMESPACE, createdTypes);
        Assert.assertEquals((Object)dmnTypeOne, (Object)actualDmnTypeOne);
    }

    @Test(expected=IllegalStateException.class)
    public void testGetOrCreateDMNTypeWhenTypeIsNotFound() {
        String namespace = NAMESPACE;
        HashMap indexed = new HashMap();
        HashMap createdTypes = new HashMap();
        this.abstractKogitoDMNServiceSpy.getOrCreateDMNType(indexed, "unknownType", NAMESPACE, createdTypes);
    }

    private JSITItemDefinition createJSITItemDefinitionMock(String name) {
        JSITItemDefinition mock = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        Mockito.when((Object)mock.getName()).thenReturn((Object)name);
        return mock;
    }

    @Test
    public void getDMNTypesMapEmptyItemDefinitions() {
        Map dmnTypesMap = this.abstractKogitoDMNServiceSpy.getDMNDataTypesMap(this.jstiItemDefinitions, NAMESPACE);
        Assert.assertTrue((dmnTypesMap.size() == 14 ? 1 : 0) != 0);
        for (Map.Entry entry : dmnTypesMap.entrySet()) {
            TestCase.assertNotNull((Object)((ClientDMNType)entry.getValue()).getFeelType());
            Assert.assertTrue((boolean)Arrays.stream(((ClientDMNType)entry.getValue()).getFeelType().getNames()).anyMatch(((String)entry.getKey())::equals));
        }
        for (BuiltInType builtInType : BuiltInType.values()) {
            Arrays.stream(builtInType.getNames()).forEach(name -> TestCase.assertNotNull(dmnTypesMap.get(name)));
        }
    }

    @Test
    public void getDMNTypesMapWithItemDefinitions() {
        this.jstiItemDefinitions.add(this.jsitItemDefinitionMock);
        Map dmnTypesMap = this.abstractKogitoDMNServiceSpy.getDMNDataTypesMap(this.jstiItemDefinitions, NAMESPACE);
        Assert.assertTrue((dmnTypesMap.size() == 15 ? 1 : 0) != 0);
        for (BuiltInType builtInType : BuiltInType.values()) {
            Arrays.stream(builtInType.getNames()).forEach(name -> TestCase.assertNotNull(dmnTypesMap.get(name)));
        }
        TestCase.assertNotNull(dmnTypesMap.get(TYPE_NAME));
        Assert.assertNull((Object)((ClientDMNType)dmnTypesMap.get(TYPE_NAME)).getFeelType());
        Assert.assertEquals((Object)TYPE_NAME, (Object)((ClientDMNType)dmnTypesMap.get(TYPE_NAME)).getName());
        Assert.assertEquals((Object)NAMESPACE, (Object)((ClientDMNType)dmnTypesMap.get(TYPE_NAME)).getNamespace());
        Assert.assertFalse((boolean)((ClientDMNType)dmnTypesMap.get(TYPE_NAME)).isCollection());
    }

    @Test
    public void testGetCustomWithItemComponentDMNTypes() {
        JSITItemDefinition tPeople = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        String tPeopleType = "tPeopleType";
        String addressFieldName = "address";
        String countryFieldName = "country";
        Mockito.when((Object)tPeople.getName()).thenReturn((Object)"tPeopleType");
        JSITItemDefinition address = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        Mockito.when((Object)address.getName()).thenReturn((Object)"address");
        List<JSITItemDefinition> tPeopleFields = Arrays.asList(address);
        JSITItemDefinition country = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        Mockito.when((Object)country.getName()).thenReturn((Object)"country");
        Mockito.when((Object)country.getTypeRef()).thenReturn((Object)BuiltInType.STRING.getName());
        List<JSITItemDefinition> tAddressFields = Arrays.asList(country);
        Mockito.when((Object)tPeople.getItemComponent()).thenReturn(tPeopleFields);
        Mockito.when((Object)address.getItemComponent()).thenReturn(tAddressFields);
        List<JSITItemDefinition> definitions = Arrays.asList(tPeople);
        Map dmnTypesMap = this.abstractKogitoDMNServiceSpy.getDMNDataTypesMap(definitions, NAMESPACE);
        Assert.assertTrue((boolean)dmnTypesMap.containsKey("tPeopleType"));
        ClientDMNType dmnPeopleType = (ClientDMNType)dmnTypesMap.get("tPeopleType");
        Assert.assertEquals((long)1L, (long)dmnPeopleType.getFields().size());
        Assert.assertTrue((boolean)dmnPeopleType.getFields().containsKey("address"));
        Assert.assertNull((Object)dmnPeopleType.getFeelType());
        Assert.assertFalse((boolean)dmnPeopleType.isCollection());
        Assert.assertTrue((boolean)dmnPeopleType.isComposite());
        ClientDMNType addressType = (ClientDMNType)dmnPeopleType.getFields().get("address");
        TestCase.assertNotNull((Object)addressType);
        Assert.assertEquals((long)1L, (long)addressType.getFields().size());
        Assert.assertTrue((boolean)addressType.getFields().containsKey("country"));
        Assert.assertNull((Object)addressType.getFeelType());
        Assert.assertFalse((boolean)addressType.isCollection());
        Assert.assertTrue((boolean)addressType.isComposite());
        ClientDMNType countryType = (ClientDMNType)addressType.getFields().get("country");
        Assert.assertEquals((long)0L, (long)countryType.getFields().size());
        Assert.assertEquals((Object)BuiltInType.STRING, (Object)countryType.getFeelType());
        Assert.assertFalse((boolean)countryType.isCollection());
        Assert.assertFalse((boolean)countryType.isComposite());
        Assert.assertTrue((dmnTypesMap.size() == 15 ? 1 : 0) != 0);
        for (BuiltInType builtInType : BuiltInType.values()) {
            Arrays.stream(builtInType.getNames()).forEach(name -> TestCase.assertNotNull(dmnTypesMap.get(name)));
        }
    }

    @Test
    public void testGetCustomInheritsSimpleCustomDMNTypes() {
        JSITItemDefinition tPeople = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        JSITItemDefinition tMen = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        String tPeopleType = "tPeopleType";
        String tMenType = "tMenType";
        Mockito.when((Object)tMen.getName()).thenReturn((Object)"tMenType");
        Mockito.when((Object)tMen.getTypeRef()).thenReturn((Object)"tPeopleType");
        Mockito.when((Object)tPeople.getName()).thenReturn((Object)"tPeopleType");
        Mockito.when((Object)tPeople.getTypeRef()).thenReturn((Object)BuiltInType.STRING.getName());
        List<JSITItemDefinition> definitions = Arrays.asList(tPeople, tMen);
        Map dmnTypesMap = this.abstractKogitoDMNServiceSpy.getDMNDataTypesMap(definitions, NAMESPACE);
        Assert.assertTrue((boolean)dmnTypesMap.containsKey("tPeopleType"));
        ClientDMNType dmnPeopleType = (ClientDMNType)dmnTypesMap.get("tPeopleType");
        Assert.assertTrue((boolean)dmnPeopleType.getFields().isEmpty());
        Assert.assertEquals((Object)BuiltInType.STRING, (Object)dmnPeopleType.getFeelType());
        Assert.assertFalse((boolean)dmnPeopleType.isCollection());
        Assert.assertFalse((boolean)dmnPeopleType.isComposite());
        ClientDMNType dmnMenType = (ClientDMNType)dmnTypesMap.get("tMenType");
        Assert.assertTrue((boolean)dmnMenType.getFields().isEmpty());
        Assert.assertEquals((Object)BuiltInType.STRING, (Object)dmnMenType.getFeelType());
        Assert.assertFalse((boolean)dmnMenType.isCollection());
        Assert.assertFalse((boolean)dmnMenType.isComposite());
        Assert.assertTrue((dmnTypesMap.size() == 16 ? 1 : 0) != 0);
        for (BuiltInType builtInType : BuiltInType.values()) {
            Arrays.stream(builtInType.getNames()).forEach(name -> TestCase.assertNotNull(dmnTypesMap.get(name)));
        }
    }

    @Test
    public void testGetCustomCollectionInheritsSimpleCustomDMNTypes() {
        JSITItemDefinition tPeople = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        JSITItemDefinition tMen = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        String tPeopleType = "tPeopleType";
        String tMenType = "tMenType";
        Mockito.when((Object)tMen.getName()).thenReturn((Object)"tMenType");
        Mockito.when((Object)tMen.getTypeRef()).thenReturn((Object)"tPeopleType");
        Mockito.when((Object)tMen.getIsCollection()).thenReturn((Object)true);
        Mockito.when((Object)tPeople.getName()).thenReturn((Object)"tPeopleType");
        Mockito.when((Object)tPeople.getTypeRef()).thenReturn((Object)BuiltInType.STRING.getName());
        List<JSITItemDefinition> definitions = Arrays.asList(tPeople, tMen);
        Map dmnTypesMap = this.abstractKogitoDMNServiceSpy.getDMNDataTypesMap(definitions, NAMESPACE);
        Assert.assertTrue((boolean)dmnTypesMap.containsKey("tPeopleType"));
        ClientDMNType dmnPeopleType = (ClientDMNType)dmnTypesMap.get("tPeopleType");
        Assert.assertTrue((boolean)dmnPeopleType.getFields().isEmpty());
        Assert.assertEquals((Object)BuiltInType.STRING, (Object)dmnPeopleType.getFeelType());
        Assert.assertFalse((boolean)dmnPeopleType.isCollection());
        Assert.assertFalse((boolean)dmnPeopleType.isComposite());
        ClientDMNType dmnMenType = (ClientDMNType)dmnTypesMap.get("tMenType");
        Assert.assertTrue((boolean)dmnMenType.getFields().isEmpty());
        Assert.assertEquals((Object)BuiltInType.STRING, (Object)dmnMenType.getFeelType());
        Assert.assertTrue((boolean)dmnMenType.isCollection());
        Assert.assertFalse((boolean)dmnMenType.isComposite());
        Assert.assertTrue((dmnTypesMap.size() == 16 ? 1 : 0) != 0);
        for (BuiltInType builtInType : BuiltInType.values()) {
            Arrays.stream(builtInType.getNames()).forEach(name -> TestCase.assertNotNull(dmnTypesMap.get(name)));
        }
    }

    @Test
    public void testGetCustomInheritsSimpleCustomCollectionDMNTypes() {
        JSITItemDefinition tPeople = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        JSITItemDefinition tMen = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        String tPeopleType = "tPeopleType";
        String tMenType = "tMenType";
        Mockito.when((Object)tMen.getName()).thenReturn((Object)"tMenType");
        Mockito.when((Object)tMen.getTypeRef()).thenReturn((Object)"tPeopleType");
        Mockito.when((Object)tPeople.getName()).thenReturn((Object)"tPeopleType");
        Mockito.when((Object)tPeople.getTypeRef()).thenReturn((Object)BuiltInType.STRING.getName());
        Mockito.when((Object)tPeople.getIsCollection()).thenReturn((Object)true);
        List<JSITItemDefinition> definitions = Arrays.asList(tPeople, tMen);
        Map dmnTypesMap = this.abstractKogitoDMNServiceSpy.getDMNDataTypesMap(definitions, NAMESPACE);
        Assert.assertTrue((boolean)dmnTypesMap.containsKey("tPeopleType"));
        ClientDMNType dmnPeopleType = (ClientDMNType)dmnTypesMap.get("tPeopleType");
        Assert.assertTrue((boolean)dmnPeopleType.getFields().isEmpty());
        Assert.assertEquals((Object)BuiltInType.STRING, (Object)dmnPeopleType.getFeelType());
        Assert.assertTrue((boolean)dmnPeopleType.isCollection());
        Assert.assertFalse((boolean)dmnPeopleType.isComposite());
        ClientDMNType dmnMenType = (ClientDMNType)dmnTypesMap.get("tMenType");
        Assert.assertTrue((boolean)dmnMenType.getFields().isEmpty());
        Assert.assertEquals((Object)BuiltInType.STRING, (Object)dmnMenType.getFeelType());
        Assert.assertTrue((boolean)dmnMenType.isCollection());
        Assert.assertFalse((boolean)dmnMenType.isComposite());
        Assert.assertTrue((dmnTypesMap.size() == 16 ? 1 : 0) != 0);
        for (BuiltInType builtInType : BuiltInType.values()) {
            Arrays.stream(builtInType.getNames()).forEach(name -> TestCase.assertNotNull(dmnTypesMap.get(name)));
        }
    }

    @Test
    public void testGetRecursiveDMNTypes() {
        JSITItemDefinition tPeople = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        JSITItemDefinition tAddress = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        JSITItemDefinition tCountry = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        String tPeopleType = "tPeopleType";
        String tAddressType = "tAddressType";
        String tCountryType = "tCountryType";
        String addressFieldName = "address";
        String countryFieldName = "president";
        String peopleFieldName = "people";
        Mockito.when((Object)tPeople.getName()).thenReturn((Object)"tPeopleType");
        Mockito.when((Object)tAddress.getName()).thenReturn((Object)"tAddressType");
        Mockito.when((Object)tCountry.getName()).thenReturn((Object)"tCountryType");
        JSITItemDefinition address = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        Mockito.when((Object)address.getTypeRef()).thenReturn((Object)"tAddressType");
        Mockito.when((Object)address.getName()).thenReturn((Object)"address");
        List<JSITItemDefinition> tPeopleFields = Arrays.asList(address);
        JSITItemDefinition country = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        Mockito.when((Object)country.getName()).thenReturn((Object)"president");
        Mockito.when((Object)country.getTypeRef()).thenReturn((Object)"tCountryType");
        List<JSITItemDefinition> tAddressFields = Arrays.asList(country);
        JSITItemDefinition people = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        Mockito.when((Object)people.getTypeRef()).thenReturn((Object)"tPeopleType");
        Mockito.when((Object)people.getName()).thenReturn((Object)"people");
        List<JSITItemDefinition> tCountryFields = Arrays.asList(people);
        Mockito.when((Object)tPeople.getItemComponent()).thenReturn(tPeopleFields);
        Mockito.when((Object)tAddress.getItemComponent()).thenReturn(tAddressFields);
        Mockito.when((Object)tCountry.getItemComponent()).thenReturn(tCountryFields);
        List<JSITItemDefinition> definitions = Arrays.asList(tPeople, tAddress, tCountry);
        Map dmnTypesMap = this.abstractKogitoDMNServiceSpy.getDMNDataTypesMap(definitions, NAMESPACE);
        Assert.assertTrue((boolean)dmnTypesMap.containsKey("tPeopleType"));
        Assert.assertTrue((boolean)dmnTypesMap.containsKey("tAddressType"));
        Assert.assertTrue((boolean)dmnTypesMap.containsKey("tCountryType"));
        ClientDMNType dmnPeopleType = (ClientDMNType)dmnTypesMap.get("tPeopleType");
        ClientDMNType dmnAddressType = (ClientDMNType)dmnTypesMap.get("tAddressType");
        ClientDMNType dmnCountryType = (ClientDMNType)dmnTypesMap.get("tCountryType");
        Assert.assertEquals((long)1L, (long)dmnPeopleType.getFields().size());
        Assert.assertTrue((boolean)dmnPeopleType.getFields().containsKey("address"));
        Assert.assertEquals((Object)dmnAddressType, dmnPeopleType.getFields().get("address"));
        Assert.assertFalse((boolean)dmnPeopleType.isCollection());
        Assert.assertTrue((boolean)dmnPeopleType.isComposite());
        Assert.assertEquals((long)1L, (long)dmnAddressType.getFields().size());
        Assert.assertTrue((boolean)dmnAddressType.getFields().containsKey("president"));
        Assert.assertEquals((Object)dmnCountryType, dmnAddressType.getFields().get("president"));
        Assert.assertFalse((boolean)dmnAddressType.isCollection());
        Assert.assertTrue((boolean)dmnAddressType.isComposite());
        Assert.assertEquals((long)1L, (long)dmnCountryType.getFields().size());
        Assert.assertTrue((boolean)dmnCountryType.getFields().containsKey("people"));
        Assert.assertEquals((Object)dmnPeopleType, dmnCountryType.getFields().get("people"));
        Assert.assertFalse((boolean)dmnCountryType.isCollection());
        Assert.assertTrue((boolean)dmnCountryType.isComposite());
        Assert.assertTrue((dmnTypesMap.size() == 17 ? 1 : 0) != 0);
        for (BuiltInType builtInType : BuiltInType.values()) {
            Arrays.stream(builtInType.getNames()).forEach(name -> TestCase.assertNotNull(dmnTypesMap.get(name)));
        }
    }

    @Test
    public void testGetRecursiveAndDataTypeCollectionDMNTypes() {
        JSITItemDefinition tPeople = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        JSITItemDefinition tAddress = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        JSITItemDefinition tCountry = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        String tPeopleType = "tPeopleType";
        String tAddressType = "tAddressType";
        String tCountryType = "tCountryType";
        String addressFieldName = "address";
        String countryFieldName = "president";
        String peopleFieldName = "people";
        Mockito.when((Object)tPeople.getName()).thenReturn((Object)"tPeopleType");
        Mockito.when((Object)tAddress.getName()).thenReturn((Object)"tAddressType");
        Mockito.when((Object)tCountry.getName()).thenReturn((Object)"tCountryType");
        Mockito.when((Object)tPeople.getIsCollection()).thenReturn((Object)true);
        JSITItemDefinition address = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        Mockito.when((Object)address.getTypeRef()).thenReturn((Object)"tAddressType");
        Mockito.when((Object)address.getName()).thenReturn((Object)"address");
        List<JSITItemDefinition> tPeopleFields = Arrays.asList(address);
        JSITItemDefinition country = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        Mockito.when((Object)country.getName()).thenReturn((Object)"president");
        Mockito.when((Object)country.getTypeRef()).thenReturn((Object)"tCountryType");
        List<JSITItemDefinition> tAddressFields = Arrays.asList(country);
        JSITItemDefinition people = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        Mockito.when((Object)people.getTypeRef()).thenReturn((Object)"tPeopleType");
        Mockito.when((Object)people.getName()).thenReturn((Object)"people");
        List<JSITItemDefinition> tCountryFields = Arrays.asList(people);
        Mockito.when((Object)tPeople.getItemComponent()).thenReturn(tPeopleFields);
        Mockito.when((Object)tAddress.getItemComponent()).thenReturn(tAddressFields);
        Mockito.when((Object)tCountry.getItemComponent()).thenReturn(tCountryFields);
        List<JSITItemDefinition> definitions = Arrays.asList(tPeople, tAddress, tCountry);
        Map dmnTypesMap = this.abstractKogitoDMNServiceSpy.getDMNDataTypesMap(definitions, NAMESPACE);
        Assert.assertTrue((boolean)dmnTypesMap.containsKey("tPeopleType"));
        Assert.assertTrue((boolean)dmnTypesMap.containsKey("tAddressType"));
        Assert.assertTrue((boolean)dmnTypesMap.containsKey("tCountryType"));
        ClientDMNType dmnPeopleType = (ClientDMNType)dmnTypesMap.get("tPeopleType");
        ClientDMNType dmnAddressType = (ClientDMNType)dmnTypesMap.get("tAddressType");
        ClientDMNType dmnCountryType = (ClientDMNType)dmnTypesMap.get("tCountryType");
        Assert.assertEquals((long)1L, (long)dmnPeopleType.getFields().size());
        Assert.assertTrue((boolean)dmnPeopleType.getFields().containsKey("address"));
        Assert.assertEquals((Object)dmnAddressType, dmnPeopleType.getFields().get("address"));
        Assert.assertTrue((boolean)dmnPeopleType.isCollection());
        Assert.assertTrue((boolean)dmnPeopleType.isComposite());
        Assert.assertEquals((long)1L, (long)dmnAddressType.getFields().size());
        Assert.assertTrue((boolean)dmnAddressType.getFields().containsKey("president"));
        Assert.assertEquals((Object)dmnCountryType, dmnAddressType.getFields().get("president"));
        Assert.assertFalse((boolean)dmnAddressType.isCollection());
        Assert.assertTrue((boolean)dmnAddressType.isComposite());
        Assert.assertEquals((long)1L, (long)dmnCountryType.getFields().size());
        Assert.assertTrue((boolean)dmnCountryType.getFields().containsKey("people"));
        Assert.assertEquals((Object)dmnPeopleType, dmnCountryType.getFields().get("people"));
        Assert.assertFalse((boolean)dmnCountryType.isCollection());
        Assert.assertTrue((boolean)dmnCountryType.isComposite());
        Assert.assertTrue((dmnTypesMap.size() == 17 ? 1 : 0) != 0);
        for (BuiltInType builtInType : BuiltInType.values()) {
            Arrays.stream(builtInType.getNames()).forEach(name -> TestCase.assertNotNull(dmnTypesMap.get(name)));
        }
    }

    @Test
    public void testGetRecursiveAndFieldCollectionsDMNTypes() {
        JSITItemDefinition tPeople = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        JSITItemDefinition tAddress = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        JSITItemDefinition tCountry = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        String tPeopleType = "tPeopleType";
        String tAddressType = "tAddressType";
        String tCountryType = "tCountryType";
        String addressFieldName = "address";
        String countryFieldName = "president";
        String peopleFieldName = "people";
        String regionsName = "regions";
        String nameLabel = TYPE_NAME;
        Mockito.when((Object)tPeople.getName()).thenReturn((Object)"tPeopleType");
        Mockito.when((Object)tAddress.getName()).thenReturn((Object)"tAddressType");
        Mockito.when((Object)tCountry.getName()).thenReturn((Object)"tCountryType");
        JSITItemDefinition address = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        Mockito.when((Object)address.getTypeRef()).thenReturn((Object)"tAddressType");
        Mockito.when((Object)address.getName()).thenReturn((Object)"address");
        List<JSITItemDefinition> tPeopleFields = Arrays.asList(address);
        JSITItemDefinition country = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        Mockito.when((Object)country.getName()).thenReturn((Object)"president");
        Mockito.when((Object)country.getTypeRef()).thenReturn((Object)"tCountryType");
        List<JSITItemDefinition> tAddressFields = Arrays.asList(country);
        JSITItemDefinition people = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        Mockito.when((Object)people.getTypeRef()).thenReturn((Object)"tPeopleType");
        Mockito.when((Object)people.getName()).thenReturn((Object)"people");
        Mockito.when((Object)people.getIsCollection()).thenReturn((Object)true);
        JSITItemDefinition regions = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        Mockito.when((Object)regions.getTypeRef()).thenReturn((Object)BuiltInType.STRING.getName());
        Mockito.when((Object)regions.getName()).thenReturn((Object)"regions");
        Mockito.when((Object)regions.getIsCollection()).thenReturn((Object)true);
        JSITItemDefinition nameField = (JSITItemDefinition)Mockito.mock(JSITItemDefinition.class);
        Mockito.when((Object)nameField.getTypeRef()).thenReturn((Object)BuiltInType.STRING.getName());
        Mockito.when((Object)nameField.getName()).thenReturn((Object)TYPE_NAME);
        List<JSITItemDefinition> tCountryFields = Arrays.asList(people, regions, nameField);
        Mockito.when((Object)tPeople.getItemComponent()).thenReturn(tPeopleFields);
        Mockito.when((Object)tAddress.getItemComponent()).thenReturn(tAddressFields);
        Mockito.when((Object)tCountry.getItemComponent()).thenReturn(tCountryFields);
        List<JSITItemDefinition> definitions = Arrays.asList(tPeople, tAddress, tCountry);
        Map dmnTypesMap = this.abstractKogitoDMNServiceSpy.getDMNDataTypesMap(definitions, NAMESPACE);
        Assert.assertTrue((boolean)dmnTypesMap.containsKey("tPeopleType"));
        Assert.assertTrue((boolean)dmnTypesMap.containsKey("tAddressType"));
        Assert.assertTrue((boolean)dmnTypesMap.containsKey("tCountryType"));
        ClientDMNType dmnPeopleType = (ClientDMNType)dmnTypesMap.get("tPeopleType");
        ClientDMNType dmnAddressType = (ClientDMNType)dmnTypesMap.get("tAddressType");
        ClientDMNType dmnCountryType = (ClientDMNType)dmnTypesMap.get("tCountryType");
        ClientDMNType stringType = (ClientDMNType)dmnTypesMap.get(BuiltInType.STRING.getName());
        Assert.assertEquals((long)1L, (long)dmnPeopleType.getFields().size());
        Assert.assertTrue((boolean)dmnPeopleType.getFields().containsKey("address"));
        Assert.assertEquals((Object)dmnAddressType, dmnPeopleType.getFields().get("address"));
        Assert.assertNull((Object)dmnPeopleType.getFeelType());
        Assert.assertFalse((boolean)dmnPeopleType.isCollection());
        Assert.assertTrue((boolean)dmnPeopleType.isComposite());
        Assert.assertEquals((long)1L, (long)dmnAddressType.getFields().size());
        Assert.assertTrue((boolean)dmnAddressType.getFields().containsKey("president"));
        Assert.assertEquals((Object)dmnCountryType, dmnAddressType.getFields().get("president"));
        Assert.assertNull((Object)dmnAddressType.getFeelType());
        Assert.assertFalse((boolean)dmnAddressType.isCollection());
        Assert.assertTrue((boolean)dmnAddressType.isComposite());
        Assert.assertEquals((long)3L, (long)dmnCountryType.getFields().size());
        Assert.assertTrue((boolean)dmnCountryType.getFields().containsKey("people"));
        Assert.assertNotEquals((Object)dmnPeopleType, dmnCountryType.getFields().get("people"));
        Assert.assertTrue((boolean)((ClientDMNType)dmnCountryType.getFields().get("people")).isCollection());
        Assert.assertTrue((boolean)((ClientDMNType)dmnCountryType.getFields().get("people")).isComposite());
        Assert.assertEquals((Object)"tPeopleType", (Object)((ClientDMNType)dmnCountryType.getFields().get("people")).getName());
        Assert.assertTrue((boolean)dmnCountryType.getFields().containsKey("regions"));
        Assert.assertNull((Object)dmnCountryType.getFeelType());
        Assert.assertNotEquals((Object)stringType, dmnCountryType.getFields().get("regions"));
        Assert.assertTrue((boolean)((ClientDMNType)dmnCountryType.getFields().get("regions")).isCollection());
        Assert.assertFalse((boolean)((ClientDMNType)dmnCountryType.getFields().get("regions")).isComposite());
        Assert.assertEquals((Object)BuiltInType.STRING.getName(), (Object)((ClientDMNType)dmnCountryType.getFields().get("regions")).getName());
        Assert.assertTrue((boolean)dmnCountryType.getFields().containsKey(TYPE_NAME));
        Assert.assertEquals((Object)stringType, dmnCountryType.getFields().get(TYPE_NAME));
        Assert.assertEquals((Object)BuiltInType.STRING, (Object)stringType.getFeelType());
        Assert.assertFalse((boolean)stringType.isCollection());
        Assert.assertFalse((boolean)stringType.isComposite());
        Assert.assertTrue((dmnTypesMap.size() == 17 ? 1 : 0) != 0);
        for (BuiltInType builtInType : BuiltInType.values()) {
            Arrays.stream(builtInType.getNames()).forEach(name -> TestCase.assertNotNull(dmnTypesMap.get(name)));
        }
    }

    @Test
    public void createDMNTypeItemDefinitionSimpleTypeRefNoFields() {
        HashMap defaultTypesMap = new HashMap(this.abstractKogitoDMNServiceSpy.getDMNDataTypesMap(Collections.emptyList(), NAMESPACE));
        this.allDefinitions = this.abstractKogitoDMNServiceSpy.indexDefinitionsByName(Arrays.asList(this.jsitItemDefinitionMock));
        Mockito.when((Object)this.jsitItemDefinitionMock.getItemComponent()).thenReturn(new ArrayList());
        Mockito.when((Object)this.jsitItemDefinitionMock.getTypeRef()).thenReturn((Object)BuiltInType.STRING.getName());
        ClientDMNType clientDmnType = this.abstractKogitoDMNServiceSpy.createDMNType(this.allDefinitions, this.jsitItemDefinitionMock, NAMESPACE, defaultTypesMap);
        Assert.assertEquals((Object)NAMESPACE, (Object)clientDmnType.getNamespace());
        Assert.assertEquals((Object)TYPE_NAME, (Object)clientDmnType.getName());
        Assert.assertFalse((boolean)clientDmnType.isCollection());
        Assert.assertFalse((boolean)clientDmnType.isComposite());
        Assert.assertTrue((boolean)clientDmnType.getFields().isEmpty());
        Assert.assertEquals((Object)BuiltInType.STRING, (Object)clientDmnType.getFeelType());
        Assert.assertTrue((boolean)defaultTypesMap.containsKey(TYPE_NAME));
        Assert.assertTrue((boolean)defaultTypesMap.containsValue(clientDmnType));
    }

    @Test
    public void createDMNTypeSimpleItemComponentSimpleTypeRefNoFields() {
        HashMap defaultTypesMap = new HashMap(this.abstractKogitoDMNServiceSpy.getDMNDataTypesMap(Collections.emptyList(), NAMESPACE));
        Mockito.when((Object)this.jsitItemDefinitionMock.getItemComponent()).thenReturn(new ArrayList());
        Mockito.when((Object)this.jsitItemDefinitionMock.getTypeRef()).thenReturn((Object)BuiltInType.STRING.getName());
        ClientDMNType clientDmnType = this.abstractKogitoDMNServiceSpy.createDMNType(this.allDefinitions, this.jsitItemDefinitionMock, NAMESPACE, defaultTypesMap);
        Assert.assertEquals((Object)NAMESPACE, (Object)clientDmnType.getNamespace());
        Assert.assertEquals((Object)TYPE_NAME, (Object)clientDmnType.getName());
        Assert.assertFalse((boolean)clientDmnType.isCollection());
        Assert.assertFalse((boolean)clientDmnType.isComposite());
        Assert.assertTrue((boolean)clientDmnType.getFields().isEmpty());
        Assert.assertEquals((Object)BuiltInType.STRING, (Object)clientDmnType.getFeelType());
        Assert.assertFalse((boolean)defaultTypesMap.containsKey(TYPE_NAME));
        Assert.assertFalse((boolean)defaultTypesMap.containsValue(clientDmnType));
    }

    @Test
    public void createDMNTypeItemDefinitionWithField() {
        HashMap defaultTypesMap = new HashMap(this.abstractKogitoDMNServiceSpy.getDMNDataTypesMap(Collections.emptyList(), NAMESPACE));
        Mockito.when((Object)this.jsitItemDefinitionMock.getItemComponent()).thenReturn(Arrays.asList(this.jsitItemDefinitionNestedMock));
        Mockito.when((Object)this.jsitItemDefinitionNestedMock.getName()).thenReturn((Object)"tNested");
        Mockito.when((Object)this.jsitItemDefinitionNestedMock.getId()).thenReturn((Object)ID);
        Mockito.when((Object)this.jsitItemDefinitionNestedMock.getTypeRef()).thenReturn((Object)BuiltInType.STRING.getName());
        this.allDefinitions = this.abstractKogitoDMNServiceSpy.indexDefinitionsByName(Arrays.asList(this.jsitItemDefinitionMock));
        ClientDMNType clientDmnType = this.abstractKogitoDMNServiceSpy.createDMNType(this.allDefinitions, this.jsitItemDefinitionMock, NAMESPACE, defaultTypesMap);
        Assert.assertEquals((Object)NAMESPACE, (Object)clientDmnType.getNamespace());
        Assert.assertEquals((Object)TYPE_NAME, (Object)clientDmnType.getName());
        Assert.assertFalse((boolean)clientDmnType.isCollection());
        Assert.assertTrue((boolean)clientDmnType.isComposite());
        TestCase.assertNotNull((Object)clientDmnType.getFields());
        Assert.assertTrue((clientDmnType.getFields().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)BuiltInType.STRING, (Object)((ClientDMNType)clientDmnType.getFields().get("tNested")).getFeelType());
        Assert.assertFalse((boolean)((ClientDMNType)clientDmnType.getFields().get("tNested")).isCollection());
        Assert.assertFalse((boolean)((ClientDMNType)clientDmnType.getFields().get("tNested")).isComposite());
        Assert.assertNull((Object)clientDmnType.getFeelType());
        Assert.assertTrue((boolean)defaultTypesMap.containsKey(TYPE_NAME));
        Assert.assertTrue((boolean)defaultTypesMap.containsValue(clientDmnType));
    }

    @Test
    public void createDMNTypeItemComponentWithField() {
        HashMap defaultTypesMap = new HashMap(this.abstractKogitoDMNServiceSpy.getDMNDataTypesMap(Collections.emptyList(), NAMESPACE));
        Mockito.when((Object)this.jsitItemDefinitionMock.getItemComponent()).thenReturn(Arrays.asList(this.jsitItemDefinitionNestedMock));
        Mockito.when((Object)this.jsitItemDefinitionNestedMock.getName()).thenReturn((Object)"tNested");
        Mockito.when((Object)this.jsitItemDefinitionNestedMock.getId()).thenReturn((Object)ID);
        Mockito.when((Object)this.jsitItemDefinitionNestedMock.getTypeRef()).thenReturn((Object)BuiltInType.STRING.getName());
        ClientDMNType clientDmnType = this.abstractKogitoDMNServiceSpy.createDMNType(this.allDefinitions, this.jsitItemDefinitionMock, NAMESPACE, defaultTypesMap);
        Assert.assertEquals((Object)NAMESPACE, (Object)clientDmnType.getNamespace());
        Assert.assertEquals((Object)TYPE_NAME, (Object)clientDmnType.getName());
        Assert.assertFalse((boolean)clientDmnType.isCollection());
        Assert.assertTrue((boolean)clientDmnType.isComposite());
        TestCase.assertNotNull((Object)clientDmnType.getFields());
        Assert.assertTrue((clientDmnType.getFields().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)BuiltInType.STRING, (Object)((ClientDMNType)clientDmnType.getFields().get("tNested")).getFeelType());
        Assert.assertFalse((boolean)((ClientDMNType)clientDmnType.getFields().get("tNested")).isCollection());
        Assert.assertFalse((boolean)((ClientDMNType)clientDmnType.getFields().get("tNested")).isComposite());
        Assert.assertNull((Object)clientDmnType.getFeelType());
        Assert.assertFalse((boolean)defaultTypesMap.containsKey(TYPE_NAME));
        Assert.assertFalse((boolean)defaultTypesMap.containsValue(clientDmnType));
    }

    @Test
    public void createDMNTypeItemDefinitionWithCollectionField() {
        HashMap defaultTypesMap = new HashMap(this.abstractKogitoDMNServiceSpy.getDMNDataTypesMap(Collections.emptyList(), NAMESPACE));
        Mockito.when((Object)this.jsitItemDefinitionMock.getItemComponent()).thenReturn(Arrays.asList(this.jsitItemDefinitionNestedMock));
        Mockito.when((Object)this.jsitItemDefinitionNestedMock.getName()).thenReturn((Object)"tNested");
        Mockito.when((Object)this.jsitItemDefinitionNestedMock.getId()).thenReturn((Object)ID);
        Mockito.when((Object)this.jsitItemDefinitionNestedMock.getTypeRef()).thenReturn((Object)BuiltInType.STRING.getName());
        Mockito.when((Object)this.jsitItemDefinitionNestedMock.getIsCollection()).thenReturn((Object)true);
        this.allDefinitions = this.abstractKogitoDMNServiceSpy.indexDefinitionsByName(Arrays.asList(this.jsitItemDefinitionMock));
        ClientDMNType clientDmnType = this.abstractKogitoDMNServiceSpy.createDMNType(this.allDefinitions, this.jsitItemDefinitionMock, NAMESPACE, defaultTypesMap);
        Assert.assertEquals((Object)NAMESPACE, (Object)clientDmnType.getNamespace());
        Assert.assertEquals((Object)TYPE_NAME, (Object)clientDmnType.getName());
        Assert.assertFalse((boolean)clientDmnType.isCollection());
        Assert.assertTrue((boolean)clientDmnType.isComposite());
        TestCase.assertNotNull((Object)clientDmnType.getFields());
        Assert.assertTrue((clientDmnType.getFields().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)BuiltInType.STRING, (Object)((ClientDMNType)clientDmnType.getFields().get("tNested")).getFeelType());
        Assert.assertTrue((boolean)((ClientDMNType)clientDmnType.getFields().get("tNested")).isCollection());
        Assert.assertFalse((boolean)((ClientDMNType)clientDmnType.getFields().get("tNested")).isComposite());
        Assert.assertNull((Object)clientDmnType.getFeelType());
        Assert.assertTrue((boolean)defaultTypesMap.containsKey(TYPE_NAME));
        Assert.assertTrue((boolean)defaultTypesMap.containsValue(clientDmnType));
    }

    @Test
    public void getFactModelTupleEmptyElements() {
        this.attributesMapInput.put(AbstractKogitoDMNService.TYPEREF_QNAME, "number");
        FactModelTuple factModelTuple = this.abstractKogitoDMNServiceSpy.getFactModelTuple(this.jsiITDefinitionsMock);
        Assert.assertTrue((boolean)factModelTuple.getVisibleFacts().isEmpty());
        Assert.assertTrue((boolean)factModelTuple.getHiddenFacts().isEmpty());
    }

    @Test
    public void getFactModelTupleSimpleInputData() {
        Mockito.when((Object)this.jsiITInputDataMock.getName()).thenReturn((Object)"inputDataName");
        this.drgElements.add((JSITDRGElement)this.jsiITInputDataMock);
        Mockito.when((Object)this.jsiITDefinitionsMock.getDrgElement()).thenReturn(this.drgElements);
        this.attributesMapInput.put(AbstractKogitoDMNService.TYPEREF_QNAME, "number");
        FactModelTuple factModelTuple = this.abstractKogitoDMNServiceSpy.getFactModelTuple(this.jsiITDefinitionsMock);
        Assert.assertTrue((factModelTuple.getVisibleFacts().size() == 1 ? 1 : 0) != 0);
        FactModelTree inputDataNameFact = (FactModelTree)factModelTuple.getVisibleFacts().get("inputDataName");
        TestCase.assertNotNull((Object)inputDataNameFact);
        Assert.assertTrue((inputDataNameFact.getSimpleProperties().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)inputDataNameFact.getSimpleProperties().values().contains("number"));
    }

    @Test
    public void getFactModelTupleSimpleDecisionData() {
        Mockito.when((Object)this.jsiITInformationItemDecisionMock.getName()).thenReturn((Object)"inputDecisionName");
        this.drgElements.add((JSITDRGElement)this.jsiITDecisionMock);
        Mockito.when((Object)this.jsiITDefinitionsMock.getDrgElement()).thenReturn(this.drgElements);
        this.attributesMapDecision.put(AbstractKogitoDMNService.TYPEREF_QNAME, "string");
        FactModelTuple factModelTuple = this.abstractKogitoDMNServiceSpy.getFactModelTuple(this.jsiITDefinitionsMock);
        Assert.assertTrue((factModelTuple.getVisibleFacts().size() == 1 ? 1 : 0) != 0);
        FactModelTree decisionDataNameFact = (FactModelTree)factModelTuple.getVisibleFacts().get("inputDecisionName");
        TestCase.assertNotNull((Object)decisionDataNameFact);
        Assert.assertTrue((decisionDataNameFact.getSimpleProperties().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)decisionDataNameFact.getSimpleProperties().values().contains("string"));
    }

    @Test
    public void getFactModelTupleSimpleInputAndDecisionData() {
        Mockito.when((Object)this.jsiITInputDataMock.getName()).thenReturn((Object)"inputDataName");
        Mockito.when((Object)this.jsiITInformationItemDecisionMock.getName()).thenReturn((Object)"inputDecisionName");
        this.drgElements.add((JSITDRGElement)this.jsiITDecisionMock);
        this.drgElements.add((JSITDRGElement)this.jsiITInputDataMock);
        Mockito.when((Object)this.jsiITDefinitionsMock.getDrgElement()).thenReturn(this.drgElements);
        this.attributesMapInput.put(AbstractKogitoDMNService.TYPEREF_QNAME, "number");
        this.attributesMapDecision.put(AbstractKogitoDMNService.TYPEREF_QNAME, "string");
        FactModelTuple factModelTuple = this.abstractKogitoDMNServiceSpy.getFactModelTuple(this.jsiITDefinitionsMock);
        Assert.assertTrue((factModelTuple.getVisibleFacts().size() == 2 ? 1 : 0) != 0);
        FactModelTree inputDataNameFact = (FactModelTree)factModelTuple.getVisibleFacts().get("inputDataName");
        TestCase.assertNotNull((Object)inputDataNameFact);
        Assert.assertTrue((inputDataNameFact.getSimpleProperties().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)inputDataNameFact.getSimpleProperties().values().contains("number"));
        FactModelTree decisionDataNameFact = (FactModelTree)factModelTuple.getVisibleFacts().get("inputDecisionName");
        TestCase.assertNotNull((Object)decisionDataNameFact);
        Assert.assertTrue((decisionDataNameFact.getSimpleProperties().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)decisionDataNameFact.getSimpleProperties().values().contains("string"));
    }

    @Test
    public void createTopLevelFactModelTreeSimpleNoCollection() {
        ClientDMNType simpleString = this.getSimpleNoCollection();
        FactModelTree retrieved = this.abstractKogitoDMNServiceSpy.createTopLevelFactModelTree("testPath", simpleString, new TreeMap(), FactModelTree.Type.INPUT);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)"testPath", (Object)retrieved.getFactName());
        Assert.assertEquals((long)1L, (long)retrieved.getSimpleProperties().size());
        Assert.assertTrue((boolean)retrieved.getSimpleProperties().containsKey("value"));
        Assert.assertEquals((Object)simpleString.getName(), retrieved.getSimpleProperties().get("value"));
        Assert.assertTrue((boolean)retrieved.getExpandableProperties().isEmpty());
        Assert.assertTrue((boolean)retrieved.getGenericTypesMap().isEmpty());
    }

    @Test
    public void createTopLevelFactModelTreeSimpleCollection() {
        ClientDMNType simpleCollectionString = this.getSimpleCollection();
        TreeMap hiddenFactSimpleCollection = new TreeMap();
        FactModelTree retrieved = this.abstractKogitoDMNServiceSpy.createTopLevelFactModelTree("testPath", simpleCollectionString, hiddenFactSimpleCollection, FactModelTree.Type.INPUT);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)"testPath", (Object)retrieved.getFactName());
        Assert.assertEquals((long)1L, (long)retrieved.getSimpleProperties().size());
        Assert.assertTrue((boolean)retrieved.getSimpleProperties().containsKey("value"));
        Assert.assertEquals((Object)"java.util.List", retrieved.getSimpleProperties().get("value"));
        Assert.assertTrue((boolean)retrieved.getExpandableProperties().isEmpty());
        Assert.assertEquals((long)1L, (long)retrieved.getGenericTypesMap().size());
        Assert.assertTrue((boolean)retrieved.getGenericTypesMap().containsKey("value"));
        Assert.assertNotNull(retrieved.getGenericTypesMap().get("value"));
        Assert.assertEquals((long)1L, (long)((List)retrieved.getGenericTypesMap().get("value")).size());
        Assert.assertEquals((Object)simpleCollectionString.getName(), ((List)retrieved.getGenericTypesMap().get("value")).get(0));
    }

    @Test
    public void createTopLevelFactModelTreeCompositeNoCollection() {
        ClientDMNType compositePerson = this.getSingleCompositeWithSimpleCollection();
        FactModelTree retrieved = this.abstractKogitoDMNServiceSpy.createTopLevelFactModelTree("testPath", compositePerson, new TreeMap(), FactModelTree.Type.INPUT);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)"testPath", (Object)retrieved.getFactName());
        Assert.assertEquals((long)2L, (long)retrieved.getSimpleProperties().size());
        Assert.assertTrue((boolean)retrieved.getSimpleProperties().containsKey("friends"));
        Assert.assertEquals((Object)"java.util.List", retrieved.getSimpleProperties().get("friends"));
        Assert.assertTrue((boolean)retrieved.getSimpleProperties().containsKey(TYPE_NAME));
        Assert.assertEquals((Object)TYPE_NAME, retrieved.getSimpleProperties().get(TYPE_NAME));
        Assert.assertEquals((long)1L, (long)retrieved.getGenericTypesMap().size());
        Assert.assertTrue((boolean)retrieved.getGenericTypesMap().containsKey("friends"));
        Assert.assertEquals((Object)((ClientDMNType)compositePerson.getFields().get("friends")).getName(), ((List)retrieved.getGenericTypesMap().get("friends")).get(0));
        Assert.assertEquals((long)2L, (long)retrieved.getExpandableProperties().size());
        Assert.assertTrue((boolean)retrieved.getExpandableProperties().containsKey("EXPANDABLE_PROPERTY_PHONENUMBERS"));
        Assert.assertEquals((Object)"tPhoneNumber", retrieved.getExpandableProperties().get("EXPANDABLE_PROPERTY_PHONENUMBERS"));
        Assert.assertTrue((boolean)retrieved.getExpandableProperties().containsKey("EXPANDABLE_PROPERTY_DETAILS"));
        Assert.assertEquals((Object)"tDetails", retrieved.getExpandableProperties().get("EXPANDABLE_PROPERTY_DETAILS"));
    }

    @Test
    public void createTopLevelFactModelTreeCompositeCollection() {
        ClientDMNType compositePerson = this.getCompositeCollection();
        TreeMap hiddenFactSimpleCollection = new TreeMap();
        FactModelTree retrieved = this.abstractKogitoDMNServiceSpy.createTopLevelFactModelTree("testPath", compositePerson, hiddenFactSimpleCollection, FactModelTree.Type.INPUT);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)"testPath", (Object)retrieved.getFactName());
        Assert.assertEquals((long)1L, (long)retrieved.getSimpleProperties().size());
        Assert.assertTrue((boolean)retrieved.getSimpleProperties().containsKey("value"));
        Assert.assertEquals((Object)"java.util.List", retrieved.getSimpleProperties().get("value"));
        Assert.assertTrue((boolean)retrieved.getExpandableProperties().isEmpty());
        Assert.assertEquals((long)1L, (long)retrieved.getGenericTypesMap().size());
        Assert.assertTrue((boolean)retrieved.getGenericTypesMap().containsKey("value"));
        Assert.assertNotNull(retrieved.getGenericTypesMap().get("value"));
        Assert.assertEquals((long)1L, (long)((List)retrieved.getGenericTypesMap().get("value")).size());
        Assert.assertEquals((Object)compositePerson.getName(), ((List)retrieved.getGenericTypesMap().get("value")).get(0));
    }

    private ClientDMNType getSimpleNoCollection() {
        return new ClientDMNType(NAMESPACE, TYPE_NAME, null, false, false, null, null);
    }

    private ClientDMNType getSimpleCollection() {
        return new ClientDMNType(NAMESPACE, TYPE_NAME, null, true, false, null, null);
    }

    private ClientDMNType getSingleCompositeWithSimpleCollection() {
        HashMap<String, ClientDMNType> phoneNumberCompositeFields = new HashMap<String, ClientDMNType>();
        phoneNumberCompositeFields.put("PHONENUMBER_PREFIX", new ClientDMNType(null, TYPE_NAME, null, false, null));
        phoneNumberCompositeFields.put("PHONENUMBER_NUMBER", new ClientDMNType(null, TYPE_NAME, null, false, null));
        ClientDMNType phoneNumberComposite = new ClientDMNType(NAMESPACE, "tPhoneNumber", null, false, true, phoneNumberCompositeFields, null);
        HashMap<String, ClientDMNType> detailsCompositeFields = new HashMap<String, ClientDMNType>();
        detailsCompositeFields.put("gender", new ClientDMNType(null, TYPE_NAME, null, false, null));
        detailsCompositeFields.put("weight", new ClientDMNType(null, TYPE_NAME, null, false, null));
        ClientDMNType detailsComposite = new ClientDMNType(NAMESPACE, "tDetails", "tDetails", false, true, detailsCompositeFields, null);
        ClientDMNType nameSimple = new ClientDMNType(null, TYPE_NAME, null, false, null);
        ClientDMNType friendsSimpleCollection = new ClientDMNType(null, TYPE_NAME, null, true, null);
        HashMap<String, ClientDMNType> compositePersonField = new HashMap<String, ClientDMNType>();
        compositePersonField.put("friends", friendsSimpleCollection);
        compositePersonField.put("EXPANDABLE_PROPERTY_PHONENUMBERS", phoneNumberComposite);
        compositePersonField.put("EXPANDABLE_PROPERTY_DETAILS", detailsComposite);
        compositePersonField.put(TYPE_NAME, nameSimple);
        return new ClientDMNType(NAMESPACE, TYPE_NAME, null, false, true, compositePersonField, null);
    }

    protected ClientDMNType getCompositeCollection() {
        HashMap<String, ClientDMNType> phoneNumberCompositeFields = new HashMap<String, ClientDMNType>();
        phoneNumberCompositeFields.put("PHONENUMBER_PREFIX", new ClientDMNType(null, TYPE_NAME, null, false, null));
        phoneNumberCompositeFields.put("PHONENUMBER_NUMBER", new ClientDMNType(null, TYPE_NAME, null, false, null));
        ClientDMNType phoneNumberComposite = new ClientDMNType(NAMESPACE, "tPhoneNumber", null, false, true, phoneNumberCompositeFields, null);
        HashMap<String, ClientDMNType> detailsCompositeFields = new HashMap<String, ClientDMNType>();
        detailsCompositeFields.put("gender", new ClientDMNType(null, TYPE_NAME, null, false, null));
        detailsCompositeFields.put("weight", new ClientDMNType(null, TYPE_NAME, null, false, null));
        ClientDMNType detailsComposite = new ClientDMNType(NAMESPACE, "tDetails", "tDetails", false, true, detailsCompositeFields, null);
        ClientDMNType nameSimple = new ClientDMNType(null, TYPE_NAME, null, false, null);
        ClientDMNType friendsSimpleCollection = new ClientDMNType(null, TYPE_NAME, null, true, null);
        HashMap<String, ClientDMNType> compositePersonField = new HashMap<String, ClientDMNType>();
        compositePersonField.put("friends", friendsSimpleCollection);
        compositePersonField.put("EXPANDABLE_PROPERTY_PHONENUMBERS", phoneNumberComposite);
        compositePersonField.put("EXPANDABLE_PROPERTY_DETAILS", detailsComposite);
        compositePersonField.put(TYPE_NAME, nameSimple);
        return new ClientDMNType(NAMESPACE, TYPE_NAME, null, true, true, compositePersonField, null);
    }
}

