/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.kogito.client.converters;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.workbench.scenariosimulation.kogito.marshaller.js.model.JSIExpressionIdentifierType;
import org.drools.workbench.scenariosimulation.kogito.marshaller.js.model.JSIFactIdentifierType;
import org.drools.workbench.scenariosimulation.kogito.marshaller.js.model.JSIImportType;
import org.drools.workbench.scenariosimulation.kogito.marshaller.js.model.JSIImportsType;
import org.drools.workbench.scenariosimulation.kogito.marshaller.js.model.JSISettingsType;
import org.drools.workbench.screens.scenariosimulation.kogito.client.converters.JSInteropApiConverter;
import org.junit.Assert;
import org.junit.Test;
import org.kie.soup.project.datamodel.imports.Import;
import org.kie.soup.project.datamodel.imports.Imports;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class JSInteropApiConverterTest {
    @Test
    public void getSettings() {
        JSISettingsType jsiSettingsTypeMock = (JSISettingsType)Mockito.mock(JSISettingsType.class);
        Mockito.when((Object)jsiSettingsTypeMock.getType()).thenReturn((Object)ScenarioSimulationModel.Type.RULE.toString());
        Assert.assertNotNull((Object)JSInteropApiConverter.getSettings((JSISettingsType)jsiSettingsTypeMock));
        this.checkAllRequiredMethodsAreCalled(JSISettingsType.class, Settings.class, jsiSettingsTypeMock);
    }

    @Test
    public void getImport() {
        JSIImportType jsiImportTypeMock = (JSIImportType)Mockito.mock(JSIImportType.class);
        Assert.assertNotNull((Object)JSInteropApiConverter.getImport((JSIImportType)jsiImportTypeMock));
        this.checkAllRequiredMethodsAreCalled(JSIImportType.class, Import.class, jsiImportTypeMock);
    }

    @Test
    public void getImports() {
        JSIImportsType jsiImportsTypeMock = (JSIImportsType)Mockito.mock(JSIImportsType.class);
        Assert.assertNotNull((Object)JSInteropApiConverter.getImports((JSIImportsType)jsiImportsTypeMock));
        this.checkAllRequiredMethodsAreCalled(JSIImportsType.class, Imports.class, jsiImportsTypeMock);
    }

    @Test
    public void getExpressionIdentifier() {
        JSIExpressionIdentifierType jsiExpressionIdentifierTypeMock = (JSIExpressionIdentifierType)Mockito.mock(JSIExpressionIdentifierType.class);
        Mockito.when((Object)jsiExpressionIdentifierTypeMock.getType()).thenReturn((Object)FactMappingType.OTHER.toString());
        Assert.assertNotNull((Object)JSInteropApiConverter.getExpressionIdentifier((JSIExpressionIdentifierType)jsiExpressionIdentifierTypeMock));
        this.checkAllRequiredMethodsAreCalled(JSIExpressionIdentifierType.class, ExpressionIdentifier.class, jsiExpressionIdentifierTypeMock);
    }

    @Test
    public void getFactIdentifier() {
        JSIFactIdentifierType jsiFactIdentifierTypeMock = (JSIFactIdentifierType)Mockito.mock(JSIFactIdentifierType.class);
        Assert.assertNotNull((Object)JSInteropApiConverter.getFactIdentifier((JSIFactIdentifierType)jsiFactIdentifierTypeMock));
        this.checkAllRequiredMethodsAreCalled(JSIFactIdentifierType.class, FactIdentifier.class, jsiFactIdentifierTypeMock);
    }

    private void checkAllRequiredMethodsAreCalled(Class inputClazz, Class outputClazz, Object mock) {
        try {
            PropertyDescriptor[] inputPDs = Introspector.getBeanInfo(inputClazz, Object.class).getPropertyDescriptors();
            int inputClassMethodsNumber = inputPDs.length - 1;
            Set<String> outputFieldNames = this.retrieveClassFieldNames(outputClazz);
            int outputClassMethodsNumber = outputFieldNames.size();
            Assert.assertSame((String)("Not all fields are managed in the converter of class " + inputClazz.getSimpleName()), (Object)inputClassMethodsNumber, (Object)outputClassMethodsNumber);
            for (PropertyDescriptor pd : inputPDs) {
                if ("TYPE_NAME".equals(pd.getName())) continue;
                Assert.assertTrue((String)("Field " + pd.getName() + " isn't correctly managed in the converter!"), (boolean)outputFieldNames.contains(pd.getName()));
                Method method = pd.getReadMethod();
                method.invoke(Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)1)), new Object[0]);
            }
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{mock});
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<String> retrieveClassFieldNames(Class clazz) {
        HashSet<String> returns = new HashSet<String>();
        for (Field f : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            returns.add(f.getName());
        }
        if (clazz.getSuperclass() != null) {
            returns.addAll(this.retrieveClassFieldNames(clazz.getSuperclass()));
        }
        return returns;
    }
}

