/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.kogito.client.commands;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.appformer.kogito.bridge.client.stateControl.interop.StateControl;
import org.appformer.kogito.bridge.client.stateControl.interop.StateControlCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioCommandRegistryManager;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.kogito.client.commands.ScenarioSimulationKogitoStateControlManager;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioSimulationKogitoStateControlManagerTest {
    @Mock
    private ScenarioSimulationContext scenarioSimulationContextMock;
    @Mock
    private ScenarioCommandRegistryManager scenarioCommandRegistryManagerMock;
    @Captor
    private ArgumentCaptor<StateControlCommand> stateControlUndoCommandCaptor;
    @Captor
    private ArgumentCaptor<StateControlCommand> stateControlRedoCommandCaptor;
    private ScenarioSimulationKogitoStateControlManager scenarioSimulationKogitoStateControlManagerSpy;
    private boolean envelopeAvailableBoolean;
    private StateControl stateControlSpy;

    @Before
    public void setup() {
        this.stateControlSpy = (StateControl)Mockito.spy((Object)new StateControl());
        this.envelopeAvailableBoolean = true;
        this.scenarioSimulationKogitoStateControlManagerSpy = (ScenarioSimulationKogitoStateControlManager)Mockito.spy((Object)new ScenarioSimulationKogitoStateControlManager(){
            {
                this.envelopeAvailableSupplier = () -> ScenarioSimulationKogitoStateControlManagerTest.this.envelopeAvailableBoolean;
                this.stateControlSupplier = () -> ScenarioSimulationKogitoStateControlManagerTest.this.stateControlSpy;
            }
        });
    }

    @Test
    public void initialize_EnvelopeAvailable() {
        this.scenarioSimulationKogitoStateControlManagerSpy.initialize(this.scenarioCommandRegistryManagerMock, this.scenarioSimulationContextMock);
        ((StateControl)Mockito.verify((Object)this.stateControlSpy, (VerificationMode)Mockito.times((int)1))).setUndoCommand((StateControlCommand)this.stateControlUndoCommandCaptor.capture());
        ((StateControl)Mockito.verify((Object)this.stateControlSpy, (VerificationMode)Mockito.times((int)1))).setRedoCommand((StateControlCommand)this.stateControlRedoCommandCaptor.capture());
        ((StateControlCommand)this.stateControlUndoCommandCaptor.getValue()).execute();
        ((ScenarioCommandRegistryManager)Mockito.verify((Object)this.scenarioCommandRegistryManagerMock, (VerificationMode)Mockito.times((int)1))).undo((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextMock));
        ((StateControlCommand)this.stateControlRedoCommandCaptor.getValue()).execute();
        ((ScenarioCommandRegistryManager)Mockito.verify((Object)this.scenarioCommandRegistryManagerMock, (VerificationMode)Mockito.times((int)1))).redo((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextMock));
    }

    @Test
    public void initialize_EnvelopeNotAvailable() {
        this.envelopeAvailableBoolean = false;
        this.scenarioSimulationKogitoStateControlManagerSpy.initialize(this.scenarioCommandRegistryManagerMock, this.scenarioSimulationContextMock);
        ((StateControl)Mockito.verify((Object)this.stateControlSpy, (VerificationMode)Mockito.never())).setUndoCommand((StateControlCommand)Matchers.any());
        ((StateControl)Mockito.verify((Object)this.stateControlSpy, (VerificationMode)Mockito.never())).setRedoCommand((StateControlCommand)Matchers.any());
    }
}

