package org.drools.workbench.screens.factmodel.type;

import javax.enterprise.context.ApplicationScoped;

import org.uberfire.backend.vfs.Path;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class FactModelResourceTypeDefinition implements ResourceTypeDefinition {

    @Override
    public String getShortName() {
        return "fact model";
    }

    @Override
    public String getDescription() {
        return "Fact Model definition";
    }

    @Override
    public String getPrefix() {
        return "";
    }

    @Override
    public String getSuffix() {
        return "model.drl";
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public String getSimpleWildcardPattern() {
        return "*." + getSuffix();
    }

    @Override
    public boolean accept( final Path path ) {
        return path.getFileName().endsWith( "." + getSuffix() );
    }
}
