/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.core.impl;

import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.impl.AbstractHasAnnotations;
import org.kie.workbench.common.services.datamodeller.core.impl.PropertyTypeFactoryImpl;

public class ObjectPropertyImpl
extends AbstractHasAnnotations
implements ObjectProperty {
    private String name;
    private String className;
    private String bag;
    private boolean multiple;
    private static final String DEFAULT_PROPERTY_BAG = "java.util.List";

    public ObjectPropertyImpl(String name, String className, boolean multiple) {
        this.name = name;
        this.className = className;
        this.bag = DEFAULT_PROPERTY_BAG;
        this.multiple = multiple;
    }

    public ObjectPropertyImpl(String name, String className, boolean multiple, String bag) {
        this.name = name;
        this.className = className;
        this.multiple = multiple;
        this.bag = bag;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public String getBag() {
        return this.bag;
    }

    @Override
    public void setBag(String bag) {
        this.bag = bag;
    }

    @Override
    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
        if (!multiple) {
            this.setBag(null);
        }
    }

    @Override
    public boolean isArray() {
        return this.getClassName() != null && this.className.endsWith("[]");
    }

    @Override
    public boolean isMultiple() {
        return this.multiple;
    }

    @Override
    public boolean isBaseType() {
        return PropertyTypeFactoryImpl.getInstance().isBasePropertyType(this.getClassName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

