/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.codegen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationContext;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationTools;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerationEngine {
    private static final Logger logger = LoggerFactory.getLogger(GenerationEngine.class);
    private static GenerationEngine singleton;
    private VelocityEngine velocityEngine = new VelocityEngine();
    private static boolean inited;

    public static GenerationEngine getInstance() throws Exception {
        if (singleton == null) {
            singleton = new GenerationEngine();
            singleton.init();
        }
        return singleton;
    }

    private void init() throws Exception {
        if (!inited) {
            Properties properties = new Properties();
            properties.setProperty("resource.loader", "class");
            properties.setProperty("class.resource.loader.description", "Velocity Classpath Resource Loader");
            properties.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            properties.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.JdkLogChute");
            this.velocityEngine.init(properties);
            inited = true;
        }
    }

    public void generate(GenerationContext generationContext) throws Exception {
        VelocityContext context = this.buildContext(generationContext);
        String templatesPath = generationContext.getTemplatesPath();
        String initialTemplate = generationContext.getInitialTemplate();
        if (logger.isDebugEnabled()) {
            logger.debug("Starting code generation with templatesPath: " + templatesPath + ", initialTemplate: " + initialTemplate);
        }
        String templatePath = this.getFullVelocityPath(templatesPath, initialTemplate);
        if (logger.isDebugEnabled()) {
            logger.debug("Initial templatePath: " + templatePath);
        }
        StringWriter writer = new StringWriter();
        Template t = this.velocityEngine.getTemplate(templatePath);
        t.merge((Context)context, (Writer)writer);
    }

    private VelocityContext buildContext(GenerationContext generationContext) {
        VelocityContext context = new VelocityContext();
        context.put("engine", (Object)this);
        context.put("context", (Object)generationContext);
        context.put("dataModel", (Object)generationContext.getDataModel());
        context.put("nameTool", (Object)new GenerationTools());
        generationContext.setVelocityContext(context);
        return context;
    }

    public void generateAsset(GenerationContext generationContext, String template, String filePath) throws Exception {
        String templatePath = this.getFullVelocityPath(generationContext.getTemplatesPath(), template);
        VelocityContext context = this.buildContext(generationContext);
        Template t = this.velocityEngine.getTemplate(templatePath);
        StringWriter writer = new StringWriter();
        generationContext.setCurrentOutput(writer);
        t.merge((Context)context, (Writer)writer);
        if (generationContext.getOutputPath() != null) {
            File fout = new File(generationContext.getOutputPath(), filePath);
            fout.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(fout, false);
            IOUtils.write((String)writer.toString(), (OutputStream)fos);
        }
        if (generationContext.getGenerationListener() != null) {
            generationContext.getGenerationListener().assetGenerated(filePath, writer.toString());
        }
    }

    public void generateConstructors(GenerationContext generationContext, String template) throws Exception {
        this.generateSubTemplate(generationContext, template);
    }

    public void generateAttribute(GenerationContext generationContext, ObjectProperty attribute, String template) throws Exception {
        this.generateSubTemplate(generationContext, template);
    }

    public void generateSetterGetter(GenerationContext generationContext, ObjectProperty attribute, String template) throws Exception {
        this.generateSubTemplate(generationContext, template);
    }

    public void generateEquals(GenerationContext generationContext, String template) throws Exception {
        this.generateSubTemplate(generationContext, template);
    }

    public void generateHashCode(GenerationContext generationContext, String template) throws Exception {
        this.generateSubTemplate(generationContext, template);
    }

    public void generateTypeAnnotation(GenerationContext generationContext, Annotation annotation, String template) throws Exception {
        this.generateSubTemplate(generationContext, template);
    }

    public void generateFieldAnnotation(GenerationContext generationContext, Annotation annotation, String template) throws Exception {
        this.generateSubTemplate(generationContext, template);
    }

    public void generateSubTemplate(GenerationContext generationContext, String template) throws Exception {
        String templatePath = null;
        try {
            templatePath = this.getFullVelocityPath(generationContext.getTemplatesPath(), template);
            Template t = this.velocityEngine.getTemplate(templatePath);
            t.merge((Context)generationContext.getVelocityContext(), generationContext.getCurrentOutput());
        }
        catch (Exception e) {
            logger.error("An error was produced during template generation: template: " + template + ", templatePath: " + templatePath, (Throwable)e);
        }
    }

    private String getFullVelocityPath(String templatesPath, String template) {
        return "/" + templatesPath + "/" + template + ".vm";
    }

    static {
        inited = false;
    }
}

