/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.source;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.java.nio.file.Path;
import org.kie.workbench.common.services.backend.source.SourceService;
import org.kie.workbench.common.services.backend.source.SourceServices;

@Service
@ApplicationScoped
public class SourceServicesImpl
implements SourceServices {
    private Set<SourceService> sourceServices = new HashSet<SourceService>();

    public SourceServicesImpl() {
    }

    @Inject
    public SourceServicesImpl(@Any Instance<SourceService> sourceServiceList) {
        for (SourceService sourceService : sourceServiceList) {
            this.sourceServices.add(sourceService);
        }
    }

    public boolean hasServiceFor(Path path) {
        try {
            SourceService sourceService = this.getMatchingSourceService(path);
            return sourceService != null;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public SourceService getServiceFor(Path path) {
        try {
            SourceService sourceService = this.getMatchingSourceService(path);
            if (sourceService == null) {
                throw new IllegalArgumentException("No SourceService found for '" + path + "'.");
            }
            return sourceService;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private SourceService getMatchingSourceService(Path path) {
        ArrayList<SourceService> matchingServices = new ArrayList<SourceService>();
        for (SourceService service : this.sourceServices) {
            if (!service.accepts(path)) continue;
            matchingServices.add(service);
        }
        if (matchingServices.isEmpty()) {
            return null;
        }
        SourceService specificMatchingService = null;
        for (SourceService service : matchingServices) {
            if (specificMatchingService == null) {
                specificMatchingService = service;
                continue;
            }
            if (service.getPattern().length() <= specificMatchingService.getPattern().length()) continue;
            specificMatchingService = service;
        }
        return specificMatchingService;
    }
}

