/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.builder;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.workbench.models.commons.shared.imports.Import;
import org.drools.workbench.models.commons.shared.imports.Imports;
import org.guvnor.common.services.backend.file.DotFileFilter;
import org.guvnor.common.services.backend.file.JavaFileFilter;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.model.TypeSource;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.project.service.ProjectService;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.runtime.KieContainer;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.validation.PortablePreconditions;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.scanner.KieModuleMetaData;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.workbench.events.ChangeType;
import org.uberfire.workbench.events.ResourceChange;

public class Builder {
    private static final String RESOURCE_PATH = "src/main/resources";
    private static final String ERROR_CLASS_NOT_FOUND = "Class not found";
    private KieBuilder kieBuilder;
    private final KieServices kieServices;
    private final KieFileSystem kieFileSystem;
    private final Path moduleDirectory;
    private final Paths paths;
    private final String artifactId;
    private final IOService ioService;
    private final ProjectService projectService;
    private final DirectoryStream.Filter<Path> filter;
    private final DirectoryStream.Filter<Path> javaFilter = new JavaFileFilter();
    private final String projectPrefix;
    private Map<String, org.uberfire.backend.vfs.Path> handles = new HashMap<String, org.uberfire.backend.vfs.Path>();
    private Set<String> projectJavaTypes = new HashSet<String>();
    private KieContainer kieContainer;

    public Builder(Path moduleDirectory, String artifactId, Paths paths, IOService ioService, ProjectService projectService) {
        this(moduleDirectory, artifactId, paths, ioService, projectService, (DirectoryStream.Filter<Path>)new DotFileFilter());
    }

    public Builder(Path moduleDirectory, String artifactId, Paths paths, IOService ioService, ProjectService projectService, DirectoryStream.Filter<Path> filter) {
        this.moduleDirectory = moduleDirectory;
        this.artifactId = artifactId;
        this.paths = paths;
        this.ioService = ioService;
        this.projectService = projectService;
        this.filter = filter;
        this.projectPrefix = moduleDirectory.toUri().toString();
        this.kieServices = KieServices.Factory.get();
        this.kieFileSystem = this.kieServices.newKieFileSystem();
        DirectoryStream directoryStream = Files.newDirectoryStream((Path)moduleDirectory);
        this.visitPaths((DirectoryStream<Path>)directoryStream);
    }

    public BuildResults build() {
        this.kieBuilder = this.kieServices.newKieBuilder(this.kieFileSystem);
        Results kieResults = this.kieBuilder.buildAll().getResults();
        BuildResults results = this.convertMessages(kieResults);
        if (!results.getMessages().isEmpty()) {
            return results;
        }
        this.kieContainer = this.kieServices.newKieContainer(this.kieBuilder.getKieModule().getReleaseId());
        Path nioExternalImportsPath = this.moduleDirectory.resolve("project.imports");
        if (Files.exists((Path)nioExternalImportsPath, (LinkOption[])new LinkOption[0])) {
            org.uberfire.backend.vfs.Path externalImportsPath = this.paths.convert(nioExternalImportsPath);
            ProjectImports projectImports = (ProjectImports)this.projectService.load(externalImportsPath);
            Imports imports = projectImports.getImports();
            for (Import item : imports.getImports()) {
                try {
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(item.getType());
                }
                catch (ClassNotFoundException cnfe) {
                    results.addBuildMessage(this.makeMessage(ERROR_CLASS_NOT_FOUND, cnfe));
                }
            }
        }
        return results;
    }

    public IncrementalBuildResults addResource(Path resource) {
        PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
        if (!Files.isRegularFile((Path)resource, (LinkOption[])new LinkOption[0])) {
            return new IncrementalBuildResults();
        }
        if (!this.isBuilt()) {
            throw new IllegalStateException("A full build needs to be performed before any incremental operations.");
        }
        String destinationPath = resource.toUri().toString().substring(this.projectPrefix.length() + 1);
        InputStream is = this.ioService.newInputStream(resource, new OpenOption[0]);
        BufferedInputStream bis = new BufferedInputStream(is);
        this.kieFileSystem.write(destinationPath, KieServices.Factory.get().getResources().newInputStreamResource((InputStream)bis));
        this.addJavaClass(resource);
        this.handles.put(destinationPath, this.paths.convert(resource));
        IncrementalResults incrementalResults = ((InternalKieBuilder)this.kieBuilder).createFileSet(new String[]{destinationPath}).build();
        IncrementalBuildResults results = this.convertMessages(incrementalResults);
        for (Message message : incrementalResults.getRemovedMessages()) {
            this.handles.remove("src/main/resources/" + message.getPath());
        }
        return results;
    }

    public IncrementalBuildResults deleteResource(Path resource) {
        PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
        if (!Files.isRegularFile((Path)resource, (LinkOption[])new LinkOption[0])) {
            return new IncrementalBuildResults();
        }
        if (!this.isBuilt()) {
            throw new IllegalStateException("A full build needs to be performed before any incremental operations.");
        }
        String destinationPath = resource.toUri().toString().substring(this.projectPrefix.length() + 1);
        this.kieFileSystem.delete(new String[]{destinationPath});
        this.removeJavaClass(resource);
        IncrementalResults incrementalResults = ((InternalKieBuilder)this.kieBuilder).createFileSet(new String[]{destinationPath}).build();
        IncrementalBuildResults results = this.convertMessages(incrementalResults);
        for (Message message : incrementalResults.getRemovedMessages()) {
            this.handles.remove("src/main/resources/" + message.getPath());
        }
        return results;
    }

    public IncrementalBuildResults updateResource(Path resource) {
        return this.addResource(resource);
    }

    public IncrementalBuildResults applyBatchResourceChanges(Set<ResourceChange> changes) {
        PortablePreconditions.checkNotNull((String)"changes", changes);
        if (!this.isBuilt()) {
            throw new IllegalStateException("A full build needs to be performed before any incremental operations.");
        }
        ArrayList changedFilesKieBuilderPaths = new ArrayList();
        for (ResourceChange change : changes) {
            ChangeType type = change.getType();
            Path resource = this.paths.convert(change.getPath());
            if (!Files.isRegularFile((Path)resource, (LinkOption[])new LinkOption[0])) continue;
            PortablePreconditions.checkNotNull((String)"type", (Object)type);
            PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
            String destinationPath = resource.toUri().toString().substring(this.projectPrefix.length() + 1);
            switch (type) {
                case ADD: 
                case UPDATE: {
                    InputStream is = this.ioService.newInputStream(resource, new OpenOption[0]);
                    BufferedInputStream bis = new BufferedInputStream(is);
                    this.kieFileSystem.write(destinationPath, KieServices.Factory.get().getResources().newInputStreamResource((InputStream)bis));
                    this.addJavaClass(resource);
                    this.handles.put(destinationPath, change.getPath());
                    break;
                }
                case DELETE: {
                    this.kieFileSystem.delete(new String[]{destinationPath});
                    this.removeJavaClass(resource);
                }
            }
        }
        String[] kieBuilderPaths = new String[changedFilesKieBuilderPaths.size()];
        changedFilesKieBuilderPaths.toArray(kieBuilderPaths);
        IncrementalResults incrementalResults = ((InternalKieBuilder)this.kieBuilder).createFileSet(kieBuilderPaths).build();
        IncrementalBuildResults results = this.convertMessages(incrementalResults);
        for (Message message : incrementalResults.getRemovedMessages()) {
            this.handles.remove("src/main/resources/" + message.getPath());
        }
        return results;
    }

    public KieModule getKieModule() {
        return this.kieBuilder.getKieModule();
    }

    public KieModule getKieModuleIgnoringErrors() {
        return ((InternalKieBuilder)this.kieBuilder).getKieModuleIgnoringErrors();
    }

    public KieContainer getKieContainer() {
        if (!this.isBuilt()) {
            this.build();
        }
        return this.kieContainer;
    }

    public boolean isBuilt() {
        return this.kieBuilder != null;
    }

    private void visitPaths(DirectoryStream<Path> directoryStream) {
        for (Path path : directoryStream) {
            if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
                this.visitPaths((DirectoryStream<Path>)Files.newDirectoryStream((Path)path));
                continue;
            }
            if (!this.filter.accept((Object)path)) continue;
            String destinationPath = path.toUri().toString().substring(this.projectPrefix.length() + 1);
            InputStream is = this.ioService.newInputStream(path, new OpenOption[0]);
            BufferedInputStream bis = new BufferedInputStream(is);
            this.kieFileSystem.write(destinationPath, KieServices.Factory.get().getResources().newInputStreamResource((InputStream)bis));
            this.addJavaClass(path);
            this.handles.put(destinationPath, this.paths.convert(path));
        }
    }

    private BuildResults convertMessages(Results kieBuildResults) {
        BuildResults results = new BuildResults();
        results.setArtifactID(this.artifactId);
        for (Message message : kieBuildResults.getMessages()) {
            results.addBuildMessage(this.convertMessage(message));
        }
        return results;
    }

    private IncrementalBuildResults convertMessages(IncrementalResults kieIncrementalResults) {
        IncrementalBuildResults results = new IncrementalBuildResults();
        results.setArtifactID(this.artifactId);
        for (Message message : kieIncrementalResults.getAddedMessages()) {
            results.addAddedMessage(this.convertMessage(message));
        }
        for (Message message : kieIncrementalResults.getRemovedMessages()) {
            results.addRemovedMessage(this.convertMessage(message));
        }
        return results;
    }

    private BuildMessage convertMessage(Message message) {
        BuildMessage m = new BuildMessage();
        switch (message.getLevel()) {
            case ERROR: {
                m.setLevel(BuildMessage.Level.ERROR);
                break;
            }
            case WARNING: {
                m.setLevel(BuildMessage.Level.WARNING);
                break;
            }
            case INFO: {
                m.setLevel(BuildMessage.Level.INFO);
            }
        }
        m.setId(message.getId());
        m.setArtifactID(this.artifactId);
        m.setLine(message.getLine());
        if (message.getPath() != null && !message.getPath().isEmpty()) {
            m.setPath(this.handles.get("src/main/resources/" + message.getPath()));
        }
        m.setColumn(message.getColumn());
        m.setText(message.getText());
        return m;
    }

    private BuildMessage makeMessage(String prefix, Exception e) {
        BuildMessage buildMessage = new BuildMessage();
        buildMessage.setLevel(BuildMessage.Level.ERROR);
        buildMessage.setText(prefix + ": " + e.getMessage());
        return buildMessage;
    }

    private void addJavaClass(Path path) {
        if (!this.javaFilter.accept((Object)path)) {
            return;
        }
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(path);
        if (fullyQualifiedClassName != null) {
            this.projectJavaTypes.add(fullyQualifiedClassName);
        }
    }

    private void removeJavaClass(Path path) {
        if (!this.javaFilter.accept((Object)path)) {
            return;
        }
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(path);
        if (fullyQualifiedClassName != null) {
            this.projectJavaTypes.remove(fullyQualifiedClassName);
        }
    }

    private String getFullyQualifiedClassName(Path path) {
        Package pkg = this.projectService.resolvePackage(this.paths.convert(path, false));
        String packageName = pkg.getPackageName();
        if (packageName == null) {
            return null;
        }
        String className = path.getFileName().toString().replace(".java", "");
        return packageName.equals("") ? className : packageName + "." + className;
    }

    public TypeSource getClassSource(KieModuleMetaData metaData, Class<?> clazz) {
        if (metaData.getTypeMetaInfo(clazz).isDeclaredType()) {
            return TypeSource.DECLARED;
        }
        String fullyQualifiedClassName = clazz.getName();
        int innerClassIdentifierIndex = fullyQualifiedClassName.indexOf("$");
        if (innerClassIdentifierIndex > 0) {
            fullyQualifiedClassName = fullyQualifiedClassName.substring(0, innerClassIdentifierIndex);
        }
        if (this.projectJavaTypes.contains(fullyQualifiedClassName)) {
            return TypeSource.JAVA_PROJECT;
        }
        return TypeSource.JAVA_DEPENDENCY;
    }

    private boolean isRegularFile(org.uberfire.backend.vfs.Path resource) {
        Path p = this.paths.convert(resource);
        return Files.isRegularFile((Path)p, (LinkOption[])new LinkOption[0]);
    }
}

