/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.builder.Builder;
import org.guvnor.common.services.builder.LRUBuilderCache;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.DeployResult;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.m2repo.backend.server.ExtendedM2RepoService;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.workbench.events.ResourceChange;

@Service
@ApplicationScoped
public class BuildServiceImpl
implements BuildService {
    private Paths paths;
    private Event<BuildResults> buildResultsEvent;
    private Event<IncrementalBuildResults> incrementalBuildResultsEvent;
    private POMService pomService;
    private ExtendedM2RepoService m2RepoService;
    private ProjectService projectService;
    private LRUBuilderCache cache;
    private Event<DeployResult> deployResultEvent;

    public BuildServiceImpl() {
    }

    @Inject
    public BuildServiceImpl(Paths paths, POMService pomService, ExtendedM2RepoService m2RepoService, Event<BuildResults> buildResultsEvent, Event<IncrementalBuildResults> incrementalBuildResultsEvent, ProjectService projectService, LRUBuilderCache cache, Event<DeployResult> deployResultEvent) {
        this.paths = paths;
        this.pomService = pomService;
        this.m2RepoService = m2RepoService;
        this.buildResultsEvent = buildResultsEvent;
        this.incrementalBuildResultsEvent = incrementalBuildResultsEvent;
        this.projectService = projectService;
        this.cache = cache;
        this.deployResultEvent = deployResultEvent;
    }

    public BuildResults build(Project project) {
        try {
            BuildResults results = this.doBuild(project);
            this.buildResultsEvent.fire((Object)results);
            return results;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public DeployResult buildAndDeploy(Project project) {
        try {
            BuildResults results = this.doBuild(project);
            this.buildResultsEvent.fire((Object)results);
            if (results.getMessages().isEmpty()) {
                Builder builder = this.cache.assertBuilder(project);
                POM pom = (POM)this.pomService.load(project.getPomXMLPath());
                InternalKieModule kieModule = (InternalKieModule)builder.getKieModule();
                ByteArrayInputStream input = new ByteArrayInputStream(kieModule.getBytes());
                this.m2RepoService.deployJar((InputStream)input, pom.getGav());
                DeployResult deployResult = new DeployResult(pom.getGav().getGroupId(), pom.getGav().getArtifactId(), pom.getGav().getVersion());
                deployResult.setBuildResults(results);
                this.deployResultEvent.fire((Object)deployResult);
                return deployResult;
            }
            DeployResult deployResult = new DeployResult();
            deployResult.setBuildResults(results);
            this.deployResultEvent.fire((Object)deployResult);
            return deployResult;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private BuildResults doBuild(Project project) {
        Builder builder = this.cache.assertBuilder(project);
        BuildResults results = builder.build();
        return results;
    }

    public void addPackageResource(Path resource) {
        try {
            Project project = this.projectService.resolveProject(resource);
            if (project == null) {
                return;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                this.build(project);
            }
            IncrementalBuildResults results = builder.addResource(this.paths.convert(resource));
            this.incrementalBuildResultsEvent.fire((Object)results);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void deletePackageResource(Path resource) {
        try {
            Project project = this.projectService.resolveProject(resource);
            if (project == null) {
                return;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                this.build(project);
            }
            IncrementalBuildResults results = builder.deleteResource(this.paths.convert(resource));
            this.incrementalBuildResultsEvent.fire((Object)results);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void updatePackageResource(Path resource) {
        try {
            Project project = this.projectService.resolveProject(resource);
            if (project == null) {
                return;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                this.build(project);
            }
            IncrementalBuildResults results = builder.updateResource(this.paths.convert(resource));
            this.incrementalBuildResultsEvent.fire((Object)results);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void updateProjectResource(Path resource) {
        try {
            Project project = this.projectService.resolveProject(resource);
            if (project == null) {
                return;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                this.build(project);
            }
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void applyBatchResourceChanges(Project project, Set<ResourceChange> changes) {
        try {
            if (project == null) {
                return;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                this.build(project);
            }
            IncrementalBuildResults results = builder.applyBatchResourceChanges(changes);
            this.incrementalBuildResultsEvent.fire((Object)results);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

