/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.builder;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.builder.BuildExecutorServiceFactory;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.config.AppConfigService;
import org.kie.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceChange;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@ApplicationScoped
public class BuildChangeListener {
    private static final String INCREMENTAL_BUILD_PROPERTY_NAME = "build.enable-incremental";
    private static final Logger log = LoggerFactory.getLogger(BuildChangeListener.class);
    @Inject
    private Paths paths;
    @Inject
    private ProjectService projectService;
    @Inject
    private BuildService buildService;
    @Inject
    private AppConfigService appConfigService;
    @Inject
    private BuildExecutorServiceFactory executorServiceProducer;
    private ExecutorService executor;
    private boolean isIncrementalEnabled = false;

    @PostConstruct
    private void setup() {
        this.executor = this.executorServiceProducer.getExecutorService();
        this.isIncrementalEnabled = this.isIncrementalBuildEnabled();
    }

    private boolean isIncrementalBuildEnabled() {
        String value = (String)this.appConfigService.loadPreferences().get(INCREMENTAL_BUILD_PROPERTY_NAME);
        return Boolean.parseBoolean(value);
    }

    @PreDestroy
    private void destroyExecutorService() {
        try {
            this.executor.shutdown();
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    log.error("executor did not terminate");
                }
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void addResource(@Observes ResourceAddedEvent resourceAddedEvent) {
        if (!this.isIncrementalEnabled) {
            return;
        }
        PortablePreconditions.checkNotNull((String)"resourceAddedEvent", (Object)resourceAddedEvent);
        final Path resource = resourceAddedEvent.getPath();
        log.info("Incremental build request received for: " + resource.toURI() + " (added).");
        Package pkg = this.projectService.resolvePackage(resource);
        if (pkg == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    log.info("Incremental build request being processed: " + resource.toURI() + " (added).");
                    BuildChangeListener.this.buildService.addPackageResource(resource);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public void deleteResource(@Observes ResourceDeletedEvent resourceDeletedEvent) {
        if (!this.isIncrementalEnabled) {
            return;
        }
        PortablePreconditions.checkNotNull((String)"resourceDeletedEvent", (Object)resourceDeletedEvent);
        final Path resource = resourceDeletedEvent.getPath();
        log.info("Incremental build request received for: " + resource.toURI() + " (deleted).");
        Package pkg = this.projectService.resolvePackage(resource);
        if (pkg == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    log.info("Incremental build request being processed: " + resource.toURI() + " (deleted).");
                    BuildChangeListener.this.buildService.deletePackageResource(resource);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public void updateResource(@Observes ResourceUpdatedEvent resourceUpdatedEvent) {
        if (!this.isIncrementalEnabled) {
            return;
        }
        PortablePreconditions.checkNotNull((String)"resourceUpdatedEvent", (Object)resourceUpdatedEvent);
        Path resource = resourceUpdatedEvent.getPath();
        log.info("Incremental build request received for: " + resource.toURI() + " (updated).");
        Project project = this.projectService.resolveProject(resource);
        if (project == null) {
            return;
        }
        boolean isPomFile = this.projectService.isPom(resource);
        boolean isKModuleFile = this.projectService.isKModule(resource);
        if (isPomFile || isKModuleFile) {
            this.scheduleProjectResourceUpdate(resource);
        } else {
            this.schedulePackageResourceUpdate(resource);
        }
    }

    private void scheduleProjectResourceUpdate(final Path resource) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    log.info("Incremental build request being processed: " + resource.toURI() + " (updated).");
                    BuildChangeListener.this.buildService.updateProjectResource(resource);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private void schedulePackageResourceUpdate(final Path resource) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    log.info("Incremental build request being processed: " + resource.toURI() + " (updated).");
                    BuildChangeListener.this.buildService.updatePackageResource(resource);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public void batchResourceChanges(@Observes ResourceBatchChangesEvent resourceBatchChangesEvent) {
        if (!this.isIncrementalEnabled) {
            return;
        }
        PortablePreconditions.checkNotNull((String)"resourceBatchChangesEvent", (Object)resourceBatchChangesEvent);
        log.info("Batch incremental build request received.");
        Set batch = resourceBatchChangesEvent.getBatch();
        HashMap projectBatchChanges = new HashMap();
        for (ResourceChange resourceChange : batch) {
            PortablePreconditions.checkNotNull((String)"path", (Object)resourceChange.getPath());
            Path resource = resourceChange.getPath();
            Project project = this.projectService.resolveProject(resource);
            Package pkg = this.projectService.resolvePackage(resource);
            if (project == null || pkg == null) continue;
            if (!projectBatchChanges.containsKey(project)) {
                projectBatchChanges.put(project, new HashSet());
            }
            Set projectChanges = (Set)projectBatchChanges.get(project);
            projectChanges.add(resourceChange);
            log.info("- Batch content: " + resourceChange.getPath().toURI() + " (" + resourceChange.getType().toString() + ").");
        }
        for (final Map.Entry entry : projectBatchChanges.entrySet()) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        log.info("Batch incremental build request being processed.");
                        BuildChangeListener.this.buildService.applyBatchResourceChanges((Project)entry.getKey(), (Set)entry.getValue());
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }
}

