/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.IOUtil;
import org.guvnor.common.services.project.model.GAV;
import org.kie.scanner.Aether;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.deployment.DeployRequest;
import org.sonatype.aether.deployment.DeploymentException;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.artifact.SubArtifact;

@ApplicationScoped
public class GuvnorM2Repository {
    public static final String M2_REPO_ROOT = "repository";
    public static final String REPO_ID_SNAPSHOTS = "snapshots";
    public static final String REPO_ID_RELEASES = "releases";
    private static final int BUFFER_SIZE = 1024;
    private File snapshotsRepository;
    private File releasesRepository;

    @PostConstruct
    protected void init() {
        this.setM2Repos();
    }

    private void setM2Repos() {
        this.snapshotsRepository = new File(this.getM2RepositoryRootDir() + File.separator + REPO_ID_SNAPSHOTS);
        if (!this.snapshotsRepository.exists()) {
            this.snapshotsRepository.mkdirs();
        }
        this.releasesRepository = new File(this.getM2RepositoryRootDir() + File.separator + REPO_ID_RELEASES);
        if (!this.releasesRepository.exists()) {
            this.releasesRepository.mkdirs();
        }
        Aether.DEFUALT_AETHER.getRepositories().add(this.getGuvnorM2Repository());
    }

    protected String getM2RepositoryRootDir() {
        if (!M2_REPO_ROOT.endsWith(File.separator)) {
            return M2_REPO_ROOT + File.separator;
        }
        return M2_REPO_ROOT;
    }

    public String getRepositoryURL() {
        File file = new File(this.getM2RepositoryRootDir());
        return "file://" + file.getAbsolutePath();
    }

    public void deployArtifact(InputStream inputStream, GAV gav) {
        File jarFile = new File(System.getProperty("java.io.tmpdir"), this.toFileName(gav, null, "jar"));
        try {
            if (!jarFile.exists()) {
                jarFile.getParentFile().mkdirs();
                jarFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(jarFile);
            byte[] buf = new byte[1024];
            int byteRead = 0;
            while ((byteRead = inputStream.read(buf)) != -1) {
                fos.write(buf, 0, byteRead);
            }
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String pom = GuvnorM2Repository.loadPOMFromJarInternal(new File(jarFile.getPath()));
        if (pom == null) {
            pom = this.generatePOM(gav);
            jarFile = this.appendPOMToJar(pom, jarFile.getPath(), gav);
        }
        File pomFile = new File(System.getProperty("java.io.tmpdir"), this.toFileName(gav, null, "pom"));
        try {
            if (!pomFile.exists()) {
                pomFile.getParentFile().mkdirs();
                pomFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(pomFile);
            IOUtils.write((String)pom, (OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.deployArtifact(gav, jarFile, pomFile);
    }

    public void deployArtifact(GAV gav, File jarFile, File pomfile) {
        DefaultArtifact jarArtifact = new DefaultArtifact(gav.getGroupId(), gav.getArtifactId(), "jar", gav.getVersion());
        jarArtifact = jarArtifact.setFile(jarFile);
        SubArtifact pomArtifact = new SubArtifact((Artifact)jarArtifact, "", "pom");
        pomArtifact = pomArtifact.setFile(pomfile);
        DeployRequest deployRequest = new DeployRequest();
        deployRequest.addArtifact((Artifact)jarArtifact).addArtifact((Artifact)pomArtifact).setRepository(this.getGuvnorM2Repository());
        try {
            Aether.DEFUALT_AETHER.getSystem().deploy(Aether.DEFUALT_AETHER.getSession(), deployRequest);
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
    }

    private RemoteRepository getGuvnorM2Repository() {
        File m2RepoDir = new File(M2_REPO_ROOT);
        if (!m2RepoDir.exists()) {
            return null;
        }
        try {
            String localRepositoryUrl = m2RepoDir.toURI().toURL().toExternalForm();
            return new RemoteRepository("guvnor-m2-repo", "default", localRepositoryUrl);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public boolean deleteFile(String[] fullPaths) {
        for (String fullPath : fullPaths) {
            File file = new File(M2_REPO_ROOT, fullPath);
            if (!file.exists()) continue;
            file.delete();
        }
        return true;
    }

    public Collection<File> listFiles() {
        return this.listFiles(null);
    }

    public Collection<File> listFiles(String filters) {
        String wildcard = "*.jar";
        if (filters != null) {
            wildcard = "*" + filters + "*.jar";
        }
        Collection files = FileUtils.listFiles((File)new File(M2_REPO_ROOT), (IOFileFilter)new WildcardFileFilter(wildcard, IOCase.INSENSITIVE), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        return files;
    }

    public InputStream loadFile(String path) {
        try {
            return new FileInputStream(new File(M2_REPO_ROOT, path));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getFileName(String path) {
        return new File(M2_REPO_ROOT, path).getName();
    }

    public static String loadPOMFromJar(String jarPath) {
        File zip = new File(M2_REPO_ROOT, jarPath);
        return GuvnorM2Repository.loadPOMFromJarInternal(zip);
    }

    public static String loadPOMFromJarInternal(File file) {
        try {
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (!entry.getName().startsWith("META-INF/maven") || !entry.getName().endsWith("pom.xml")) continue;
                InputStream is = zip.getInputStream(entry);
                InputStreamReader isr = new InputStreamReader(is, "UTF-8");
                StringBuilder sb = new StringBuilder();
                int c = isr.read();
                while (c != -1) {
                    sb.append((char)c);
                    c = isr.read();
                }
                return sb.toString();
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String loadPOMFromJar(InputStream jarInputStream) {
        try {
            ZipEntry entry;
            ZipInputStream zis = new ZipInputStream(jarInputStream);
            while ((entry = zis.getNextEntry()) != null) {
                if (!entry.getName().startsWith("META-INF/maven") || !entry.getName().endsWith("pom.xml")) continue;
                InputStreamReader isr = new InputStreamReader((InputStream)zis, "UTF-8");
                StringBuilder sb = new StringBuilder();
                int c = isr.read();
                while (c != -1) {
                    sb.append((char)c);
                    c = isr.read();
                }
                return sb.toString();
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public File appendPOMToJar(String pom, String jarPath, GAV gav) {
        File originalJarFile = new File(jarPath);
        File appendedJarFile = new File(jarPath + ".tmp");
        try {
            ZipEntry e;
            ZipFile war = new ZipFile(originalJarFile);
            ZipOutputStream append = new ZipOutputStream(new FileOutputStream(appendedJarFile));
            Enumeration<? extends ZipEntry> entries = war.entries();
            while (entries.hasMoreElements()) {
                e = entries.nextElement();
                append.putNextEntry(e);
                if (!e.isDirectory()) {
                    IOUtil.copy((InputStream)war.getInputStream(e), (OutputStream)append);
                }
                append.closeEntry();
            }
            e = new ZipEntry(this.getPomXmlPath(gav));
            append.putNextEntry(e);
            append.write(pom.getBytes());
            append.closeEntry();
            war.close();
            append.close();
        }
        catch (ZipException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return appendedJarFile;
    }

    protected String toURL(String repository, GAV gav, String classifier) {
        StringBuilder sb = new StringBuilder(repository);
        if (!repository.endsWith(File.separator)) {
            sb.append(File.separator);
        }
        return sb.append(gav.getGroupId().replace(".", File.separator)).append(File.separator).append(gav.getArtifactId()).append(File.separator).append(gav.getVersion()).append(File.separator).append(this.toFileName(gav, classifier, "jar")).toString();
    }

    protected String toFileName(GAV gav, String classifier, String fileType) {
        if (classifier != null) {
            return gav.getArtifactId() + "-" + gav.getVersion() + "-" + classifier + "." + this.getFileExtension(fileType);
        }
        return gav.getArtifactId() + "-" + gav.getVersion() + "." + this.getFileExtension(fileType);
    }

    private String getFileExtension(String type) {
        if (type.equalsIgnoreCase("ear")) {
            return "ear";
        }
        if (type.equalsIgnoreCase("pom")) {
            return "pom";
        }
        if (type.equalsIgnoreCase("war")) {
            return "war";
        }
        return "jar";
    }

    public String generatePOM(GAV gav) {
        Model model = new Model();
        model.setGroupId(gav.getGroupId());
        model.setArtifactId(gav.getArtifactId());
        model.setVersion(gav.getVersion());
        model.setModelVersion("4.0.0");
        StringWriter stringWriter = new StringWriter();
        try {
            new MavenXpp3Writer().write((Writer)stringWriter, model);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringWriter.toString();
    }

    public static String generatePomProperties(GAV gav) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("groupId=");
        sBuilder.append(gav.getGroupId());
        sBuilder.append("\n");
        sBuilder.append("artifactId=");
        sBuilder.append(gav.getArtifactId());
        sBuilder.append("\n");
        sBuilder.append("version=");
        sBuilder.append(gav.getVersion());
        sBuilder.append("\n");
        return sBuilder.toString();
    }

    public String getPomXmlPath(GAV gav) {
        return "META-INF/maven/" + gav.getGroupId() + "/" + gav.getArtifactId() + "/pom.xml";
    }

    public String getPomPropertiesPath(GAV gav) {
        return "META-INF/maven/" + gav.getGroupId() + "/" + gav.getArtifactId() + "/pom.properties";
    }
}

