/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.beliefsystem.defeasible;

import java.util.Arrays;
import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.beliefsystem.defeasible.DefeasibilityStatus;
import org.drools.core.beliefsystem.defeasible.DefeasibleLogicalDependency;
import org.drools.core.beliefsystem.defeasible.Defeats;
import org.drools.core.beliefsystem.jtms.JTMSBeliefSet;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.rule.Rule;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.LinkedListNode;

public class DefeasibleBeliefSet
implements BeliefSet {
    private BeliefSystem beliefSystem;
    public static final String DEFEATS = Defeats.class.getSimpleName();
    private static final FastIterator iterator = new IteratorImpl();
    private InternalFactHandle rootHandle;
    private InternalFactHandle positiveFactHandle;
    private InternalFactHandle negativeFactHandle;
    private DefeasibleLogicalDependency rootUndefeated;
    private DefeasibleLogicalDependency tailUndefeated;
    private int definitelyPosCount;
    private int definitelyNegCount;
    private int defeasiblyPosCount;
    private int defeasiblyNegCount;
    private int defeatedlyPosCount;
    private int defeatedlyNegCount;
    private static final int DEFINITELY_POS_BIT = 1;
    private static final int DEFINITELY_NEG_BIT = 2;
    private static final int DEFEASIBLY_POS_BIT = 4;
    private static final int DEFEASIBLY_NEG_BIT = 6;
    private static final int DEFEATEDLY_POS_BIT = 8;
    private static final int DEFEATEDLY_NEG_BIT = 10;
    private static final int POS_MASK = 0;
    private static final int NEG_MASK = 2;
    private int statusMask;

    public DefeasibleBeliefSet(BeliefSystem beliefSystem, InternalFactHandle rootHandle) {
        this.beliefSystem = beliefSystem;
        this.rootHandle = rootHandle;
    }

    @Override
    public BeliefSystem getBeliefSystem() {
        return null;
    }

    @Override
    public InternalFactHandle getFactHandle() {
        return this.rootHandle;
    }

    @Override
    public LinkedListNode getFirst() {
        return this.rootUndefeated;
    }

    public InternalFactHandle getPositiveFactHandle() {
        return this.positiveFactHandle;
    }

    public void setPositiveFactHandle(InternalFactHandle positiveFactHandle) {
        this.positiveFactHandle = positiveFactHandle;
    }

    public InternalFactHandle getNegativeFactHandle() {
        return this.negativeFactHandle;
    }

    public void setNegativeFactHandle(InternalFactHandle negativeFactHandle) {
        this.negativeFactHandle = negativeFactHandle;
    }

    @Override
    public void add(LinkedListNode node) {
        DefeasibleLogicalDependency newDep = (DefeasibleLogicalDependency)node;
        Rule rule = newDep.getJustifier().getRule();
        boolean wasDefeated = false;
        for (DefeasibleLogicalDependency existingDep = this.rootUndefeated; existingDep != null && !(wasDefeated = this.checkAndApplyIsDefeated(newDep, rule, existingDep)); existingDep = (DefeasibleLogicalDependency)existingDep.getNext()) {
        }
        if (!wasDefeated) {
            DefeasibleLogicalDependency stagedDeps = null;
            DefeasibleLogicalDependency existingDep = this.rootUndefeated;
            while (existingDep != null) {
                DefeasibleLogicalDependency next = (DefeasibleLogicalDependency)existingDep.getNext();
                if (this.checkAndApplyIsDefeated(existingDep, existingDep.getJustifier().getRule(), newDep)) {
                    this.removeUndefeated(existingDep);
                    if (existingDep.getRootDefeated() != null) {
                        if (stagedDeps == null) {
                            stagedDeps = existingDep.getRootDefeated();
                        } else {
                            stagedDeps.setPrevious(existingDep.getTailDefeated());
                            stagedDeps = existingDep.getRootDefeated();
                        }
                    }
                }
                existingDep = next;
            }
            this.addUndefeated(newDep);
            this.reprocessDefeated(stagedDeps);
        }
    }

    private void reprocessDefeated(DefeasibleLogicalDependency deps) {
        DefeasibleLogicalDependency dep = deps;
        while (dep != null) {
            DefeasibleLogicalDependency next = (DefeasibleLogicalDependency)dep.getNext();
            dep.nullPrevNext();
            this.add(dep);
            dep = next;
        }
    }

    @Override
    public void remove(LinkedListNode node) {
        DefeasibleLogicalDependency dep = (DefeasibleLogicalDependency)node;
        if (dep.getDefeatedBy() != null) {
            DefeasibleLogicalDependency defeater = dep.getDefeatedBy();
            defeater.removeDefeated(dep);
        } else {
            this.removeUndefeated(dep);
            if (dep.getRootDefeated() != null) {
                this.reprocessDefeated(dep.getRootDefeated());
            }
        }
    }

    private boolean checkAndApplyIsDefeated(DefeasibleLogicalDependency potentialInferior, Rule rule, DefeasibleLogicalDependency potentialSuperior) {
        if (Arrays.binarySearch(potentialSuperior.getDefeats(), rule.getName()) >= 0 || Arrays.binarySearch(potentialSuperior.getDefeats(), rule.getPackage() + "." + rule.getName()) >= 0) {
            potentialSuperior.addDefeated(potentialInferior);
            return true;
        }
        return false;
    }

    public void addUndefeated(DefeasibleLogicalDependency dep) {
        boolean pos = dep.getValue() != null && JTMSBeliefSet.MODE.POSITIVE.getId().equals(dep.getValue().toString());
        switch (dep.getStatus()) {
            case DEFINITELY: {
                if (pos) {
                    ++this.definitelyPosCount;
                    this.statusMask &= 1;
                    break;
                }
                ++this.definitelyNegCount;
                this.statusMask &= 2;
                break;
            }
            case DEFEASIBLY: {
                if (pos) {
                    ++this.defeasiblyPosCount;
                    this.statusMask &= 4;
                    break;
                }
                ++this.defeasiblyNegCount;
                this.statusMask &= 6;
                break;
            }
            case DEFEATEDLY: {
                if (pos) {
                    ++this.defeatedlyPosCount;
                    this.statusMask &= 8;
                    break;
                }
                ++this.defeatedlyNegCount;
                this.statusMask &= 0xA;
                break;
            }
            case UNDECIDABLY: {
                throw new IllegalStateException("Individual logical dependencies cannot be undecidably");
            }
        }
        if (this.rootUndefeated == null) {
            this.rootUndefeated = dep;
            this.tailUndefeated = dep;
        } else if (dep.getStatus() == DefeasibilityStatus.DEFINITELY) {
            this.rootUndefeated.setPrevious(dep);
            dep.setNext(this.rootUndefeated);
            this.rootUndefeated = dep;
        } else {
            this.tailUndefeated.setNext(dep);
            dep.setPrevious(this.rootUndefeated);
            this.tailUndefeated = dep;
        }
    }

    public void removeUndefeated(DefeasibleLogicalDependency dep) {
        boolean pos = dep.getValue() != null && JTMSBeliefSet.MODE.POSITIVE.getId().equals(dep.getValue().toString());
        switch (dep.getStatus()) {
            case DEFINITELY: {
                if (pos) {
                    --this.definitelyPosCount;
                    if (this.definitelyPosCount != 0) break;
                    this.statusMask ^= 1;
                    break;
                }
                --this.definitelyNegCount;
                if (this.definitelyNegCount != 0) break;
                this.statusMask ^= 2;
                break;
            }
            case DEFEASIBLY: {
                if (pos) {
                    --this.defeasiblyPosCount;
                    if (this.defeasiblyPosCount != 0) break;
                    this.statusMask ^= 4;
                    break;
                }
                --this.defeasiblyNegCount;
                if (this.defeasiblyNegCount != 0) break;
                this.statusMask ^= 6;
                break;
            }
            case DEFEATEDLY: {
                if (pos) {
                    --this.defeatedlyPosCount;
                    if (this.defeatedlyPosCount != 0) break;
                    this.statusMask ^= 8;
                    break;
                }
                --this.defeatedlyNegCount;
                if (this.defeatedlyNegCount != 0) break;
                this.statusMask ^= 0xA;
                break;
            }
            case UNDECIDABLY: {
                throw new IllegalStateException("Individual logical dependencies cannot be undecidably");
            }
        }
        if (this.rootUndefeated == dep) {
            this.removeFirst();
        } else if (this.tailUndefeated == dep) {
            this.removeLast();
        } else {
            ((LogicalDependency)dep.getPrevious()).setNext(dep.getNext());
            ((LogicalDependency)dep.getNext()).setPrevious(dep.getPrevious());
            dep.nullPrevNext();
        }
    }

    public DefeasibleLogicalDependency removeFirst() {
        if (this.rootUndefeated == null) {
            return null;
        }
        DefeasibleLogicalDependency node = this.rootUndefeated;
        this.rootUndefeated = (DefeasibleLogicalDependency)node.getNext();
        node.setNext(null);
        if (this.rootUndefeated != null) {
            this.rootUndefeated.setPrevious(null);
        } else {
            this.tailUndefeated = null;
        }
        return node;
    }

    public DefeasibleLogicalDependency removeLast() {
        if (this.tailUndefeated == null) {
            return null;
        }
        DefeasibleLogicalDependency node = this.tailUndefeated;
        this.tailUndefeated = (DefeasibleLogicalDependency)node.getPrevious();
        node.setPrevious(null);
        if (this.tailUndefeated != null) {
            this.tailUndefeated.setNext(null);
        } else {
            this.rootUndefeated = this.tailUndefeated;
        }
        return node;
    }

    public DefeasibleLogicalDependency getRootUndefeated() {
        return this.rootUndefeated;
    }

    public DefeasibleLogicalDependency getTailUnDefeated() {
        return this.tailUndefeated;
    }

    @Override
    public boolean isEmpty() {
        return this.rootUndefeated == null;
    }

    @Override
    public int size() {
        return this.definitelyPosCount + this.definitelyNegCount + this.defeasiblyPosCount + this.defeasiblyNegCount + this.defeatedlyPosCount + this.defeatedlyNegCount;
    }

    @Override
    public void cancel(PropagationContext propagationContext) {
        FastIterator it = this.iterator();
        DefeasibleLogicalDependency entry = (DefeasibleLogicalDependency)this.getFirst();
        while (entry != this.tailUndefeated) {
            DefeasibleLogicalDependency temp = (DefeasibleLogicalDependency)it.next(entry);
            LogicalDependency node = (LogicalDependency)entry.getObject();
            node.getJustifier().getLogicalDependencies().remove(node);
            this.remove(entry);
            entry = temp;
        }
        LinkedListEntry last = (LinkedListEntry)this.getFirst();
        LogicalDependency node = (LogicalDependency)last.getObject();
        node.getJustifier().getLogicalDependencies().remove(node);
        this.positiveFactHandle = null;
        this.negativeFactHandle = null;
    }

    @Override
    public void clear(PropagationContext propagationContext) {
    }

    @Override
    public void setWorkingMemoryAction(WorkingMemoryAction wmAction) {
    }

    public boolean isDefinitelyPosProveable() {
        return (this.statusMask & 1) != 0;
    }

    public boolean isDefinitelyNegProveable() {
        return (this.statusMask & 2) != 0;
    }

    public boolean isDefeasiblyPosProveable() {
        return (this.statusMask & 4) != 0;
    }

    public boolean isDefeasiblyNegProveable() {
        return (this.statusMask & 6) != 0;
    }

    public boolean isDefeatedlyPosProveable() {
        return (this.statusMask & 8) != 0;
    }

    public boolean isDefeatedlyNegProveable() {
        return (this.statusMask & 0xA) != 0;
    }

    public DefeasibilityStatus getStatus() {
        if (this.isDefinitelyPosProveable() && !this.isDefinitelyNegProveable()) {
            return DefeasibilityStatus.DEFINITELY;
        }
        if (!this.isDefinitelyPosProveable() && this.isDefinitelyNegProveable()) {
            return DefeasibilityStatus.DEFINITELY;
        }
        if (this.isDefinitelyPosProveable() && this.isDefinitelyNegProveable()) {
            return DefeasibilityStatus.UNDECIDABLY;
        }
        if (this.isDefeasiblyPosProveable() && !this.isDefeasiblyNegProveable() && !this.isDefeatedlyNegProveable()) {
            return DefeasibilityStatus.DEFEASIBLY;
        }
        if (!this.isDefeasiblyPosProveable() && !this.isDefeatedlyPosProveable() && this.isDefeasiblyNegProveable()) {
            return DefeasibilityStatus.DEFEASIBLY;
        }
        return DefeasibilityStatus.UNDECIDABLY;
    }

    public boolean isNegated() {
        return (this.statusMask & 0) == 0 && (this.statusMask & 2) != 0;
    }

    public boolean isPositive() {
        return (this.statusMask & 0) != 0 && (this.statusMask & 2) == 0;
    }

    public boolean isConflicting() {
        return this.getStatus() == DefeasibilityStatus.UNDECIDABLY;
    }

    @Override
    public FastIterator iterator() {
        return this.iterator();
    }

    private static class IteratorImpl
    implements FastIterator {
        private IteratorImpl() {
        }

        @Override
        public Entry next(Entry object) {
            DefeasibleLogicalDependency dep = (DefeasibleLogicalDependency)object;
            if (dep.getRootDefeated() != null) {
                return dep.getRootDefeated();
            }
            if (dep.getNext() != null) {
                return dep.getNext();
            }
            if (dep.getDefeatedBy() != null) {
                return dep.getDefeatedBy().getNext();
            }
            return null;
        }

        @Override
        public boolean isFullIterator() {
            return true;
        }
    }
}

