/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scorecards.drl;

import java.io.Serializable;
import java.util.List;
import org.dmg.pmml.pmml_4_1.descr.Attribute;
import org.dmg.pmml.pmml_4_1.descr.Characteristic;
import org.dmg.pmml.pmml_4_1.descr.Extension;
import org.dmg.pmml.pmml_4_1.descr.MiningField;
import org.dmg.pmml.pmml_4_1.descr.MiningSchema;
import org.dmg.pmml.pmml_4_1.descr.Output;
import org.dmg.pmml.pmml_4_1.descr.OutputField;
import org.dmg.pmml.pmml_4_1.descr.PMML;
import org.dmg.pmml.pmml_4_1.descr.Scorecard;
import org.drools.scorecards.drl.AbstractDRLEmitter;
import org.drools.scorecards.pmml.ScorecardPMMLUtils;
import org.drools.template.model.Condition;
import org.drools.template.model.Consequence;
import org.drools.template.model.Package;
import org.drools.template.model.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalModelDRLEmitter
extends AbstractDRLEmitter {
    @Override
    protected void addDeclaredTypeContents(PMML pmmlDocument, StringBuilder stringBuilder, Scorecard scorecard) {
    }

    @Override
    protected void internalEmitDRL(PMML pmml, List<Rule> ruleList, Package aPackage) {
    }

    @Override
    protected void addLHSConditions(Rule rule, PMML pmmlDocument, Scorecard scorecard, Characteristic c, Attribute scoreAttribute) {
        Extension extension = null;
        for (Serializable obj : scorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
            if (!(obj instanceof MiningSchema)) continue;
            MiningSchema miningSchema = (MiningSchema)obj;
            String fieldName = ScorecardPMMLUtils.extractFieldNameFromCharacteristic(c);
            for (MiningField miningField : miningSchema.getMiningFields()) {
                if (!miningField.getName().equalsIgnoreCase(fieldName) || miningField.getExtensions().size() <= 0) continue;
                extension = miningField.getExtensions().get(0);
            }
        }
        if (extension != null) {
            Condition condition = new Condition();
            StringBuilder stringBuilder = new StringBuilder("$");
            stringBuilder.append(c.getName()).append(" : ").append(extension.getValue());
            this.createFieldRestriction(pmmlDocument, c, scoreAttribute, stringBuilder);
            condition.setSnippet(stringBuilder.toString());
            rule.addCondition(condition);
        }
    }

    @Override
    protected void addAdditionalReasonCodeConsequence(Rule rule, Scorecard scorecard) {
        if (!scorecard.isUseReasonCodes()) {
            return;
        }
        String externalClassName = null;
        String reasonCodesField = null;
        String fieldName = null;
        for (Serializable obj : scorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
            if (!(obj instanceof Output)) continue;
            Output output = (Output)obj;
            List<OutputField> outputFields = output.getOutputFields();
            OutputField outputField = outputFields.get(0);
            externalClassName = ScorecardPMMLUtils.getExtension(outputField.getExtensions(), "externalClass").getValue();
            fieldName = outputField.getName();
            Extension e = ScorecardPMMLUtils.getExtension(outputField.getExtensions(), "reasonCodeField");
            if (e == null) break;
            reasonCodesField = e.getValue();
            break;
        }
        if (reasonCodesField != null && externalClassName != null && fieldName != null) {
            Consequence consequence = new Consequence();
            StringBuilder stringBuilder = new StringBuilder("$");
            stringBuilder.append(fieldName).append("Var").append(".set").append(Character.toUpperCase(reasonCodesField.charAt(0))).append(reasonCodesField.substring(1));
            stringBuilder.append("($reasons);");
            consequence.setSnippet(stringBuilder.toString());
            rule.addConsequence(consequence);
        }
    }

    @Override
    protected void addAdditionalReasonCodeCondition(Rule rule, Scorecard scorecard) {
        if (!scorecard.isUseReasonCodes()) {
            return;
        }
        String externalClassName = null;
        String reasonCodesField = null;
        String fieldName = null;
        for (Serializable obj : scorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
            if (!(obj instanceof Output)) continue;
            Output output = (Output)obj;
            List<OutputField> outputFields = output.getOutputFields();
            OutputField outputField = outputFields.get(0);
            externalClassName = ScorecardPMMLUtils.getExtension(outputField.getExtensions(), "externalClass").getValue();
            fieldName = outputField.getName();
            Extension e = ScorecardPMMLUtils.getExtension(outputField.getExtensions(), "reasonCodeField");
            if (e == null) break;
            reasonCodesField = e.getValue();
            break;
        }
        if (reasonCodesField != null && externalClassName != null && fieldName != null) {
            Condition condition = new Condition();
            StringBuilder stringBuilder = new StringBuilder("$");
            stringBuilder.append(fieldName).append("Var : ").append(externalClassName).append("()");
            condition.setSnippet(stringBuilder.toString());
            rule.addCondition(condition);
        }
    }

    @Override
    protected void addAdditionalSummationConsequence(Rule calcTotalRule, Scorecard scorecard) {
        String externalClassName = null;
        String fieldName = null;
        for (Serializable obj : scorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
            if (!(obj instanceof Output)) continue;
            Output output = (Output)obj;
            List<OutputField> outputFields = output.getOutputFields();
            OutputField outputField = outputFields.get(0);
            fieldName = outputField.getName();
            externalClassName = ScorecardPMMLUtils.getExtension(outputField.getExtensions(), "externalClass").getValue();
            break;
        }
        if (fieldName != null && externalClassName != null) {
            Consequence consequence = new Consequence();
            StringBuilder stringBuilder = new StringBuilder("$");
            stringBuilder.append(fieldName).append("Var").append(".set").append(Character.toUpperCase(fieldName.charAt(0))).append(fieldName.substring(1));
            if (scorecard.getInitialScore() > 0.0) {
                stringBuilder.append("($calculatedScore+$initialScore);");
            } else {
                stringBuilder.append("($calculatedScore);");
            }
            consequence.setSnippet(stringBuilder.toString());
            calcTotalRule.addConsequence(consequence);
        }
    }

    @Override
    protected void addAdditionalSummationCondition(Rule calcTotalRule, Scorecard scorecard) {
        String externalClassName = null;
        String fieldName = null;
        for (Serializable obj : scorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
            if (!(obj instanceof Output)) continue;
            Output output = (Output)obj;
            List<OutputField> outputFields = output.getOutputFields();
            OutputField outputField = outputFields.get(0);
            fieldName = outputField.getName();
            externalClassName = ScorecardPMMLUtils.getExtension(outputField.getExtensions(), "externalClass").getValue();
            break;
        }
        if (fieldName != null && externalClassName != null) {
            Condition condition = new Condition();
            StringBuilder stringBuilder = new StringBuilder("$");
            stringBuilder.append(fieldName).append("Var : ").append(externalClassName).append("()");
            condition.setSnippet(stringBuilder.toString());
            calcTotalRule.addCondition(condition);
        }
    }

    @Override
    protected Condition createInitialRuleCondition(Scorecard scorecard, String objectClass) {
        String externalClassName = null;
        for (Serializable obj : scorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
            if (!(obj instanceof Output)) continue;
            Output output = (Output)obj;
            List<OutputField> outputFields = output.getOutputFields();
            OutputField outputField = outputFields.get(0);
            externalClassName = ScorecardPMMLUtils.getExtension(outputField.getExtensions(), "externalClass").getValue();
            break;
        }
        if (externalClassName != null) {
            Condition condition = new Condition();
            condition.setSnippet(externalClassName + "()");
            return condition;
        }
        return null;
    }
}

