/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scorecards.drl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.pmml_4_1.descr.Array;
import org.dmg.pmml.pmml_4_1.descr.Attribute;
import org.dmg.pmml.pmml_4_1.descr.Characteristic;
import org.dmg.pmml.pmml_4_1.descr.Characteristics;
import org.dmg.pmml.pmml_4_1.descr.CompoundPredicate;
import org.dmg.pmml.pmml_4_1.descr.PMML;
import org.dmg.pmml.pmml_4_1.descr.Scorecard;
import org.dmg.pmml.pmml_4_1.descr.SimplePredicate;
import org.dmg.pmml.pmml_4_1.descr.SimpleSetPredicate;
import org.drools.core.util.StringUtils;
import org.drools.scorecards.pmml.ScorecardPMMLUtils;
import org.drools.template.model.Condition;
import org.drools.template.model.Consequence;
import org.drools.template.model.DRLOutput;
import org.drools.template.model.Import;
import org.drools.template.model.Package;
import org.drools.template.model.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDRLEmitter {
    protected String formRuleName(PMML pmmlDocument, String modelName, Characteristic c, Attribute scoreAttribute) {
        StringBuilder sb = new StringBuilder();
        sb.append(modelName).append("_").append(c.getName()).append("_");
        String dataType = ScorecardPMMLUtils.getDataType(pmmlDocument, ScorecardPMMLUtils.extractFieldNameFromCharacteristic(c));
        if ("Number".equalsIgnoreCase(dataType)) {
            if (scoreAttribute.getSimplePredicate() != null) {
                sb.append(scoreAttribute.getSimplePredicate().getOperator()).append("_").append(scoreAttribute.getSimplePredicate().getValue());
            } else if (scoreAttribute.getCompoundPredicate() != null) {
                sb.append("between");
                for (Serializable obj : scoreAttribute.getCompoundPredicate().getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates()) {
                    if (!(obj instanceof SimplePredicate)) continue;
                    sb.append("_").append(((SimplePredicate)obj).getValue());
                }
            }
        } else if ("Text".equalsIgnoreCase(dataType) || "Boolean".equalsIgnoreCase(dataType)) {
            if (scoreAttribute.getSimplePredicate() != null) {
                sb.append(scoreAttribute.getSimplePredicate().getOperator()).append("_").append(scoreAttribute.getSimplePredicate().getValue());
            } else if (scoreAttribute.getSimpleSetPredicate() != null) {
                SimpleSetPredicate predicate = scoreAttribute.getSimpleSetPredicate();
                Array array = predicate.getArray();
                String text = array.getContent().replace(" ", "_");
                sb.append(predicate.getBooleanOperator()).append("_").append(text);
            }
        }
        return sb.toString();
    }

    protected Characteristics getCharacteristicsFromScorecard(Scorecard scorecard) {
        for (Serializable obj : scorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
            if (!(obj instanceof Characteristics)) continue;
            return (Characteristics)obj;
        }
        return null;
    }

    protected void addGlobals(PMML pmml, Package aPackage) {
    }

    public String emitDRL(PMML pmml) {
        List<Rule> ruleList = this.createRuleList(pmml);
        String pkgName = ScorecardPMMLUtils.getExtensionValue(pmml.getHeader().getExtensions(), "scorecardPackage");
        Package aPackage = new Package(pkgName);
        DRLOutput drlOutput = new DRLOutput();
        for (Rule rule : ruleList) {
            aPackage.addRule(rule);
        }
        this.addDeclaredTypes(pmml, aPackage);
        this.addImports(pmml, aPackage);
        this.addGlobals(pmml, aPackage);
        this.internalEmitDRL(pmml, ruleList, aPackage);
        aPackage.renderDRL(drlOutput);
        String drl = drlOutput.getDRL();
        return drl;
    }

    private void addImports(PMML pmml, Package aPackage) {
        String importsFromDelimitedString = ScorecardPMMLUtils.getExtensionValue(pmml.getHeader().getExtensions(), "importsFromDelimitedString");
        for (String importStatement : importsFromDelimitedString.split(",")) {
            Import imp = new Import();
            imp.setClassName(importStatement);
            aPackage.addImport(imp);
        }
        Import defaultScorecardImport = new Import();
        defaultScorecardImport.setClassName("org.drools.scorecards.DroolsScorecard");
        aPackage.addImport(defaultScorecardImport);
        defaultScorecardImport = new Import();
        defaultScorecardImport.setClassName("org.drools.scorecards.PartialScore");
        aPackage.addImport(defaultScorecardImport);
        defaultScorecardImport = new Import();
        defaultScorecardImport.setClassName("org.drools.scorecards.InitialScore");
        aPackage.addImport(defaultScorecardImport);
        defaultScorecardImport = new Import();
        defaultScorecardImport.setClassName("org.drools.scorecards.BaselineScore");
        aPackage.addImport(defaultScorecardImport);
    }

    protected void addDeclaredTypes(PMML pmml, Package aPackage) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\ndeclare DroolsScorecard\nend\n\n");
        for (Serializable obj : pmml.getAssociationModelsAndBaselineModelsAndClusteringModels()) {
            if (!(obj instanceof Scorecard)) continue;
            Scorecard scorecard = (Scorecard)obj;
            stringBuilder.append("declare ").append(scorecard.getModelName().replaceAll(" ", "")).append(" extends DroolsScorecard\n");
            this.addDeclaredTypeContents(pmml, stringBuilder, scorecard);
            stringBuilder.append("end\n");
        }
        aPackage.addDeclaredType(stringBuilder.toString());
    }

    protected List<Rule> createRuleList(PMML pmmlDocument) {
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        for (Serializable obj : pmmlDocument.getAssociationModelsAndBaselineModelsAndClusteringModels()) {
            if (!(obj instanceof Scorecard)) continue;
            Scorecard scorecard = (Scorecard)obj;
            Characteristics characteristics = this.getCharacteristicsFromScorecard(scorecard);
            this.createInitialRule(ruleList, scorecard);
            for (Characteristic c : characteristics.getCharacteristics()) {
                int attributePosition = 0;
                for (Attribute scoreAttribute : c.getAttributes()) {
                    String name = this.formRuleName(pmmlDocument, scorecard.getModelName().replaceAll(" ", ""), c, scoreAttribute);
                    Rule rule = new Rule(name, Integer.valueOf(99), 1);
                    String desc = ScorecardPMMLUtils.getExtensionValue(scoreAttribute.getExtensions(), "description");
                    if (desc != null) {
                        rule.setDescription(desc);
                    }
                    this.populateLHS(rule, pmmlDocument, scorecard, c, scoreAttribute);
                    this.populateRHS(rule, pmmlDocument, scorecard, c, scoreAttribute, ++attributePosition);
                    ruleList.add(rule);
                }
            }
            this.createSummationRules(ruleList, scorecard);
        }
        return ruleList;
    }

    protected void createInitialRule(List<Rule> ruleList, Scorecard scorecard) {
        if (scorecard.getInitialScore() > 0.0 || scorecard.isUseReasonCodes()) {
            Consequence consequence;
            String objectClass = scorecard.getModelName().replaceAll(" ", "");
            String ruleName = objectClass + "_init";
            Rule rule = new Rule(ruleName, Integer.valueOf(999), 1);
            rule.setDescription("set the initial score");
            Condition condition = this.createInitialRuleCondition(scorecard, objectClass);
            rule.addCondition(condition);
            if (scorecard.getInitialScore() > 0.0) {
                consequence = new Consequence();
                consequence.setSnippet("insertLogical(new InitialScore(\"" + objectClass + "\"," + scorecard.getInitialScore() + "));");
                rule.addConsequence(consequence);
            }
            if (scorecard.isUseReasonCodes()) {
                for (Serializable obj : scorecard.getExtensionsAndCharacteristicsAndMiningSchemas()) {
                    if (!(obj instanceof Characteristics)) continue;
                    Characteristics characteristics = (Characteristics)obj;
                    for (Characteristic characteristic : characteristics.getCharacteristics()) {
                        String field = ScorecardPMMLUtils.extractFieldNameFromCharacteristic(characteristic);
                        Consequence consequence2 = new Consequence();
                        if (characteristic.getBaselineScore() == null || characteristic.getBaselineScore() == 0.0) {
                            consequence2.setSnippet("insertLogical(new BaselineScore(\"" + objectClass + "\",\"" + field + "\"," + scorecard.getBaselineScore() + "));");
                        } else {
                            consequence2.setSnippet("insertLogical(new BaselineScore(\"" + objectClass + "\",\"" + field + "\"," + characteristic.getBaselineScore() + "));");
                        }
                        rule.addConsequence(consequence2);
                    }
                }
                if (scorecard.getReasonCodeAlgorithm() != null) {
                    consequence = new Consequence();
                    if ("pointsAbove".equalsIgnoreCase(scorecard.getReasonCodeAlgorithm())) {
                        consequence.setSnippet("//$sc.setReasonCodeAlgorithm(DroolsScorecard.REASON_CODE_ALGORITHM_POINTSABOVE);");
                    } else if ("pointsBelow".equalsIgnoreCase(scorecard.getReasonCodeAlgorithm())) {
                        consequence.setSnippet("//$sc.setReasonCodeAlgorithm(DroolsScorecard.REASON_CODE_ALGORITHM_POINTSBELOW);");
                    }
                    rule.addConsequence(consequence);
                }
            }
            ruleList.add(rule);
        }
    }

    protected void populateLHS(Rule rule, PMML pmmlDocument, Scorecard scorecard, Characteristic c, Attribute scoreAttribute) {
        this.addLHSConditions(rule, pmmlDocument, scorecard, c, scoreAttribute);
    }

    protected void createFieldRestriction(PMML pmmlDocument, Characteristic c, Attribute scoreAttribute, StringBuilder stringBuilder) {
        block32: {
            String dataType;
            block33: {
                String operator;
                SimplePredicate predicate;
                block34: {
                    block29: {
                        block30: {
                            String operator2;
                            SimplePredicate predicate2;
                            block31: {
                                stringBuilder.append("(");
                                dataType = ScorecardPMMLUtils.getDataType(pmmlDocument, ScorecardPMMLUtils.extractFieldNameFromCharacteristic(c));
                                if (!"Text".equalsIgnoreCase(dataType)) break block29;
                                if (scoreAttribute.getSimplePredicate() == null) break block30;
                                predicate2 = scoreAttribute.getSimplePredicate();
                                operator2 = predicate2.getOperator();
                                if (!"equal".equalsIgnoreCase(operator2)) break block31;
                                stringBuilder.append(predicate2.getField());
                                stringBuilder.append(" == ");
                                stringBuilder.append("\"").append(predicate2.getValue()).append("\"");
                                break block32;
                            }
                            if (!"notEqual".equalsIgnoreCase(operator2)) break block32;
                            stringBuilder.append(predicate2.getField());
                            stringBuilder.append(" != ");
                            stringBuilder.append("\"").append(predicate2.getValue()).append("\"");
                            break block32;
                        }
                        if (scoreAttribute.getSimpleSetPredicate() == null) break block32;
                        SimpleSetPredicate simpleSetPredicate = scoreAttribute.getSimpleSetPredicate();
                        String content = simpleSetPredicate.getArray().getContent();
                        content = content.replaceAll(" ", "\",\"");
                        stringBuilder.append(simpleSetPredicate.getField()).append(" in ( \"").append(content).append("\" )");
                        break block32;
                    }
                    if (!"Boolean".equalsIgnoreCase(dataType)) break block33;
                    if (scoreAttribute.getSimplePredicate() == null) break block32;
                    predicate = scoreAttribute.getSimplePredicate();
                    operator = predicate.getOperator();
                    if (!"equal".equalsIgnoreCase(operator)) break block34;
                    stringBuilder.append(predicate.getField());
                    stringBuilder.append(" == ");
                    stringBuilder.append(predicate.getValue().toLowerCase());
                    break block32;
                }
                if (!"notEqual".equalsIgnoreCase(operator)) break block32;
                stringBuilder.append(predicate.getField());
                stringBuilder.append(" != ");
                stringBuilder.append(predicate.getValue().toLowerCase());
                break block32;
            }
            if ("Number".equalsIgnoreCase(dataType)) {
                if (scoreAttribute.getSimplePredicate() != null) {
                    SimplePredicate predicate = scoreAttribute.getSimplePredicate();
                    String operator = predicate.getOperator();
                    stringBuilder.append(predicate.getField());
                    if ("lessThan".equalsIgnoreCase(operator)) {
                        stringBuilder.append(" < ");
                    } else if ("greaterThan".equalsIgnoreCase(operator)) {
                        stringBuilder.append(" > ");
                    } else if ("notEqual".equalsIgnoreCase(operator)) {
                        stringBuilder.append(" <> ");
                    } else if ("equal".equalsIgnoreCase(operator)) {
                        stringBuilder.append(" == ");
                    } else if ("greaterOrEqual".equalsIgnoreCase(operator)) {
                        stringBuilder.append(" >= ");
                    } else if ("lessOrEqual".equalsIgnoreCase(operator)) {
                        stringBuilder.append(" <= ");
                    }
                    stringBuilder.append(predicate.getValue());
                } else if (scoreAttribute.getCompoundPredicate() != null) {
                    CompoundPredicate predicate = scoreAttribute.getCompoundPredicate();
                    String field = null;
                    for (Serializable obj : predicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates()) {
                        if (!(obj instanceof SimplePredicate)) continue;
                        SimplePredicate simplePredicate = (SimplePredicate)obj;
                        String operator = simplePredicate.getOperator();
                        if (field == null) {
                            stringBuilder.append(simplePredicate.getField());
                            field = simplePredicate.getField();
                        } else {
                            stringBuilder.append(" && ");
                        }
                        if ("lessThan".equalsIgnoreCase(operator)) {
                            stringBuilder.append(" < ");
                        } else if ("greaterThan".equalsIgnoreCase(operator)) {
                            stringBuilder.append(" > ");
                        } else if ("notEqual".equalsIgnoreCase(operator)) {
                            stringBuilder.append(" <> ");
                        } else if ("equal".equalsIgnoreCase(operator)) {
                            stringBuilder.append(" == ");
                        } else if ("greaterOrEqual".equalsIgnoreCase(operator)) {
                            stringBuilder.append(" >= ");
                        } else if ("lessOrEqual".equalsIgnoreCase(operator)) {
                            stringBuilder.append(" <= ");
                        }
                        stringBuilder.append(simplePredicate.getValue());
                    }
                }
            }
        }
        stringBuilder.append(")");
    }

    protected void populateRHS(Rule rule, PMML pmmlDocument, Scorecard scorecard, Characteristic c, Attribute scoreAttribute, int position) {
        Consequence consequence = new Consequence();
        StringBuilder stringBuilder = new StringBuilder();
        String objectClass = scorecard.getModelName().replaceAll(" ", "");
        String setter = "insertLogical(new PartialScore(\"";
        String field = ScorecardPMMLUtils.extractFieldNameFromCharacteristic(c);
        stringBuilder.append(setter).append(objectClass).append("\",\"").append(field).append("\",").append(scoreAttribute.getPartialScore());
        if (scorecard.isUseReasonCodes()) {
            String reasonCode = scoreAttribute.getReasonCode();
            if (reasonCode == null || StringUtils.isEmpty((CharSequence)reasonCode)) {
                reasonCode = c.getReasonCode();
            }
            stringBuilder.append(",\"").append(reasonCode).append("\", ").append(position);
        }
        stringBuilder.append("));");
        consequence.setSnippet(stringBuilder.toString());
        rule.addConsequence(consequence);
    }

    protected void createSummationRules(List<Rule> ruleList, Scorecard scorecard) {
        String objectClass = scorecard.getModelName().replaceAll(" ", "");
        Rule calcTotalRule = new Rule(objectClass + "_calculateTotalScore", Integer.valueOf(1), 1);
        StringBuilder stringBuilder = new StringBuilder();
        Condition condition = new Condition();
        stringBuilder.append("$calculatedScore : Double() from accumulate (PartialScore(scorecardName ==\"").append(objectClass).append("\", $partialScore:score), sum($partialScore))");
        condition.setSnippet(stringBuilder.toString());
        calcTotalRule.addCondition(condition);
        if (scorecard.getInitialScore() > 0.0) {
            condition = new Condition();
            stringBuilder = new StringBuilder();
            stringBuilder.append("InitialScore(scorecardName == \"").append(objectClass).append("\", $initialScore:score)");
            condition.setSnippet(stringBuilder.toString());
            calcTotalRule.addCondition(condition);
        }
        ruleList.add(calcTotalRule);
        if (scorecard.isUseReasonCodes()) {
            String ruleName = objectClass + "_collectReasonCodes";
            Rule rule = new Rule(ruleName, Integer.valueOf(1), 1);
            rule.setDescription("collect and sort the reason codes as per the specified algorithm");
            condition = new Condition();
            stringBuilder = new StringBuilder();
            stringBuilder.append("$reasons : List() from accumulate ( PartialScore(scorecardName == \"").append(objectClass).append("\", $reasonCode : reasoncode ); collectList($reasonCode) )");
            condition.setSnippet(stringBuilder.toString());
            rule.addCondition(condition);
            ruleList.add(rule);
            this.addAdditionalReasonCodeCondition(rule, scorecard);
            this.addAdditionalReasonCodeConsequence(rule, scorecard);
        }
        this.addAdditionalSummationCondition(calcTotalRule, scorecard);
        this.addAdditionalSummationConsequence(calcTotalRule, scorecard);
    }

    protected abstract void addDeclaredTypeContents(PMML var1, StringBuilder var2, Scorecard var3);

    protected abstract void internalEmitDRL(PMML var1, List<Rule> var2, Package var3);

    protected abstract void addLHSConditions(Rule var1, PMML var2, Scorecard var3, Characteristic var4, Attribute var5);

    protected abstract void addAdditionalReasonCodeConsequence(Rule var1, Scorecard var2);

    protected abstract void addAdditionalReasonCodeCondition(Rule var1, Scorecard var2);

    protected abstract void addAdditionalSummationConsequence(Rule var1, Scorecard var2);

    protected abstract void addAdditionalSummationCondition(Rule var1, Scorecard var2);

    protected abstract Condition createInitialRuleCondition(Scorecard var1, String var2);
}

