/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scorecards;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.drools.scorecards.PartialScore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsScorecard
implements Serializable {
    double calculatedScore;
    List<String> reasonCodes = new ArrayList<String>();
    Map<String, Double> baselineScoreMap = new HashMap<String, Double>();
    private int reasonCodeAlgorithm;
    public static int REASON_CODE_ALGORITHM_POINTSABOVE = 1;
    public static int REASON_CODE_ALGORITHM_POINTSBELOW = -1;

    public int getReasonCodeAlgorithm() {
        return this.reasonCodeAlgorithm;
    }

    public void setReasonCodeAlgorithm(int reasonCodeAlgorithm) {
        this.reasonCodeAlgorithm = reasonCodeAlgorithm;
    }

    public void setBaselineScore(String characteristic, int baselineScore) {
        this.baselineScoreMap.put(characteristic, Double.valueOf(baselineScore));
    }

    public void setBaselineScore(String characteristic, double baselineScore) {
        this.baselineScoreMap.put(characteristic, baselineScore);
    }

    public double getCalculatedScore() {
        return this.calculatedScore;
    }

    public void setCalculatedScore(double calculatedScore) {
        this.calculatedScore = calculatedScore;
    }

    public void sortReasonCodes() {
    }

    public void setInitialScore(double initialScore) {
        this.calculatedScore = initialScore;
    }

    public List<String> getReasonCodes() {
        return Collections.unmodifiableList(this.reasonCodes);
    }

    public void setReasonCodes(List<String> reasonCodes) {
        this.reasonCodes = reasonCodes;
    }

    public void sortReasonCodes(List<PartialScore> partialScores) {
        TreeMap<Double, String> distanceMap = new TreeMap<Double, String>();
        for (PartialScore partialScore : partialScores) {
            if (this.baselineScoreMap.get(partialScore.getCharacteristic()) == null) continue;
            double baseline = this.baselineScoreMap.get(partialScore.getCharacteristic());
            double distance = 0.0;
            if (this.getReasonCodeAlgorithm() == REASON_CODE_ALGORITHM_POINTSABOVE) {
                distance = baseline - partialScore.getScore() + (double)partialScore.getPosition();
                distanceMap.put(distance, partialScore.getReasoncode());
                continue;
            }
            if (this.getReasonCodeAlgorithm() != REASON_CODE_ALGORITHM_POINTSBELOW) continue;
            distance = partialScore.getScore() - baseline + (double)partialScore.getPosition();
            distanceMap.put(distance, partialScore.getReasoncode());
        }
        for (Double distance : distanceMap.descendingKeySet()) {
            System.out.println(distance + "  " + (String)distanceMap.get(distance));
        }
    }
}

