/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.ByteArrayOutputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class MarshalProcessor
extends ServiceSupport
implements Processor,
Traceable,
CamelContextAware {
    private CamelContext camelContext;
    private final DataFormat dataFormat;

    public MarshalProcessor(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        ObjectHelper.notNull(this.dataFormat, "dataFormat");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Message in = exchange.getIn();
        Object body = in.getBody();
        Message out = exchange.getOut();
        out.copyFrom(in);
        try {
            this.dataFormat.marshal(exchange, body, buffer);
            byte[] data = buffer.toByteArray();
            out.setBody(data);
        }
        catch (Exception e) {
            exchange.setOut(null);
            throw e;
        }
    }

    public String toString() {
        return "Marshal[" + this.dataFormat + "]";
    }

    @Override
    public String getTraceLabel() {
        return "marshal[" + this.dataFormat + "]";
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.dataFormat instanceof CamelContextAware) {
            ((CamelContextAware)((Object)this.dataFormat)).setCamelContext(this.camelContext);
        }
        ServiceHelper.startService(this.dataFormat);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.dataFormat);
    }
}

