/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.directvm;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.directvm.DirectVmEndpoint;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.util.ExchangeHelper;

public final class DirectVmProcessor
extends DelegateProcessor {
    private final DirectVmEndpoint endpoint;

    public DirectVmProcessor(Processor processor, DirectVmEndpoint endpoint) {
        super(processor);
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Exchange exchange) throws Exception {
        Exchange copy = this.prepareExchange(exchange);
        try {
            this.getProcessor().process(copy);
        }
        finally {
            ExchangeHelper.copyResults(exchange, copy);
        }
    }

    protected Exchange prepareExchange(Exchange exchange) {
        Exchange newExchange = ExchangeHelper.copyExchangeAndSetCamelContext(exchange, this.endpoint.getCamelContext(), false);
        newExchange.setFromEndpoint(this.endpoint);
        return newExchange;
    }

    @Override
    public String toString() {
        return "DirectVm[" + this.processor + "]";
    }
}

