/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.WebListener;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.jboss.seam.transaction.DefaultTransaction;
import org.jboss.seam.transaction.SeamTransaction;
import org.jboss.solder.exception.control.ExceptionToCatch;
import org.jboss.solder.logging.Logger;

@WebListener
public class TransactionServletListener
implements ServletRequestListener {
    public static String DISABLE_LISTENER_PARAM = "org.jboss.seam.transaction.disableListener";
    private final Logger log = Logger.getLogger(TransactionServletListener.class);
    @Inject
    @DefaultTransaction
    private SeamTransaction tx;
    @Inject
    Event<ExceptionToCatch> txException;

    public void requestDestroyed(ServletRequestEvent sre) {
        String listenerDisabledParam = sre.getServletContext().getInitParameter(DISABLE_LISTENER_PARAM);
        if (listenerDisabledParam != null && "true".equals(listenerDisabledParam.trim().toLowerCase())) {
            return;
        }
        try {
            switch (this.tx.getStatus()) {
                case 0: {
                    this.log.debugf("Committing a transaction for request %s", (Object)sre.getServletRequest());
                    this.tx.commit();
                    break;
                }
                case 1: 
                case 2: 
                case 7: {
                    this.log.debugf("Rolling back a transaction for request %s", (Object)sre.getServletRequest());
                    this.tx.rollback();
                    break;
                }
            }
        }
        catch (SystemException e) {
            this.log.warn((Object)"Error rolling back the transaction", (Throwable)e);
            this.txException.fire((Object)new ExceptionToCatch((Throwable)e));
        }
        catch (HeuristicRollbackException e) {
            this.log.warn((Object)"Error committing the transaction", (Throwable)e);
            this.txException.fire((Object)new ExceptionToCatch((Throwable)e));
        }
        catch (RollbackException e) {
            this.log.warn((Object)"Error committing the transaction", (Throwable)e);
            this.txException.fire((Object)new ExceptionToCatch((Throwable)e));
        }
        catch (HeuristicMixedException e) {
            this.log.warn((Object)"Error committing the transaction", (Throwable)e);
            this.txException.fire((Object)new ExceptionToCatch((Throwable)e));
        }
    }

    public void requestInitialized(ServletRequestEvent sre) {
        String listenerDisabledParam = sre.getServletContext().getInitParameter(DISABLE_LISTENER_PARAM);
        if (listenerDisabledParam != null && "true".equals(listenerDisabledParam.trim().toLowerCase())) {
            return;
        }
        try {
            if (this.tx.getStatus() == 0) {
                this.log.warn((Object)"Transaction was already started before the listener");
            } else {
                this.log.debugf("Beginning transaction for request %s", (Object)sre.getServletRequest());
                this.tx.begin();
            }
        }
        catch (SystemException se) {
            this.log.warn((Object)"Error starting the transaction, or checking status", (Throwable)se);
            this.txException.fire((Object)new ExceptionToCatch((Throwable)se));
        }
        catch (NotSupportedException e) {
            this.log.warn((Object)"Error starting the transaction", (Throwable)e);
            this.txException.fire((Object)new ExceptionToCatch((Throwable)e));
        }
    }
}

