/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.Map;
import org.drools.rule.Declaration;
import org.drools.rule.builder.ConsequenceBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.DialectUtil;
import org.drools.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.rule.builder.dialect.java.JavaRuleBuilderHelper;
import org.drools.rule.builder.dialect.java.KnowledgeHelperFixer;

public class JavaConsequenceBuilder
implements ConsequenceBuilder {
    public void build(RuleBuildContext context, String consequenceName) {
        context.getBuildStack().push(context.getRule().getLhs());
        String className = consequenceName + "Consequence";
        Map<String, Declaration> decls = context.getDeclarationResolver().getDeclarations(context.getRule());
        JavaAnalysisResult analysis = JavaRuleBuilderHelper.createJavaAnalysisResult(context, consequenceName, decls);
        if (analysis == null) {
            return;
        }
        String fixedConsequence = DialectUtil.fixBlockDescr(context, analysis, decls);
        if (fixedConsequence == null) {
            return;
        }
        fixedConsequence = KnowledgeHelperFixer.fix(fixedConsequence);
        Map<String, Object> map = JavaRuleBuilderHelper.createConsequenceContext(context, consequenceName, className, fixedConsequence, decls, analysis.getBoundIdentifiers());
        JavaRuleBuilderHelper.generateTemplates("consequenceMethod", "consequenceInvoker", context, className, map, context.getRule(), context.getRuleDescr());
        context.getBuildStack().pop();
    }
}

