/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import org.drools.base.ClassObjectType;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.factmodel.traits.TraitProxy;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;

public class TraitObjectTypeNode
extends ObjectTypeNode {
    private BitSet typeMask;

    public TraitObjectTypeNode(int id, EntryPointNode source, ObjectType objectType, BuildContext context) {
        super(id, source, objectType, context);
        this.typeMask = context.getRuleBase().getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy().getCode(((ClassObjectType)objectType).getClassName());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.typeMask = (BitSet)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.typeMask);
    }

    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.dirty) {
            this.resetIdGenerator();
            TraitObjectTypeNode.updateTupleSinkId(this, this);
            this.dirty = false;
        }
        context.setObjectType(this.objectType);
        if (this.compiledNetwork != null) {
            this.compiledNetwork.modifyObject(factHandle, modifyPreviousTuples, context.adaptModificationMaskForObjectType(this.objectType, workingMemory), workingMemory);
        } else if (factHandle.getObject() instanceof TraitProxy) {
            BitSet vetoMask = ((TraitProxy)factHandle.getObject()).getTypeFilter();
            if (vetoMask == null) {
                this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context.adaptModificationMaskForObjectType(this.objectType, workingMemory), workingMemory);
            } else {
                BitSet checkMask = (BitSet)this.typeMask.clone();
                checkMask.and(vetoMask);
                if (!checkMask.equals(this.typeMask)) {
                    this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context.adaptModificationMaskForObjectType(this.objectType, workingMemory), workingMemory);
                }
            }
        } else {
            this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context.adaptModificationMaskForObjectType(this.objectType, workingMemory), workingMemory);
        }
    }
}

