/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import org.drools.RuleBaseConfiguration;
import org.drools.base.DroolsQuery;
import org.drools.base.InternalViewChangedEventListener;
import org.drools.base.extractors.ArrayElementReader;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.LeftTupleIterator;
import org.drools.common.Memory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.QueryElementFactHandle;
import org.drools.common.UpdateContext;
import org.drools.core.util.index.RightTupleList;
import org.drools.marshalling.impl.PersisterHelper;
import org.drools.marshalling.impl.ProtobufInputMarshaller;
import org.drools.marshalling.impl.ProtobufMessages;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.NodeSet;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.QueryElementNodeLeftTuple;
import org.drools.reteoo.QueryTerminalNode;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Declaration;
import org.drools.rule.QueryElement;
import org.drools.rule.Rule;
import org.drools.runtime.rule.Variable;
import org.drools.spi.PropagationContext;

public class QueryElementNode
extends LeftTupleSource
implements LeftTupleSinkNode,
NodeMemory {
    private LeftTupleSource tupleSource;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private QueryElement queryElement;
    private boolean tupleMemoryEnabled;
    private boolean openQuery;

    public QueryElementNode() {
    }

    public QueryElementNode(int id, LeftTupleSource tupleSource, QueryElement queryElement, boolean tupleMemoryEnabled, boolean openQuery, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.tupleSource = tupleSource;
        this.queryElement = queryElement;
        this.tupleMemoryEnabled = tupleMemoryEnabled;
        this.openQuery = openQuery;
        this.initMasks(context, tupleSource);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.queryElement = (QueryElement)in.readObject();
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
        this.openQuery = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.queryElement);
        out.writeObject(this.tupleSource);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeBoolean(this.openQuery);
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTupleIterator it = LeftTupleIterator.iterator(workingMemory, this);
        LeftTuple leftTuple = (LeftTuple)it.next();
        while (leftTuple != null) {
            LeftTuple childLeftTuple = leftTuple.getFirstChild();
            while (childLeftTuple != null) {
                RightTuple rightParent = childLeftTuple.getRightParent();
                sink.assertLeftTuple(sink.createLeftTuple(leftTuple, rightParent, childLeftTuple, null, sink, true), context, workingMemory);
                while (childLeftTuple != null && childLeftTuple.getRightParent() == rightParent) {
                    childLeftTuple = childLeftTuple.getLeftParentNext();
                }
            }
            leftTuple = (LeftTuple)it.next();
        }
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        if (!this.isInUse()) {
            for (InternalWorkingMemory workingMemory : workingMemories) {
                workingMemory.clearNodeMemory(this);
            }
            this.tupleSource.removeTupleSink(this);
        }
    }

    protected void doCollectAncestors(NodeSet nodeSet) {
        this.tupleSource.collectAncestors(nodeSet);
    }

    public void attach(BuildContext context) {
        this.tupleSource.addTupleSink(this, context);
        if (context == null) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void networkUpdated(UpdateContext updateContext) {
        this.tupleSource.networkUpdated(updateContext);
    }

    public short getType() {
        return 11;
    }

    public boolean isLeftTupleMemoryEnabled() {
        return false;
    }

    public QueryElement getQueryElement() {
        return this.queryElement;
    }

    public boolean isOpenQuery() {
        return this.openQuery;
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        workingMemory.getNodeMemory(this);
        InternalFactHandle handle = this.createFactHandle(context, workingMemory, leftTuple);
        DroolsQuery queryObject = this.createDroolsQuery(leftTuple, handle, workingMemory);
        ReteooWorkingMemory.QueryInsertAction action = new ReteooWorkingMemory.QueryInsertAction(context, handle, leftTuple, this);
        queryObject.setAction(action);
        context.addInsertAction(action);
    }

    private InternalFactHandle createFactHandle(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        Map map;
        InternalFactHandle handle = null;
        ProtobufMessages.FactHandle _handle = null;
        if (context.getReaderContext() != null && (map = (Map)context.getReaderContext().nodeMemories.get(this.getId())) != null) {
            _handle = ((ProtobufInputMarshaller.QueryElementContext)map.get((Object)PersisterHelper.createTupleKey((LeftTuple)leftTuple))).handle;
        }
        handle = _handle != null ? workingMemory.getFactHandleFactory().newFactHandle(_handle.getId(), null, _handle.getRecency(), null, workingMemory, workingMemory) : workingMemory.getFactHandleFactory().newFactHandle(null, null, workingMemory, workingMemory);
        return handle;
    }

    public DroolsQuery createDroolsQuery(LeftTuple leftTuple, InternalFactHandle handle, InternalWorkingMemory workingMemory) {
        Object object;
        Object[] argTemplate = this.queryElement.getArgTemplate();
        Object[] args = new Object[argTemplate.length];
        System.arraycopy(argTemplate, 0, args, 0, args.length);
        int[] declIndexes = this.queryElement.getDeclIndexes();
        int length = declIndexes.length;
        for (int i = 0; i < length; ++i) {
            Object o;
            Declaration declr = (Declaration)argTemplate[declIndexes[i]];
            Object tupleObject = leftTuple.get(declr).getObject();
            if (tupleObject instanceof DroolsQuery) {
                ArrayElementReader arrayReader = (ArrayElementReader)declr.getExtractor();
                o = ((DroolsQuery)tupleObject).getVariables()[arrayReader.getIndex()] != null ? Variable.v : declr.getValue(workingMemory, tupleObject);
            } else {
                o = declr.getValue(workingMemory, tupleObject);
            }
            args[declIndexes[i]] = o;
        }
        int[] varIndexes = this.queryElement.getVariableIndexes();
        int length2 = varIndexes.length;
        for (int i = 0; i < length2; ++i) {
            if (argTemplate[varIndexes[i]] != Variable.v) continue;
            args[varIndexes[i]] = Variable.v;
        }
        UnificationNodeViewChangedEventListener collector = this.createCollector(leftTuple, varIndexes, this.tupleMemoryEnabled);
        boolean executeAsOpenQuery = this.openQuery;
        if (executeAsOpenQuery && (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && !((DroolsQuery)object).isOpen()) {
            executeAsOpenQuery = false;
        }
        DroolsQuery queryObject = new DroolsQuery(this.queryElement.getQueryName(), args, collector, executeAsOpenQuery);
        collector.setFactHandle(handle);
        handle.setObject(queryObject);
        leftTuple.setObject(handle);
        return queryObject;
    }

    protected UnificationNodeViewChangedEventListener createCollector(LeftTuple leftTuple, int[] varIndexes, boolean tupleMemoryEnabled) {
        return new UnificationNodeViewChangedEventListener(leftTuple, varIndexes, this, tupleMemoryEnabled);
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        ReteooWorkingMemory.QueryRetractAction action = new ReteooWorkingMemory.QueryRetractAction(context, leftTuple, this);
        context.addInsertAction(action);
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object object;
        boolean executeAsOpenQuery = this.openQuery;
        if (executeAsOpenQuery && (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && !((DroolsQuery)object).isOpen()) {
            executeAsOpenQuery = false;
        }
        if (!executeAsOpenQuery) {
            if (leftTuple.getFirstChild() != null) {
                this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            }
            this.assertLeftTuple(leftTuple, context, workingMemory);
            return;
        }
        InternalFactHandle handle = (InternalFactHandle)leftTuple.getObject();
        DroolsQuery queryObject = (DroolsQuery)handle.getObject();
        if (queryObject.getAction() != null) {
            return;
        }
        Object[] argTemplate = this.queryElement.getArgTemplate();
        Object[] args = new Object[argTemplate.length];
        System.arraycopy(argTemplate, 0, args, 0, args.length);
        int[] declIndexes = this.queryElement.getDeclIndexes();
        int length = declIndexes.length;
        for (int i = 0; i < length; ++i) {
            Object o;
            Declaration declr = (Declaration)argTemplate[declIndexes[i]];
            Object tupleObject = leftTuple.get(declr).getObject();
            if (tupleObject instanceof DroolsQuery) {
                ArrayElementReader arrayReader = (ArrayElementReader)declr.getExtractor();
                o = ((DroolsQuery)tupleObject).getVariables()[arrayReader.getIndex()] != null ? Variable.v : declr.getValue(workingMemory, tupleObject);
            } else {
                o = declr.getValue(workingMemory, tupleObject);
            }
            args[declIndexes[i]] = o;
        }
        int[] varIndexes = this.queryElement.getVariableIndexes();
        int length2 = varIndexes.length;
        for (int i = 0; i < length2; ++i) {
            if (argTemplate[varIndexes[i]] != Variable.v) continue;
            args[varIndexes[i]] = Variable.v;
        }
        queryObject.setParameters(args);
        ((UnificationNodeViewChangedEventListener)queryObject.getQueryResultCollector()).setVariables(varIndexes);
        ReteooWorkingMemory.QueryUpdateAction action = new ReteooWorkingMemory.QueryUpdateAction(context, handle, leftTuple, this);
        context.addInsertAction(action);
    }

    public LeftTupleSource getLeftTupleSource() {
        return this.tupleSource;
    }

    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new QueryElementNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new QueryElementNodeLeftTuple(leftTuple, sink, leftTupleMemoryEnabled);
    }

    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new QueryElementNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new QueryElementNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.openQuery ? 1231 : 1237);
        result = 31 * result + (this.queryElement == null ? 0 : this.queryElement.hashCode());
        result = 31 * result + (this.tupleSource == null ? 0 : this.tupleSource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryElementNode other = (QueryElementNode)obj;
        if (this.openQuery != other.openQuery) {
            return false;
        }
        if (this.queryElement == null ? other.queryElement != null : !this.queryElement.equals(other.queryElement)) {
            return false;
        }
        return !(this.tupleSource == null ? other.tupleSource != null : !this.tupleSource.equals(other.tupleSource));
    }

    public Memory createMemory(RuleBaseConfiguration config) {
        return new QueryElementNodeMemory(this);
    }

    protected ObjectTypeNode getObjectTypeNode() {
        return this.tupleSource.getObjectTypeNode();
    }

    public static class QueryElementNodeMemory
    implements Memory {
        public final QueryElementNode node;

        public QueryElementNodeMemory(QueryElementNode node) {
            this.node = node;
        }

        public short getNodeType() {
            return 18;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnificationNodeViewChangedEventListener
    implements InternalViewChangedEventListener {
        private LeftTuple leftTuple;
        protected QueryElementNode node;
        private InternalFactHandle factHandle;
        private int[] variables;
        private boolean tupleMemoryEnabled;

        public UnificationNodeViewChangedEventListener(LeftTuple leftTuple, int[] variables, QueryElementNode node, boolean tupleMemoryEnabled) {
            this.leftTuple = leftTuple;
            this.variables = variables;
            this.node = node;
            this.tupleMemoryEnabled = tupleMemoryEnabled;
        }

        public InternalFactHandle getFactHandle() {
            return this.factHandle;
        }

        public void setFactHandle(InternalFactHandle factHandle) {
            this.factHandle = factHandle;
        }

        public void setVariables(int[] variables) {
            this.variables = variables;
        }

        @Override
        public void rowAdded(Rule rule, LeftTuple resultLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
            QueryTerminalNode node = (QueryTerminalNode)resultLeftTuple.getLeftTupleSink();
            Declaration[] decls = node.getDeclarations();
            DroolsQuery query = (DroolsQuery)this.factHandle.getObject();
            Object[] objects = new Object[query.getElements().length];
            int length = this.variables.length;
            for (int i = 0; i < length; ++i) {
                Declaration decl = decls[this.variables[i]];
                objects[this.variables[i]] = decl.getValue(workingMemory, resultLeftTuple.get(decl).getObject());
            }
            QueryElementFactHandle resultHandle = this.createQueryResultHandle(context, workingMemory, objects);
            RightTuple rightTuple = this.createResultRightTuple(resultHandle, resultLeftTuple, query.isOpen());
            this.node.getSinkPropagator().createChildLeftTuplesforQuery(this.leftTuple, rightTuple, true, query.isOpen());
            RightTupleList rightTuples = query.getResultInsertRightTupleList();
            if (rightTuples == null) {
                rightTuples = new RightTupleList();
                query.setResultInsertRightTupleList(rightTuples);
                ReteooWorkingMemory.QueryResultInsertAction evalAction = new ReteooWorkingMemory.QueryResultInsertAction(context, this.factHandle, this.leftTuple, this.node);
                context.getQueue2().addFirst(evalAction);
            }
            rightTuples.add(rightTuple);
        }

        protected RightTuple createResultRightTuple(QueryElementFactHandle resultHandle, LeftTuple resultLeftTuple, boolean open) {
            RightTuple rightTuple = new RightTuple(resultHandle);
            if (open) {
                rightTuple.setLeftTuple(resultLeftTuple);
                resultLeftTuple.setObject(rightTuple);
            }
            return rightTuple;
        }

        private QueryElementFactHandle createQueryResultHandle(PropagationContext context, InternalWorkingMemory workingMemory, Object[] objects) {
            ProtobufInputMarshaller.QueryElementContext _context;
            Map map;
            QueryElementFactHandle handle = null;
            ProtobufMessages.FactHandle _handle = null;
            if (context.getReaderContext() != null && (map = (Map)context.getReaderContext().nodeMemories.get(this.node.getId())) != null && (_context = (ProtobufInputMarshaller.QueryElementContext)map.get(PersisterHelper.createTupleKey(this.leftTuple))) != null) {
                _handle = _context.results.removeFirst();
            }
            handle = _handle != null ? new QueryElementFactHandle(objects, _handle.getId(), _handle.getRecency()) : new QueryElementFactHandle(objects, workingMemory.getFactHandleFactory().getAtomicId().incrementAndGet(), workingMemory.getFactHandleFactory().getAtomicRecency().incrementAndGet());
            return handle;
        }

        @Override
        public void rowRemoved(Rule rule, LeftTuple resultLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
            RightTuple rightTuple = (RightTuple)resultLeftTuple.getObject();
            rightTuple.setLeftTuple(null);
            resultLeftTuple.setObject(null);
            DroolsQuery query = (DroolsQuery)this.factHandle.getObject();
            RightTupleList rightTuples = query.getResultRetractRightTupleList();
            if (rightTuples == null) {
                rightTuples = new RightTupleList();
                query.setResultRetractRightTupleList(rightTuples);
                ReteooWorkingMemory.QueryResultRetractAction retractAction = new ReteooWorkingMemory.QueryResultRetractAction(context, this.factHandle, this.leftTuple, this.node);
                context.getQueue2().addFirst(retractAction);
            }
            if (rightTuple.getMemory() != null) {
                throw new RuntimeException();
            }
            rightTuples.add(rightTuple);
        }

        @Override
        public void rowUpdated(Rule rule, LeftTuple resultLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
            RightTupleList rightTuples;
            RightTuple rightTuple = (RightTuple)resultLeftTuple.getObject();
            if (rightTuple.getMemory() != null) {
                return;
            }
            rightTuple.setLeftTuple(null);
            resultLeftTuple.setObject(null);
            QueryTerminalNode node = (QueryTerminalNode)resultLeftTuple.getLeftTupleSink();
            Declaration[] decls = node.getDeclarations();
            InternalFactHandle rootHandle = resultLeftTuple.get(0);
            DroolsQuery query = (DroolsQuery)rootHandle.getObject();
            Object[] objects = new Object[query.getElements().length];
            int length = this.variables.length;
            for (int i = 0; i < length; ++i) {
                Declaration decl = decls[this.variables[i]];
                objects[this.variables[i]] = decl.getValue(workingMemory, resultLeftTuple.get(decl).getObject());
            }
            QueryElementFactHandle handle = (QueryElementFactHandle)rightTuple.getFactHandle();
            handle.setRecency(workingMemory.getFactHandleFactory().getAtomicRecency().incrementAndGet());
            handle.setObject(objects);
            if (query.isOpen()) {
                rightTuple.setLeftTuple(resultLeftTuple);
                resultLeftTuple.setObject(rightTuple);
            }
            if ((rightTuples = query.getResultUpdateRightTupleList()) == null) {
                rightTuples = new RightTupleList();
                query.setResultUpdateRightTupleList(rightTuples);
                ReteooWorkingMemory.QueryResultUpdateAction updateAction = new ReteooWorkingMemory.QueryResultUpdateAction(context, this.factHandle, this.leftTuple, this.node);
                context.getQueue2().addFirst(updateAction);
            }
            rightTuples.add(rightTuple);
        }

        @Override
        public List<? extends Object> getResults() {
            throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does not support the getResults() method.");
        }

        public LeftTuple getLeftTuple() {
            return this.leftTuple;
        }
    }
}

