/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import org.drools.core.util.StringUtils;

public class QualifiedName {
    private String name;
    private String namespace;

    public QualifiedName(String name) {
        int pos = name.lastIndexOf(46);
        if (pos < 0) {
            this.name = name;
            this.namespace = "";
        } else {
            this.name = name.substring(pos + 1);
            this.namespace = name.substring(0, pos);
        }
    }

    public QualifiedName(String name, String namespace) {
        this.name = name;
        this.namespace = namespace;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.namespace == null ? that.namespace != null : !this.namespace.equals(that.namespace));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
        return result;
    }

    public String getFullName() {
        if (StringUtils.isEmpty(this.namespace)) {
            return this.name;
        }
        return this.namespace + "." + this.name;
    }

    public String toString() {
        return this.getFullName();
    }
}

