/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import org.drools.factmodel.traits.TypeLattice;
import org.drools.util.CodedHierarchyImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeHierarchy<T>
extends CodedHierarchyImpl<T>
implements TypeLattice<T>,
Externalizable {
    private BitSet bottom;
    private BitSet top;

    public TypeHierarchy() {
        this.top = new BitSet();
    }

    public TypeHierarchy(T topElement, BitSet topKey, T bottomElement, BitSet bottomKey) {
        this.top = topKey;
        this.bottom = bottomKey;
        this.addMember(topElement, topKey);
        this.addMember(bottomElement, bottomKey);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.bottom);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.bottom = (BitSet)objectInput.readObject();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("***************************************** \n");
        for (Object member : this.getSortedMembers()) {
            sb.append(member).append(" >>> ").append(this.getCode(member)).append("\n");
            sb.append("\t parents ").append(this.getNode(member).getParents()).append("\n ");
            sb.append("\t children ").append(this.getNode(member).getChildren()).append("\n ");
        }
        sb.append("***************************************** \n");
        return sb.toString();
    }

    @Override
    public BitSet getTopCode() {
        return this.top;
    }

    @Override
    public BitSet getBottomCode() {
        return this.bottom;
    }

    @Override
    public void setBottomCode(BitSet bottom) {
        this.bottom = bottom;
    }

    @Override
    public void setTopCode(BitSet top) {
        this.top = top;
    }
}

