/*
 * Decompiled with CFR 0.152.
 */
package org.drools.concurrent;

import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.drools.concurrent.ExecutorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorProviderImpl
implements ExecutorProvider {
    private static final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    });

    @Override
    public Executor getExecutor() {
        return executor;
    }

    @Override
    public <T> CompletionService<T> getCompletionService() {
        return new ExecutorCompletionService(this.getExecutor());
    }
}

