/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.AgendaItem;
import org.drools.common.InternalAgendaGroup;
import org.drools.common.InternalRuleBase;
import org.drools.core.util.BinaryHeapQueue;
import org.drools.core.util.Queueable;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;

public class BinaryHeapQueueAgendaGroup
implements InternalAgendaGroup {
    private static final long serialVersionUID = 510L;
    private String name;
    private BinaryHeapQueue queue;
    private boolean active;
    private PropagationContext autoFocusActivator;

    public BinaryHeapQueueAgendaGroup() {
    }

    public BinaryHeapQueueAgendaGroup(String name, InternalRuleBase ruleBase) {
        this.name = name;
        this.queue = new BinaryHeapQueue(ruleBase.getConfiguration().getConflictResolver());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.queue = (BinaryHeapQueue)in.readObject();
        this.active = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.queue);
        out.writeBoolean(this.active);
    }

    public String getName() {
        return this.name;
    }

    public void clear() {
        this.queue.clear();
    }

    public Activation[] getAndClear() {
        return this.queue.getAndClear();
    }

    public int size() {
        return this.queue.size();
    }

    public void add(Activation activation) {
        this.queue.enqueue((Queueable)activation);
    }

    public Activation getNext() {
        return this.queue.dequeue();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean activate) {
        this.active = activate;
    }

    public void setAutoFocusActivator(PropagationContext autoFocusActivator) {
        this.autoFocusActivator = autoFocusActivator;
    }

    public PropagationContext getAutoFocusActivator() {
        return this.autoFocusActivator;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public Activation[] getActivations() {
        return (Activation[])this.queue.toArray(new AgendaItem[this.queue.size()]);
    }

    public String toString() {
        return "AgendaGroup '" + this.name + "'";
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BinaryHeapQueueAgendaGroup)) {
            return false;
        }
        return ((BinaryHeapQueueAgendaGroup)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void setFocus() {
        throw new UnsupportedOperationException();
    }

    public void remove(AgendaItem agendaItem) {
        this.queue.dequeue(agendaItem.getIndex());
    }
}

