/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.toolbar;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.place.shared.Place;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.StatusChangePopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.ModuleEditorPlace;
import org.drools.guvnor.client.explorer.navigation.ClosePlaceEvent;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.ModuleNameValidator;
import org.drools.guvnor.client.moduleeditor.RefreshModuleListEvent;
import org.drools.guvnor.client.moduleeditor.drools.PackageBuilderWidget;
import org.drools.guvnor.client.moduleeditor.drools.SuggestionCompletionCache;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;
import org.drools.guvnor.client.widgets.drools.toolbar.GlobalAreaActionToolbarButtonsConfigurationProvider;
import org.drools.guvnor.client.widgets.drools.toolbar.PackageActionToolbarButtonsConfigurationProvider;
import org.drools.guvnor.client.widgets.toolbar.ActionToolbarButtonsConfigurationProvider;

public class PackageEditorActionToolbar
extends Composite {
    private static PackageEditorActionToolbarBinder uiBinder = (PackageEditorActionToolbarBinder)GWT.create(PackageEditorActionToolbarBinder.class);
    @UiField
    MenuItem saveChanges;
    @UiField
    MenuItem saveChangesAndClose;
    @UiField
    MenuItem archive;
    @UiField
    MenuItem delete;
    @UiField
    MenuItem copy;
    @UiField
    MenuItem rename;
    @UiField
    MenuItem promoteToGlobal;
    @UiField
    MenuItem selectWorkingSets;
    @UiField
    MenuItem validate;
    @UiField
    MenuItem verify;
    @UiField
    MenuItem viewSource;
    @UiField
    MenuItem changeStatus;
    @UiField
    Label status;
    @UiField
    MenuItem sourceMenu;
    private ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
    private ActionToolbarButtonsConfigurationProvider actionToolbarButtonsConfigurationProvider;
    private Module packageConfigData;
    private final EventBus eventBus;
    private final ClientFactory clientFactory;
    private Command refreshCommand;
    private boolean readOnly;

    public PackageEditorActionToolbar(Module data, ClientFactory clientFactory, EventBus eventBus, boolean readOnly, Command refreshCommand) {
        this.packageConfigData = data;
        this.eventBus = eventBus;
        this.clientFactory = clientFactory;
        this.readOnly = readOnly;
        this.refreshCommand = refreshCommand;
        this.actionToolbarButtonsConfigurationProvider = data.isGlobal() ? new GlobalAreaActionToolbarButtonsConfigurationProvider() : new PackageActionToolbarButtonsConfigurationProvider();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.setState(this.packageConfigData.getState());
        this.applyToolBarConfiguration();
        this.status.setVisible(this.actionToolbarButtonsConfigurationProvider.showStateLabel());
        this.initActionToolBar();
    }

    public void setState(String newStatus) {
        this.status.setText(Constants.INSTANCE.statusIs(newStatus));
    }

    private void applyToolBarConfiguration() {
        this.saveChanges.setVisible(this.actionToolbarButtonsConfigurationProvider.showSaveButton());
        this.saveChangesAndClose.setVisible(this.actionToolbarButtonsConfigurationProvider.showSaveAndCloseButton());
        this.validate.setVisible(this.actionToolbarButtonsConfigurationProvider.showValidateButton());
        this.verify.setVisible(this.actionToolbarButtonsConfigurationProvider.showVerifyButton());
        this.viewSource.setVisible(this.actionToolbarButtonsConfigurationProvider.showViewSourceButton());
        this.copy.setVisible(this.actionToolbarButtonsConfigurationProvider.showCopyButton());
        this.rename.setVisible(this.actionToolbarButtonsConfigurationProvider.showRenameButton());
        this.promoteToGlobal.setVisible(this.actionToolbarButtonsConfigurationProvider.showPromoteToGlobalButton());
        this.archive.setVisible(this.actionToolbarButtonsConfigurationProvider.showArchiveButton());
        this.delete.setVisible(this.actionToolbarButtonsConfigurationProvider.showDeleteButton());
        this.changeStatus.setVisible(this.actionToolbarButtonsConfigurationProvider.showChangeStatusButton());
        this.selectWorkingSets.setVisible(this.actionToolbarButtonsConfigurationProvider.showSelectWorkingSetsButton());
        this.sourceMenu.setVisible(this.areSourceMenuChildrenVisible());
    }

    private boolean areSourceMenuChildrenVisible() {
        return this.validate.isVisible() || this.verify.isVisible() || this.viewSource.isVisible();
    }

    public void setSelectWorkingSetsCommand(Command command) {
        this.selectWorkingSets.setCommand(command);
    }

    public void setViewSourceCommand(Command command) {
        this.viewSource.setCommand(command);
    }

    public void setVerifyCommand(Command command) {
        this.verify.setCommand(command);
    }

    public void setValidateCommand(Command command) {
        this.validate.setCommand(command);
    }

    public void setSaveChangesCommand(Command command) {
        this.saveChanges.setCommand(command);
    }

    public void setSaveChangesAndCloseCommand(Command command) {
        this.saveChangesAndClose.setCommand(command);
    }

    public void setChangeStatusCommand(Command command) {
        this.changeStatus.setCommand(command);
    }

    public void setDeleteVisible(boolean b) {
        this.delete.setVisible(b);
    }

    public void setArchiveVisible(boolean b) {
        this.archive.setVisible(b);
    }

    public void setArchiveCommand(final Command archiveCommand) {
        this.archive.setCommand(new Command(){

            public void execute() {
                if (Window.confirm((String)Constants.INSTANCE.AreYouSureYouWantToArchiveThisItem())) {
                    archiveCommand.execute();
                }
            }
        });
    }

    public void setCopyCommand(Command command) {
        this.copy.setCommand(command);
    }

    public void setRenameCommand(Command command) {
        this.rename.setCommand(command);
    }

    public void setDeleteCommand(final Command deleteCommand) {
        this.delete.setCommand(new Command(){

            public void execute() {
                if (Window.confirm((String)Constants.INSTANCE.DeleteAreYouSure())) {
                    deleteCommand.execute();
                }
            }
        });
    }

    public void setPromtToGlobalCommand(Command command) {
        this.promoteToGlobal.setCommand(command);
    }

    private void initActionToolBar() {
        if (this.readOnly) {
            this.setVisible(false);
        } else {
            this.setSaveChangesCommand(new Command(){

                public void execute() {
                    PackageEditorActionToolbar.this.doSave(null);
                }
            });
            this.setArchiveCommand(new Command(){

                public void execute() {
                    PackageEditorActionToolbar.this.doArchive();
                }
            });
            this.setCopyCommand(new Command(){

                public void execute() {
                    PackageEditorActionToolbar.this.doCopy();
                }
            });
            this.setRenameCommand(new Command(){

                public void execute() {
                    PackageEditorActionToolbar.this.doRename();
                }
            });
            this.setChangeStatusCommand(new Command(){

                public void execute() {
                    PackageEditorActionToolbar.this.showStatusChanger();
                }
            });
            this.setViewSourceCommand(new Command(){

                public void execute() {
                    PackageBuilderWidget.doBuildSource(PackageEditorActionToolbar.this.packageConfigData.getUuid(), PackageEditorActionToolbar.this.packageConfigData.getName());
                }
            });
        }
    }

    protected void showStatusChanger() {
        final StatusChangePopup pop = new StatusChangePopup(this.packageConfigData.getUuid(), true);
        pop.setChangeStatusEvent(new Command(){

            public void execute() {
                PackageEditorActionToolbar.this.setState(pop.getState());
            }
        });
        pop.show();
    }

    private void doRename() {
        final FormStylePopup pop = new FormStylePopup(DroolsGuvnorImages.INSTANCE.Wizard(), Constants.INSTANCE.RenameThePackage());
        pop.addRow((Widget)new HTML(Constants.INSTANCE.RenamePackageTip()));
        final TextBox name = new TextBox();
        pop.addAttribute(Constants.INSTANCE.NewPackageNameIs(), (Widget)name);
        Button ok = new Button(Constants.INSTANCE.OK());
        pop.addAttribute("", (Widget)ok);
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PackageEditorActionToolbar.this.moduleService.renameModule(PackageEditorActionToolbar.this.packageConfigData.getUuid(), name.getText(), (AsyncCallback)new GenericCallback<String>(){

                    public void onSuccess(String data) {
                        PackageEditorActionToolbar.this.completedRenaming(data);
                        pop.hide();
                    }
                });
            }
        });
        pop.show();
    }

    private void completedRenaming(String newAssetUUID) {
        Window.alert((String)Constants.INSTANCE.PackageRenamedSuccessfully());
        this.refreshPackageList();
        this.eventBus.fireEvent((GwtEvent)new ClosePlaceEvent((Place)new ModuleEditorPlace(newAssetUUID)));
        this.openModule(newAssetUUID);
    }

    private void openModule(String newAssetUUID) {
        this.clientFactory.getPlaceController().goTo((Place)new ModuleEditorPlace(newAssetUUID));
    }

    private void doCopy() {
        final FormStylePopup pop = new FormStylePopup(DroolsGuvnorImages.INSTANCE.Wizard(), Constants.INSTANCE.CopyThePackage());
        pop.addRow((Widget)new HTML(Constants.INSTANCE.CopyThePackageTip()));
        final TextBox name = new TextBox();
        pop.addAttribute(Constants.INSTANCE.NewPackageNameIs(), (Widget)name);
        Button ok = new Button(Constants.INSTANCE.OK());
        pop.addAttribute("", (Widget)ok);
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!ModuleNameValidator.validatePackageName((String)name.getText())) {
                    Window.alert((String)Constants.INSTANCE.NotAValidPackageName());
                    return;
                }
                LoadingPopup.showMessage((String)Constants.INSTANCE.PleaseWaitDotDotDot());
                PackageEditorActionToolbar.this.moduleService.copyModule(PackageEditorActionToolbar.this.packageConfigData.getName(), name.getText(), (AsyncCallback)new GenericCallback<String>(){

                    public void onSuccess(String uuid) {
                        PackageEditorActionToolbar.this.completedCopying(uuid);
                        pop.hide();
                    }
                });
            }
        });
        pop.show();
    }

    private void completedCopying(String newAssetUUID) {
        Window.alert((String)Constants.INSTANCE.PackageCopiedSuccessfully());
        this.refreshPackageList();
        this.openModule(newAssetUUID);
    }

    private void doSave(final Command refresh) {
        LoadingPopup.showMessage((String)Constants.INSTANCE.SavingPackageConfigurationPleaseWait());
        this.moduleService.saveModule(this.packageConfigData, (AsyncCallback)new GenericCallback<Void>(){

            public void onSuccess(Void data) {
                PackageEditorActionToolbar.this.refreshCommand.execute();
                LoadingPopup.showMessage((String)Constants.INSTANCE.PackageConfigurationUpdatedSuccessfullyRefreshingContentCache());
                SuggestionCompletionCache.getInstance().loadPackage(PackageEditorActionToolbar.this.packageConfigData.getName(), new Command(){

                    public void execute() {
                        if (refresh != null) {
                            refresh.execute();
                        }
                        LoadingPopup.close();
                    }
                });
            }
        });
    }

    private void doArchive() {
        this.packageConfigData.setArchived(true);
        Command ref = new Command(){

            public void execute() {
                PackageEditorActionToolbar.this.eventBus.fireEvent((GwtEvent)new ClosePlaceEvent((Place)new ModuleEditorPlace(PackageEditorActionToolbar.this.packageConfigData.getUuid())));
                PackageEditorActionToolbar.this.refreshPackageList();
            }
        };
        this.doSave(ref);
    }

    private void refreshPackageList() {
        this.eventBus.fireEvent((GwtEvent)new RefreshModuleListEvent());
    }

    static interface PackageEditorActionToolbarBinder
    extends UiBinder<Widget, PackageEditorActionToolbar> {
    }
}

