/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.tables;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.ProvidesKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.drools.guvnor.client.asseteditor.PropertyHolder;
import org.drools.guvnor.client.decisiontable.cells.PopupTextEditCell;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.AbstractPageRow;
import org.drools.guvnor.client.widgets.tables.AbstractSimpleTable;
import org.drools.guvnor.client.widgets.tables.ColumnPicker;
import org.drools.guvnor.client.widgets.tables.SelectionColumn;
import org.drools.guvnor.client.widgets.tables.SortableHeader;
import org.drools.guvnor.client.widgets.tables.SortableHeaderGroup;

public class PropertiesEditorSimpleTable
extends AbstractSimpleTable<PropertyHolderAdaptor> {
    private MultiSelectionModel<PropertyHolderAdaptor> selectionModel;
    private static PropertiesEditorSimpleTableBinder uiBinder = (PropertiesEditorSimpleTableBinder)GWT.create(PropertiesEditorSimpleTableBinder.class);
    @UiField
    Button addPropertyButton;
    @UiField
    Button deleteSelectedPropertiesButton;
    private List<PropertyHolderAdaptor> adaptedProperties = new ArrayList<PropertyHolderAdaptor>();

    public PropertiesEditorSimpleTable(List<PropertyHolder> properties) {
        this.adaptedProperties = this.adaptPropertyHolders(properties);
        this.setRowData(this.adaptedProperties);
        this.setRowCount(this.adaptedProperties.size());
    }

    public List<PropertyHolder> getPropertyHolders() {
        ArrayList<PropertyHolder> properties = new ArrayList<PropertyHolder>();
        for (PropertyHolderAdaptor pha : this.adaptedProperties) {
            properties.add(new PropertyHolder(pha.getName(), pha.getValue()));
        }
        return properties;
    }

    private List<PropertyHolderAdaptor> adaptPropertyHolders(List<PropertyHolder> properties) {
        ArrayList<PropertyHolderAdaptor> adaptedProperties = new ArrayList<PropertyHolderAdaptor>();
        for (PropertyHolder ph : properties) {
            adaptedProperties.add(new PropertyHolderAdaptor(ph));
        }
        return adaptedProperties;
    }

    protected void addAncillaryColumns(ColumnPicker<PropertyHolderAdaptor> columnPicker, SortableHeaderGroup<PropertyHolderAdaptor> sortableHeaderGroup) {
        Column<PropertyHolderAdaptor, String> propertyNameColumn = new Column<PropertyHolderAdaptor, String>((Cell)new PopupTextEditCell()){

            public String getValue(PropertyHolderAdaptor object) {
                return object.getName();
            }
        };
        propertyNameColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<PropertyHolderAdaptor, String>(){

            public void update(int index, PropertyHolderAdaptor object, String value) {
                object.setName(value);
            }
        });
        columnPicker.addColumn((Column)propertyNameColumn, (Header)new SortableHeader(sortableHeaderGroup, Constants.INSTANCE.Item(), (Column)propertyNameColumn), true);
        Column<PropertyHolderAdaptor, String> propertyValueColumn = new Column<PropertyHolderAdaptor, String>((Cell)new PopupTextEditCell()){

            public String getValue(PropertyHolderAdaptor object) {
                return object.getValue();
            }
        };
        propertyValueColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<PropertyHolderAdaptor, String>(){

            public void update(int index, PropertyHolderAdaptor object, String value) {
                object.setValue(value);
            }
        });
        columnPicker.addColumn((Column)propertyValueColumn, (Header)new SortableHeader(sortableHeaderGroup, Constants.INSTANCE.Value(), (Column)propertyValueColumn), true);
    }

    protected void doCellTable() {
        ProvidesKey<PropertyHolderAdaptor> providesKey = new ProvidesKey<PropertyHolderAdaptor>(){

            public Object getKey(PropertyHolderAdaptor row) {
                return row.getIndex();
            }
        };
        this.cellTable = new CellTable((ProvidesKey)providesKey);
        this.selectionModel = new MultiSelectionModel((ProvidesKey)providesKey);
        this.cellTable.setSelectionModel(this.selectionModel);
        SelectionColumn.createAndAddSelectionColumn((CellTable)this.cellTable);
        ColumnPicker columnPicker = new ColumnPicker(this.cellTable);
        SortableHeaderGroup sortableHeaderGroup = new SortableHeaderGroup(this.cellTable);
        this.addAncillaryColumns((ColumnPicker<PropertyHolderAdaptor>)columnPicker, (SortableHeaderGroup<PropertyHolderAdaptor>)sortableHeaderGroup);
        this.cellTable.setWidth("100%");
        this.columnPickerButton = columnPicker.createToggleButton();
    }

    protected Widget makeWidget() {
        return (Widget)uiBinder.createAndBindUi((Object)this);
    }

    @UiHandler(value={"addPropertyButton"})
    void addProperty(ClickEvent event) {
        this.adaptedProperties.add(new PropertyHolderAdaptor(new PropertyHolder("", "")));
        this.cellTable.setRowData(this.adaptedProperties);
        this.cellTable.setRowCount(this.adaptedProperties.size());
    }

    @UiHandler(value={"deleteSelectedPropertiesButton"})
    void deleteSelectedProperties(ClickEvent event) {
        Set selectedProperties = this.selectionModel.getSelectedSet();
        for (PropertyHolderAdaptor pha : selectedProperties) {
            this.adaptedProperties.remove((Object)pha);
        }
        this.selectionModel.clear();
        this.cellTable.setRowData(this.adaptedProperties);
        this.cellTable.setRowCount(this.adaptedProperties.size());
    }

    static class PropertyHolderAdaptor
    extends AbstractPageRow {
        static long counter = 0L;
        private long index;
        private PropertyHolder ph;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PropertyHolderAdaptor(PropertyHolder ph) {
            this.ph = ph;
            PropertyHolderAdaptor propertyHolderAdaptor = this;
            synchronized (propertyHolderAdaptor) {
                this.index = counter++;
            }
        }

        long getIndex() {
            return this.index;
        }

        String getName() {
            return this.ph.getName();
        }

        String getValue() {
            return this.ph.getValue();
        }

        void setName(String name) {
            this.ph.setName(name);
        }

        void setValue(String value) {
            this.ph.setValue(value);
        }
    }

    static interface PropertiesEditorSimpleTableBinder
    extends UiBinder<Widget, PropertiesEditorSimpleTable> {
    }
}

