/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.cells;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.decisiontable.cells.AbstractPopupEditCell;

public class PopupTextEditCell
extends AbstractPopupEditCell<String, String> {
    private final TextBox textBox = new TextBox();

    public PopupTextEditCell() {
        this(false);
    }

    public PopupTextEditCell(boolean isReadOnly) {
        super(isReadOnly);
        this.textBox.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                boolean keyEnter;
                boolean keyTab = event.getNativeKeyCode() == 9;
                boolean bl = keyEnter = event.getNativeKeyCode() == 13;
                if (keyTab || keyEnter) {
                    PopupTextEditCell.this.commit();
                }
            }
        });
        this.vPanel.add((Widget)this.textBox);
    }

    public void render(Cell.Context context, String value, SafeHtmlBuilder sb) {
        if (value != null) {
            sb.append(this.renderer.render((Object)value));
        }
    }

    @Override
    protected void commit() {
        String text = this.textBox.getValue();
        if (text.length() == 0) {
            text = null;
        }
        this.setValue(this.lastContext, this.lastParent, text);
        if (this.valueUpdater != null) {
            this.valueUpdater.update((Object)text);
        }
        this.panel.hide();
    }

    @Override
    protected void startEditing(Cell.Context context, final Element parent, String value) {
        this.textBox.setValue((Object)value);
        this.panel.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                PopupTextEditCell.this.panel.setPopupPosition(parent.getAbsoluteLeft() + PopupTextEditCell.this.offsetX, parent.getAbsoluteTop() + PopupTextEditCell.this.offsetY);
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        String text = PopupTextEditCell.this.textBox.getValue();
                        PopupTextEditCell.this.textBox.setFocus(true);
                        PopupTextEditCell.this.textBox.setCursorPos(text.length());
                        PopupTextEditCell.this.textBox.setSelectionRange(0, text.length());
                    }
                });
            }
        });
    }
}

